/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.ModifyModuleStatementUsageInfo;
import com.intellij.refactoring.move.moveClassesOrPackages.ModuleInfoUsageDetector;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

class ModuleInfoModifyUsageDetector
extends ModuleInfoUsageDetector {
    private final MoveDestination myMoveDestination;
    private final MultiMap<PsiJavaModule, PsiDirectory> myAbsentDirsByModuleDescriptor;

    ModuleInfoModifyUsageDetector(@NotNull Project project, PsiElement @NotNull [] elementsToMove, @NotNull MoveDestination moveDestination) {
        if (project == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(0);
        }
        if (moveDestination == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(1);
        }
        if (elementsToMove == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(2);
        }
        super(project, elementsToMove);
        this.myAbsentDirsByModuleDescriptor = MultiMap.create();
        this.myMoveDestination = moveDestination;
    }

    @Override
    public void detectModuleStatementsUsed(@NotNull List<? super UsageInfo> usageInfos, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (usageInfos == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(3);
        }
        if (conflicts == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(4);
        }
        if (this.mySourceClassesByDir.isEmpty()) {
            return;
        }
        MultiMap<PsiJavaModule, PsiDirectory> sourceDirsByModuleDescriptor = ModuleInfoModifyUsageDetector.groupDirsByModuleDescriptor(this.mySourceClassesByDir.keySet());
        if (sourceDirsByModuleDescriptor.isEmpty()) {
            return;
        }
        MultiMap absentDirsByModuleDescriptor = MultiMap.create();
        this.myAbsentDirsByModuleDescriptor.clear();
        this.detectModuleStatementsUsed(sourceDirsByModuleDescriptor, usageInfos, conflicts, (MultiMap<PsiJavaModule, PsiDirectory>)absentDirsByModuleDescriptor);
        this.myAbsentDirsByModuleDescriptor.putAllValues(absentDirsByModuleDescriptor);
    }

    @Override
    @NotNull
    public List<UsageInfo> createUsageInfosForNewlyCreatedDirs() {
        if (this.myAbsentDirsByModuleDescriptor.isEmpty()) {
            List<UsageInfo> list = Collections.emptyList();
            if (list == null) {
                ModuleInfoModifyUsageDetector.$$$reportNull$$$0(5);
            }
            return list;
        }
        SmartList result = new SmartList();
        this.detectModuleStatementsUsed(this.myAbsentDirsByModuleDescriptor, (List<? super UsageInfo>)result, (MultiMap<PsiElement, String>)MultiMap.create(), (MultiMap<PsiJavaModule, PsiDirectory>)MultiMap.create());
        SmartList smartList = result;
        if (smartList == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    private void detectModuleStatementsUsed(@NotNull MultiMap<PsiJavaModule, PsiDirectory> sourceDirsByModuleDescriptor, @NotNull List<? super UsageInfo> usageInfos, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull MultiMap<PsiJavaModule, PsiDirectory> absentDirsByModuleDescriptor) {
        if (sourceDirsByModuleDescriptor == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(7);
        }
        if (usageInfos == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(8);
        }
        if (conflicts == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(9);
        }
        if (absentDirsByModuleDescriptor == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(10);
        }
        PackageIndex packageIndex = PackageIndex.getInstance((Project)this.myProject);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        PsiPackage targetPackage = psiFacade.findPackage(this.myMoveDestination.getTargetPackage().getQualifiedName());
        for (Map.Entry entry : sourceDirsByModuleDescriptor.entrySet()) {
            PsiJavaModule sourceModuleDescriptor = (PsiJavaModule)entry.getKey();
            Collection sourceDirs = (Collection)entry.getValue();
            MultiMap<PsiPackage, PsiPackageAccessibilityStatement> sourceExports = ModuleInfoModifyUsageDetector.collectModuleStatements(sourceModuleDescriptor.getExports());
            MultiMap<PsiPackage, PsiPackageAccessibilityStatement> sourceOpens = ModuleInfoModifyUsageDetector.collectModuleStatements(sourceModuleDescriptor.getOpens());
            HashMap<PsiJavaModule, DirectoryWithModuleStatements> targetModuleStatementsByModuleDescriptor = new HashMap<PsiJavaModule, DirectoryWithModuleStatements>();
            for (PsiDirectory psiDirectory : sourceDirs) {
                PsiJavaModule targetModuleDescriptor;
                List<PsiPackageAccessibilityStatement> sourceStatements;
                PsiPackage sourcePkg;
                PsiDirectory targetDirectory = this.myMoveDestination.getTargetIfExists(psiDirectory);
                if (targetDirectory == null) {
                    absentDirsByModuleDescriptor.putValue((Object)sourceModuleDescriptor, (Object)psiDirectory);
                    continue;
                }
                String sourcePkgName = packageIndex.getPackageNameByDirectory(psiDirectory.getVirtualFile());
                if (sourcePkgName == null || (sourcePkg = psiFacade.findPackage(sourcePkgName)) == null || (sourceStatements = ModuleInfoModifyUsageDetector.findModuleStatementsForPkg(sourcePkg, sourceExports, sourceOpens)).isEmpty()) continue;
                Collection sourceClasses = this.mySourceClassesByDir.get((Object)psiDirectory);
                if (ModuleInfoModifyUsageDetector.dirContainsOnlyClasses(psiDirectory, sourceClasses)) {
                    sourceStatements.forEach(statement -> usageInfos.add(ModifyModuleStatementUsageInfo.createLastDeletionInfo(statement, sourceModuleDescriptor)));
                }
                if (sourceModuleDescriptor == (targetModuleDescriptor = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)targetDirectory))) {
                    DirectoryWithModuleStatements dirWithStatements = targetModuleStatementsByModuleDescriptor.computeIfAbsent(sourceModuleDescriptor, __ -> new DirectoryWithModuleStatements(targetDirectory, (List<PsiPackageAccessibilityStatement>)new SmartList()));
                    dirWithStatements.myModuleStatements.addAll(sourceStatements);
                    continue;
                }
                if (targetModuleDescriptor == null) continue;
                sourceClasses.forEach(c -> conflicts.put(c, List.of(JavaRefactoringBundle.message((String)"move.classes.or.packages.different.modules.exports.conflict", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)c, (boolean)false), StringUtil.htmlEmphasize((String)sourceModuleDescriptor.getName()), StringUtil.htmlEmphasize((String)targetModuleDescriptor.getName())}))));
            }
            for (Map.Entry entry2 : targetModuleStatementsByModuleDescriptor.entrySet()) {
                PsiJavaModule targetModuleDescriptor = (PsiJavaModule)entry2.getKey();
                List<PsiPackageAccessibilityStatement> sourceModuleStatements = ((DirectoryWithModuleStatements)entry2.getValue()).myModuleStatements;
                assert (targetPackage != null);
                List<PsiPackageAccessibilityStatement> targetPkgModuleStatements = ModuleInfoModifyUsageDetector.findModuleStatementsForPkg(targetModuleDescriptor, targetPackage);
                SmartList statementsToCreate = new SmartList();
                SmartList statementsToDelete = new SmartList();
                this.mergeModuleStatements(sourceModuleStatements, targetPkgModuleStatements, targetPackage, (List<PsiPackageAccessibilityStatement>)statementsToCreate, (List<PsiPackageAccessibilityStatement>)statementsToDelete);
                if (statementsToCreate.isEmpty()) continue;
                if (!ModuleInfoModifyUsageDetector.dirContainsOnlyClasses(((DirectoryWithModuleStatements)entry2.getValue()).myDir, Collections.emptyList())) {
                    conflicts.put((Object)targetModuleDescriptor.getNameIdentifier(), List.of(JavaRefactoringBundle.message((String)"move.classes.or.packages.new.module.exports.conflict", (Object[])new Object[]{StringUtil.htmlEmphasize((String)targetPackage.getQualifiedName())})));
                }
                statementsToDelete.stream().map(pkgStatement -> ModifyModuleStatementUsageInfo.createDeletionInfo(pkgStatement, targetModuleDescriptor)).forEach(usageInfos::add);
                statementsToCreate.stream().map(pkgStatement -> ModifyModuleStatementUsageInfo.createAdditionInfo(pkgStatement, targetModuleDescriptor)).forEach(usageInfos::add);
            }
        }
    }

    @NotNull
    private static List<PsiPackageAccessibilityStatement> findModuleStatementsForPkg(@NotNull PsiJavaModule moduleDescriptor, @NotNull PsiPackage psiPackage) {
        if (moduleDescriptor == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(11);
        }
        if (psiPackage == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(12);
        }
        MultiMap<PsiPackage, PsiPackageAccessibilityStatement> exports = ModuleInfoModifyUsageDetector.collectModuleStatements(moduleDescriptor.getExports());
        MultiMap<PsiPackage, PsiPackageAccessibilityStatement> opens = ModuleInfoModifyUsageDetector.collectModuleStatements(moduleDescriptor.getOpens());
        List<PsiPackageAccessibilityStatement> list = ModuleInfoModifyUsageDetector.findModuleStatementsForPkg(psiPackage, exports, opens);
        if (list == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(13);
        }
        return list;
    }

    private void mergeModuleStatements(@NotNull List<PsiPackageAccessibilityStatement> sourceStatements, @NotNull List<PsiPackageAccessibilityStatement> targetStatements, @NotNull PsiPackage targetPackage, @NotNull List<PsiPackageAccessibilityStatement> statementsToCreate, @NotNull List<PsiPackageAccessibilityStatement> statementsToDelete) {
        if (sourceStatements == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(14);
        }
        if (targetStatements == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(15);
        }
        if (targetPackage == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(16);
        }
        if (statementsToCreate == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(17);
        }
        if (statementsToDelete == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(18);
        }
        SmartList allModuleStatements = new SmartList(sourceStatements);
        allModuleStatements.addAll(targetStatements);
        EnumMap<PsiPackageAccessibilityStatement.Role, Set<String>> allModuleRefNamesByRole = new EnumMap<PsiPackageAccessibilityStatement.Role, Set<String>>(PsiPackageAccessibilityStatement.Role.class);
        for (PsiPackageAccessibilityStatement moduleStatement : allModuleStatements) {
            PsiPackageAccessibilityStatement.Role moduleStatementRole = moduleStatement.getRole();
            Set existingModuleRefNames = (Set)allModuleRefNamesByRole.get(moduleStatementRole);
            if (existingModuleRefNames == null) {
                allModuleRefNamesByRole.put(moduleStatementRole, new HashSet(moduleStatement.getModuleNames()));
                continue;
            }
            if (existingModuleRefNames.isEmpty()) continue;
            List moduleRefNames = moduleStatement.getModuleNames();
            if (moduleRefNames.isEmpty()) {
                existingModuleRefNames.clear();
                continue;
            }
            existingModuleRefNames.addAll(moduleRefNames);
        }
        ModuleInfoModifyUsageDetector.removeRedundantModuleStatements(targetStatements, statementsToDelete, allModuleRefNamesByRole);
        statementsToCreate.addAll(this.createNewModuleStatements(targetPackage, allModuleRefNamesByRole));
    }

    private static void removeRedundantModuleStatements(@NotNull List<PsiPackageAccessibilityStatement> sourceStatements, @NotNull List<PsiPackageAccessibilityStatement> statementsToDelete, @NotNull Map<PsiPackageAccessibilityStatement.Role, Set<String>> allModuleRefNamesByRole) {
        if (sourceStatements == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(19);
        }
        if (statementsToDelete == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(20);
        }
        if (allModuleRefNamesByRole == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(21);
        }
        EnumMap<PsiPackageAccessibilityStatement.Role, PsiPackageAccessibilityStatement> moduleStatementsByRole = new EnumMap<PsiPackageAccessibilityStatement.Role, PsiPackageAccessibilityStatement>(PsiPackageAccessibilityStatement.Role.class);
        for (PsiPackageAccessibilityStatement psiPackageAccessibilityStatement : sourceStatements) {
            moduleStatementsByRole.put(psiPackageAccessibilityStatement.getRole(), psiPackageAccessibilityStatement);
        }
        for (Map.Entry entry : moduleStatementsByRole.entrySet()) {
            PsiPackageAccessibilityStatement moduleStatement;
            PsiPackageAccessibilityStatement.Role role = (PsiPackageAccessibilityStatement.Role)entry.getKey();
            Set<String> moduleRefNames = allModuleRefNamesByRole.get(role);
            if (moduleRefNames.equals(new HashSet((moduleStatement = (PsiPackageAccessibilityStatement)entry.getValue()).getModuleNames()))) {
                allModuleRefNamesByRole.remove(role);
                continue;
            }
            statementsToDelete.add(moduleStatement);
        }
    }

    @NotNull
    private List<PsiPackageAccessibilityStatement> createNewModuleStatements(@NotNull PsiPackage targetPackage, @NotNull Map<PsiPackageAccessibilityStatement.Role, Set<String>> allModuleRefNamesByRole) {
        if (targetPackage == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(22);
        }
        if (allModuleRefNamesByRole == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(23);
        }
        SmartList result = new SmartList();
        PsiElementFactory psiFactory = PsiElementFactory.getInstance((Project)this.myProject);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)this.myProject);
        for (Map.Entry<PsiPackageAccessibilityStatement.Role, Set<String>> entry : allModuleRefNamesByRole.entrySet()) {
            String moduleStatementText = ModuleInfoModifyUsageDetector.formModuleStatementText(entry.getKey(), new TreeSet<String>((Collection)entry.getValue()), targetPackage.getQualifiedName());
            PsiPackageAccessibilityStatement moduleStatement = (PsiPackageAccessibilityStatement)psiFactory.createModuleStatementFromText(moduleStatementText, (PsiElement)targetPackage);
            result.add((PsiPackageAccessibilityStatement)styleManager.reformat((PsiElement)moduleStatement));
        }
        SmartList smartList = result;
        if (smartList == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(24);
        }
        return smartList;
    }

    @NotNull
    private static String formModuleStatementText(@NotNull PsiPackageAccessibilityStatement.Role role, @NotNull Set<String> moduleRefNames, @NotNull String packageName) {
        if (role == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(25);
        }
        if (moduleRefNames == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(26);
        }
        if (packageName == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(27);
        }
        String roleText = null;
        if (role == PsiPackageAccessibilityStatement.Role.EXPORTS) {
            roleText = "exports";
        } else if (role == PsiPackageAccessibilityStatement.Role.OPENS) {
            roleText = "opens";
        }
        assert (roleText != null);
        Object moduleRefsText = moduleRefNames.isEmpty() ? "" : " to " + String.join((CharSequence)",", moduleRefNames);
        String string = roleText + " " + packageName + (String)moduleRefsText;
        if (string == null) {
            ModuleInfoModifyUsageDetector.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 13, 24, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveDestination";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/ModuleInfoModifyUsageDetector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDirsByModuleDescriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absentDirsByModuleDescriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceStatements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetStatements";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackage";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementsToCreate";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementsToDelete";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModuleRefNamesByRole";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRefNames";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/ModuleInfoModifyUsageDetector";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfosForNewlyCreatedDirs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findModuleStatementsForPkg";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewModuleStatements";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "formModuleStatementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "detectModuleStatementsUsed";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 24: 
            case 28: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findModuleStatementsForPkg";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mergeModuleStatements";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundantModuleStatements";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createNewModuleStatements";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "formModuleStatementText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 13, 24, 28 -> new IllegalStateException(string);
        };
    }

    private static class DirectoryWithModuleStatements {
        @NotNull
        private final PsiDirectory myDir;
        @NotNull
        private final List<PsiPackageAccessibilityStatement> myModuleStatements;

        private DirectoryWithModuleStatements(@NotNull PsiDirectory dir, @NotNull List<PsiPackageAccessibilityStatement> moduleStatements) {
            if (dir == null) {
                DirectoryWithModuleStatements.$$$reportNull$$$0(0);
            }
            if (moduleStatements == null) {
                DirectoryWithModuleStatements.$$$reportNull$$$0(1);
            }
            this.myDir = dir;
            this.myModuleStatements = moduleStatements;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleStatements";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/move/moveClassesOrPackages/ModuleInfoModifyUsageDetector$DirectoryWithModuleStatements";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

