/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.HelpID;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.MoveDialogBase;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.move.moveClassesOrPackages.JavaMoveClassesOrPackagesHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.ui.ClassNameReferenceEditor;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesDialog
extends MoveDialogBase {
    private static final String RECENTS_KEY = "MoveClassesOrPackagesDialog.RECENTS_KEY";
    private static final Logger LOG = Logger.getInstance(MoveClassesOrPackagesDialog.class);
    private final PsiElement[] myElementsToMove;
    private final MoveCallback myMoveCallback;
    private final PsiManager myManager;
    private final boolean mySearchTextOccurrencesEnabled;
    private final boolean myTargetDirectoryFixed;
    private final boolean mySuggestToMoveToAnotherRoot;
    private final String myHelpID;
    private JLabel myNameLabel;
    private ReferenceEditorComboWithBrowseButton myWithBrowseButtonReference;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurrences;
    private JPanel myMainPanel;
    private JRadioButton myToPackageRadioButton;
    private JRadioButton myMakeInnerClassOfRadioButton;
    private ReferenceEditorComboWithBrowseButton myClassPackageChooser;
    private JPanel myCardPanel;
    private ReferenceEditorWithBrowseButton myInnerClassChooser;
    private JPanel myMoveClassPanel;
    private JPanel myMovePackagePanel;
    private ComboboxWithBrowseButton myDestinationFolderCB;
    private JPanel myTargetPanel;
    private JLabel myTargetDestinationLabel;
    private boolean myHavePackages;

    public MoveClassesOrPackagesDialog(@NotNull Project project, boolean searchTextOccurrences, PsiElement @NotNull [] elementsToMove, PsiElement initialTargetElement, MoveCallback moveCallback, @NotNull String targetPackageName, PsiDirectory initialTargetDirectory, boolean searchInComments, boolean searchForTextOccurrences) {
        String nameFromCallback;
        if (project == null) {
            MoveClassesOrPackagesDialog.$$$reportNull$$$0(0);
        }
        if (targetPackageName == null) {
            MoveClassesOrPackagesDialog.$$$reportNull$$$0(1);
        }
        if (elementsToMove == null) {
            MoveClassesOrPackagesDialog.$$$reportNull$$$0(2);
        }
        super(project, true, MoveClassesOrPackagesDialog.canBeOpenedInEditor(elementsToMove));
        this.myElementsToMove = elementsToMove;
        this.myMoveCallback = moveCallback;
        this.$$$setupUI$$$();
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.setTitle(MoveHandler.getRefactoringName());
        this.mySearchTextOccurrencesEnabled = searchTextOccurrences;
        this.selectInitialCard();
        this.init();
        if (initialTargetElement instanceof PsiClass) {
            this.myMakeInnerClassOfRadioButton.setSelected(true);
            String qualifiedName = ((PsiClass)initialTargetElement).getQualifiedName();
            assert (qualifiedName != null) : initialTargetElement;
            this.myInnerClassChooser.setText(qualifiedName);
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myInnerClassChooser, true)), ModalityState.stateForComponent((Component)this.myMainPanel));
        } else if (initialTargetElement instanceof PsiPackage) {
            this.myClassPackageChooser.setText(((PsiPackage)initialTargetElement).getQualifiedName());
        }
        this.updateControlsEnabled();
        this.myToPackageRadioButton.addActionListener(e -> {
            this.updateControlsEnabled();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myClassPackageChooser, true));
        });
        this.myMakeInnerClassOfRadioButton.addActionListener(e -> {
            this.updateControlsEnabled();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myInnerClassChooser, true));
        });
        this.myTargetDirectoryFixed = initialTargetDirectory == null;
        boolean bl = this.mySuggestToMoveToAnotherRoot = initialTargetElement == null;
        if (!targetPackageName.isEmpty()) {
            this.myWithBrowseButtonReference.prependItem(targetPackageName);
            this.myClassPackageChooser.prependItem(targetPackageName);
        }
        String string = nameFromCallback = this.myMoveCallback instanceof MoveClassesOrPackagesCallback ? ((MoveClassesOrPackagesCallback)this.myMoveCallback).getElementsToMoveName() : null;
        if (nameFromCallback != null) {
            this.myNameLabel.setText(nameFromCallback);
        } else if (elementsToMove.length == 1) {
            PsiElement firstElement = elementsToMove[0];
            if (firstElement instanceof PsiClass) {
                LOG.assertTrue(!MoveClassesOrPackagesImpl.isClassInnerOrLocal((PsiClass)firstElement));
            } else {
                PsiElement parent = firstElement.getParent();
                LOG.assertTrue(parent != null);
            }
            this.myNameLabel.setText(JavaRefactoringBundle.message((String)"move.single.class.or.package.name.label", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)firstElement), UsageViewUtil.getLongName((PsiElement)firstElement)}));
        } else if (elementsToMove.length > 1) {
            this.myNameLabel.setText(JavaRefactoringBundle.message((String)(elementsToMove[0] instanceof PsiClass ? "move.specified.classes" : "move.specified.packages"), (Object[])new Object[0]));
        }
        this.selectInitialCard();
        this.myCbSearchInComments.setSelected(searchInComments);
        this.myCbSearchTextOccurrences.setSelected(searchForTextOccurrences);
        if (initialTargetDirectory != null && JavaMoveClassesOrPackagesHandler.packageHasMultipleDirectoriesInModule(this.myProject, initialTargetDirectory)) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            HashSet initialRoots = new HashSet();
            MoveClassesOrPackagesDialog.collectSourceRoots(elementsToMove, fileIndex, initialRoots);
            if (initialRoots.size() > 1) {
                initialTargetDirectory = null;
            }
        }
        Consumer<String> updater = s -> {
            this.setErrorText((String)s, (JComponent)this.myDestinationFolderCB);
            if (s == null) {
                this.validateButtons();
            }
        };
        this.validateButtons();
        EditorComboBox comboBox = this.myHavePackages ? (EditorComboBox)this.myWithBrowseButtonReference.getChildComponent() : (EditorComboBox)this.myClassPackageChooser.getChildComponent();
        ((DestinationFolderComboBox)this.myDestinationFolderCB).setData(this.myProject, initialTargetDirectory, updater, comboBox);
        UIUtil.setEnabled((Component)this.myTargetPanel, (!this.getSourceRoots().isEmpty() && this.isMoveToPackage() && !this.myTargetDirectoryFixed ? 1 : 0) != 0, (boolean)true);
        this.myHelpID = HelpID.getMoveHelpID((PsiElement)elementsToMove[0]);
    }

    static boolean canBeOpenedInEditor(PsiElement @NotNull [] elementsToMove) {
        if (elementsToMove == null) {
            MoveClassesOrPackagesDialog.$$$reportNull$$$0(3);
        }
        for (PsiElement element : elementsToMove) {
            if (element.getContainingFile() == null) continue;
            return true;
        }
        return false;
    }

    private void updateControlsEnabled() {
        this.myClassPackageChooser.setEnabled(this.myToPackageRadioButton.isSelected());
        this.myInnerClassChooser.setEnabled(this.myMakeInnerClassOfRadioButton.isSelected());
        UIUtil.setEnabled((Component)this.myTargetPanel, (this.isMoveToPackage() && this.getSourceRoots().size() > 1 && !this.myTargetDirectoryFixed ? 1 : 0) != 0, (boolean)true);
        this.validateButtons();
    }

    private void selectInitialCard() {
        this.myHavePackages = false;
        for (PsiElement psiElement : this.myElementsToMove) {
            if (psiElement instanceof PsiClass) continue;
            this.myHavePackages = true;
            break;
        }
        CardLayout cardLayout = (CardLayout)this.myCardPanel.getLayout();
        cardLayout.show(this.myCardPanel, this.myHavePackages ? "Package" : "Class");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHavePackages ? this.myWithBrowseButtonReference.getChildComponent() : this.myClassPackageChooser.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        boolean isDestinationVisible = this.getSourceRoots().size() > 1;
        this.myDestinationFolderCB.setVisible(isDestinationVisible);
        this.myTargetDestinationLabel.setVisible(isDestinationVisible);
        return null;
    }

    private void createUIComponents() {
        this.myWithBrowseButtonReference = this.createPackageChooser();
        this.myClassPackageChooser = this.createPackageChooser();
        GlobalSearchScope scope = JavaProjectRootsUtil.getScopeWithoutGeneratedSources((GlobalSearchScope)ProjectScope.getProjectScope((Project)this.myProject), (Project)this.myProject);
        this.myInnerClassChooser = new ClassNameReferenceEditor(this.myProject, null, scope);
        this.myInnerClassChooser.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                MoveClassesOrPackagesDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesDialog$1", "documentChanged"));
            }
        });
        this.myCardPanel = new JPanel(){

            @Override
            public Dimension getMinimumSize() {
                return MoveClassesOrPackagesDialog.this.myHavePackages ? MoveClassesOrPackagesDialog.this.myMovePackagePanel.getMinimumSize() : MoveClassesOrPackagesDialog.this.myMoveClassPanel.getMinimumSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return MoveClassesOrPackagesDialog.this.myHavePackages ? MoveClassesOrPackagesDialog.this.myMovePackagePanel.getPreferredSize() : MoveClassesOrPackagesDialog.this.myMoveClassPanel.getPreferredSize();
            }
        };
        this.myDestinationFolderCB = new DestinationFolderComboBox(){

            public String getTargetPackage() {
                return MoveClassesOrPackagesDialog.this.getTargetPackage();
            }
        };
    }

    private ReferenceEditorComboWithBrowseButton createPackageChooser() {
        PackageNameReferenceEditorCombo packageChooser = new PackageNameReferenceEditorCombo("", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        Document document = ((EditorComboBox)packageChooser.getChildComponent()).getDocument();
        document.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                MoveClassesOrPackagesDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesDialog$4", "documentChanged"));
            }
        });
        return packageChooser;
    }

    protected JComponent createNorthPanel() {
        if (!this.mySearchTextOccurrencesEnabled) {
            this.myCbSearchTextOccurrences.setEnabled(false);
            this.myCbSearchTextOccurrences.setVisible(false);
            this.myCbSearchTextOccurrences.setSelected(false);
        }
        return this.myMainPanel;
    }

    protected String getHelpId() {
        return this.myHelpID;
    }

    protected String getDimensionServiceKey() {
        return this.myHavePackages ? "#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog.packages" : "#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog.classes";
    }

    private static void collectSourceRoots(PsiElement[] psiElements, ProjectFileIndex fileIndex, Set<? super VirtualFile> initialRoots) {
        for (PsiElement element : psiElements) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file != null) {
                VirtualFile sourceRootForFile = fileIndex.getSourceRootForFile(file);
                if (sourceRootForFile == null) continue;
                initialRoots.add((VirtualFile)sourceRootForFile);
                continue;
            }
            if (!(element instanceof PsiDirectoryContainer)) continue;
            MoveClassesOrPackagesDialog.collectSourceRoots((PsiElement[])((PsiDirectoryContainer)element).getDirectories(), fileIndex, initialRoots);
        }
    }

    protected final boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    protected void canRun() throws ConfigurationException {
        if (this.isMoveToPackage()) {
            String name = this.getTargetPackage().trim();
            if (!name.isEmpty() && !PsiNameHelper.getInstance((Project)this.myManager.getProject()).isQualifiedName(name)) {
                throw new ConfigurationException(JavaBundle.message((String)"move.classes.invalid.destination.package.name.message", (Object[])new Object[]{name}));
            }
        } else {
            if (this.findTargetClass() == null) {
                throw new ConfigurationException(JavaBundle.message((String)"move.classes.destination.class.not.found.message", (Object[])new Object[0]));
            }
            String validationError = this.verifyInnerClassDestination();
            if (validationError != null) {
                throw new ConfigurationException(validationError);
            }
        }
    }

    protected void validateButtons() {
        this.validateButtonsAsync(ModalityState.stateForComponent((Component)this.myMainPanel));
    }

    @Nullable
    private PsiClass findTargetClass() {
        String name = this.myInnerClassChooser.getText().trim();
        return JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(name, ProjectScope.getProjectScope((Project)this.myProject));
    }

    protected boolean isMoveToPackage() {
        return this.myHavePackages || this.myToPackageRadioButton.isSelected();
    }

    protected String getTargetPackage() {
        return this.myHavePackages ? this.myWithBrowseButtonReference.getText() : this.myClassPackageChooser.getText();
    }

    @NlsContexts.DialogMessage
    @Nullable
    private static String verifyDestinationForElement(@NotNull PsiElement element, @NotNull MoveDestination moveDestination) {
        if (element == null) {
            MoveClassesOrPackagesDialog.$$$reportNull$$$0(4);
        }
        if (moveDestination == null) {
            MoveClassesOrPackagesDialog.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = element;
        Objects.requireNonNull(psiElement);
        PsiElement psiElement2 = psiElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiDirectory.class, PsiPackage.class}, (Object)psiElement2, n)) {
            case 0 -> {
                PsiDirectory directory = (PsiDirectory)psiElement2;
                yield moveDestination.verify(directory);
            }
            case 1 -> {
                PsiPackage aPackage = (PsiPackage)psiElement2;
                yield moveDestination.verify(aPackage);
            }
            default -> moveDestination.verify(element.getContainingFile());
        };
    }

    protected void doAction() {
        if (this.isMoveToPackage()) {
            this.invokeMoveToPackage();
        } else {
            this.invokeMoveToInner();
        }
    }

    private void invokeMoveToPackage() {
        MoveDestination destination = this.selectDestination();
        if (destination == null) {
            return;
        }
        this.saveRefactoringSettings();
        for (PsiElement element : this.myElementsToMove) {
            String message = MoveClassesOrPackagesDialog.verifyDestinationForElement(element, destination);
            if (message == null) continue;
            String helpId = HelpID.getMoveHelpID((PsiElement)this.myElementsToMove[0]);
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)message, (String)helpId, (Project)this.getProject());
            return;
        }
        try {
            for (PsiElement element : this.myElementsToMove) {
                if (!(element instanceof PsiClass)) continue;
                PsiClass aClass = (PsiClass)element;
                LOG.assertTrue(aClass.isPhysical(), (Object)aClass);
                PsiDirectory targetDirectory = destination.getTargetIfExists(element.getContainingFile());
                if (targetDirectory == null) continue;
                MoveFilesOrDirectoriesUtil.checkMove((PsiElement)aClass, (PsiElement)targetDirectory);
            }
            MoveClassesOrPackagesProcessor processor = this.createMoveToPackageProcessor(destination, this.myElementsToMove, this.myMoveCallback);
            if (processor.verifyValidPackageName()) {
                processor.setOpenInEditor(this.isOpenInEditor());
                this.invokeRefactoring(processor);
            }
        }
        catch (IncorrectOperationException e) {
            String helpId = HelpID.getMoveHelpID((PsiElement)this.myElementsToMove[0]);
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), (String)helpId, (Project)this.getProject());
        }
    }

    protected MoveClassesOrPackagesProcessor createMoveToPackageProcessor(@NotNull MoveDestination destination, PsiElement @NotNull [] elementsToMove, MoveCallback callback) {
        if (destination == null) {
            MoveClassesOrPackagesDialog.$$$reportNull$$$0(6);
        }
        if (elementsToMove == null) {
            MoveClassesOrPackagesDialog.$$$reportNull$$$0(7);
        }
        return new MoveClassesOrPackagesProcessor(this.getProject(), elementsToMove, destination, this.isSearchInComments(), this.isSearchInNonJavaFiles(), callback);
    }

    private void saveRefactoringSettings() {
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        refactoringSettings.MOVE_SEARCH_IN_COMMENTS = this.isSearchInComments();
        refactoringSettings.MOVE_SEARCH_FOR_TEXT = this.isSearchInNonJavaFiles();
    }

    @NlsContexts.DialogMessage
    @Nullable
    private String verifyInnerClassDestination() {
        PsiClass targetClass = this.findTargetClass();
        if (targetClass == null) {
            return null;
        }
        for (PsiElement element : this.myElementsToMove) {
            if (PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)targetClass, (boolean)false)) {
                return JavaRefactoringBundle.message((String)"move.class.to.inner.move.to.self.error", (Object[])new Object[0]);
            }
            Language targetClassLanguage = targetClass.getLanguage();
            if (element.getLanguage().equals(targetClassLanguage)) continue;
            return RefactoringBundle.message((String)"move.to.different.language", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)element), ((PsiClass)element).getQualifiedName(), targetClass.getQualifiedName()});
        }
        while (targetClass != null) {
            if (targetClass.getContainingClass() != null && !targetClass.hasModifierProperty("static")) {
                return JavaRefactoringBundle.message((String)"move.class.to.inner.nonstatic.error", (Object[])new Object[0]);
            }
            targetClass = targetClass.getContainingClass();
        }
        return null;
    }

    private void invokeMoveToInner() {
        this.saveRefactoringSettings();
        String message = JavaRefactoringBundle.message((String)"move.class.to.inner.find.target.class.progress", (Object[])new Object[0]);
        PsiClass targetClass = (PsiClass)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (PsiClass)ReadAction.compute(() -> this.findTargetClass()), message, true, this.myProject);
        if (targetClass == null) {
            return;
        }
        PsiClass[] classesToMove = new PsiClass[this.myElementsToMove.length];
        for (int i = 0; i < this.myElementsToMove.length; ++i) {
            classesToMove[i] = (PsiClass)this.myElementsToMove[i];
        }
        MoveClassToInnerProcessor processor = this.createMoveToInnerProcessor(targetClass, classesToMove, this.myMoveCallback);
        processor.setOpenInEditor(this.isOpenInEditor());
        this.invokeRefactoring(processor);
    }

    protected MoveClassToInnerProcessor createMoveToInnerProcessor(@NotNull PsiClass destination, PsiClass @NotNull [] classesToMove, @Nullable MoveCallback callback) {
        if (destination == null) {
            MoveClassesOrPackagesDialog.$$$reportNull$$$0(8);
        }
        if (classesToMove == null) {
            MoveClassesOrPackagesDialog.$$$reportNull$$$0(9);
        }
        return new MoveClassToInnerProcessor(this.getProject(), classesToMove, destination, this.isSearchInComments(), this.isSearchInNonJavaFiles(), callback);
    }

    protected final boolean isSearchInNonJavaFiles() {
        return this.myCbSearchTextOccurrences.isSelected();
    }

    @Nullable
    private MoveDestination selectDestination() {
        int ret;
        int res;
        String packageName = this.getTargetPackage().trim();
        if (!packageName.isEmpty() && !PsiNameHelper.getInstance((Project)this.myManager.getProject()).isQualifiedName(packageName)) {
            Messages.showErrorDialog((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"please.enter.a.valid.target.package.name", (Object[])new Object[0]), (String)RefactoringBundle.message((String)"move.title"));
            return null;
        }
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, packageName);
        PackageWrapper targetPackage = new PackageWrapper(this.myManager, packageName);
        if (!targetPackage.exists() && (this.isPreviewUsages() ? (res = Messages.showOkCancelDialog((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"package.does.not.exist.preview", (Object[])new Object[]{packageName}), (String)RefactoringBundle.message((String)"move.title"), (String)CommonBundle.getOkButtonText(), (String)CommonBundle.getCancelButtonText(), null)) != 0 : (ret = Messages.showYesNoDialog((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"package.does.not.exist", (Object[])new Object[]{packageName}), (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon())) != 0)) {
            return null;
        }
        return ((DestinationFolderComboBox)this.myDestinationFolderCB).selectDirectory(targetPackage, this.mySuggestToMoveToAnotherRoot);
    }

    private List<VirtualFile> getSourceRoots() {
        return JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)this.myProject);
    }

    @Override
    @NotNull
    protected String getRefactoringId() {
        return "MoveClass";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackageName";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveDestination";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesToMove";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeOpenedInEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "verifyDestinationForElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createMoveToPackageProcessor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createMoveToInnerProcessor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        JLabel jLabel2;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNameLabel = jLabel2 = new JLabel();
        ((Component)jLabel2).setEnabled(true);
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel2.getFont());
        if (font != null) {
            jLabel2.setFont(font);
        }
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", MoveClassesOrPackagesDialog.class).getString("move.classes.or.packages.title"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.myCbSearchInComments = nonFocusableCheckBox;
        nonFocusableCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, DynamicBundle.getBundle((String)"messages/RefactoringBundle", MoveClassesOrPackagesDialog.class).getString("search.in.comments.and.strings"));
        jPanel4.add((Component)nonFocusableCheckBox, new GridConstraints(2, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.myCbSearchTextOccurrences = nonFocusableCheckBox2;
        nonFocusableCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, DynamicBundle.getBundle((String)"messages/RefactoringBundle", MoveClassesOrPackagesDialog.class).getString("search.for.text.occurrences"));
        jPanel4.add((Component)nonFocusableCheckBox2, new GridConstraints(2, 1, 1, 1, 8, 3, 0, 0, null, null, null));
        JPanel jPanel5 = this.myCardPanel;
        jPanel5.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myMoveClassPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(7, 0, 7, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, "Class");
        this.myToPackageRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", MoveClassesOrPackagesDialog.class).getString("move.classes.destination.to.package"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMakeInnerClassOfRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", MoveClassesOrPackagesDialog.class).getString("move.classes.destination.make.inner"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.myClassPackageChooser;
        jPanel3.add((Component)referenceEditorComboWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        ReferenceEditorWithBrowseButton referenceEditorWithBrowseButton = this.myInnerClassChooser;
        jPanel3.add((Component)referenceEditorWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myMovePackagePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(7, 0, 7, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, "Package");
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.myWithBrowseButtonReference;
        jPanel2.add((Component)referenceEditorComboWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", MoveClassesOrPackagesDialog.class).getString("move.classes.destination.package.prompt"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTargetPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTargetDestinationLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RefactoringBundle", MoveClassesOrPackagesDialog.class).getString("target.destination.folder"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myDestinationFolderCB;
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor((Component)comboboxWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

