/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.DirectoryChooser;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.HelpID;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.rename.DirectoryAsPackageRenameHandlerBase;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public final class MoveClassesOrPackagesImpl {
    private static final Logger LOG = Logger.getInstance(MoveClassesOrPackagesImpl.class);

    public static void doMove(Project project, PsiElement[] adjustedElements, PsiElement initialTargetElement, MoveCallback moveCallback) {
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(adjustedElements), (boolean)true)) {
            return;
        }
        String initialTargetPackageName = MoveClassesOrPackagesImpl.getInitialTargetPackageName(initialTargetElement, adjustedElements);
        PsiDirectory initialTargetDirectory = MoveClassesOrPackagesImpl.getInitialTargetDirectory(initialTargetElement, adjustedElements);
        boolean searchTextOccurrences = Stream.of(adjustedElements).anyMatch(TextOccurrencesUtil::isSearchTextOccurrencesEnabled);
        boolean searchInComments = JavaRefactoringSettings.getInstance().MOVE_SEARCH_IN_COMMENTS;
        boolean searchForTextOccurrences = JavaRefactoringSettings.getInstance().MOVE_SEARCH_FOR_TEXT;
        new MoveClassesOrPackagesDialog(project, searchTextOccurrences, adjustedElements, initialTargetElement, moveCallback, initialTargetPackageName, initialTargetDirectory, searchInComments, searchForTextOccurrences).show();
    }

    public static PsiElement @Nullable [] adjustForMove(Project project, PsiElement[] elements, PsiElement targetElement) {
        PsiElement[] psiElements = new PsiElement[elements.length];
        ArrayList<String> names = new ArrayList<String>();
        for (int idx = 0; idx < elements.length; ++idx) {
            PsiElement element = elements[idx];
            if (element instanceof PsiDirectory) {
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
                LOG.assertTrue(aPackage != null);
                if (aPackage.getQualifiedName().isEmpty()) {
                    message = JavaRefactoringBundle.message((String)"move.package.refactoring.cannot.be.applied.to.default.package", (Object[])new Object[0]);
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, (String)HelpID.getMoveHelpID((PsiElement)element), (Project)project);
                    return null;
                }
                if (!MoveClassesOrPackagesImpl.checkNesting(project, aPackage, targetElement, true)) {
                    return null;
                }
                if (!MoveClassesOrPackagesImpl.isAlreadyChecked(psiElements, idx, aPackage) && !MoveClassesOrPackagesImpl.checkMovePackage(project, aPackage, (PsiDirectory)element)) {
                    return null;
                }
                element = aPackage;
            } else if (element instanceof PsiPackage) {
                PsiPackage psiPackage = (PsiPackage)element;
                if (!MoveClassesOrPackagesImpl.checkNesting(project, psiPackage, targetElement, true)) {
                    return null;
                }
                if (!MoveClassesOrPackagesImpl.checkMovePackage(project, psiPackage, null)) {
                    return null;
                }
            } else if (element instanceof PsiClass) {
                MoveClassHandler nameProvider;
                String message;
                PsiClass aClass = (PsiClass)element;
                if (aClass instanceof PsiAnonymousClass) {
                    message = JavaRefactoringBundle.message((String)"move.class.refactoring.cannot.be.applied.to.anonymous.classes", (Object[])new Object[0]);
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, (String)HelpID.getMoveHelpID((PsiElement)element), (Project)project);
                    return null;
                }
                if (MoveClassesOrPackagesImpl.isClassInnerOrLocal(aClass)) {
                    message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"moving.local.classes.is.not.supported", (Object[])new Object[0]));
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, (String)HelpID.getMoveHelpID((PsiElement)element), (Project)project);
                    return null;
                }
                String name = null;
                message = (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions();
                int n = ((MoveClassHandler[])message).length;
                for (int i = 0; i < n && (name = (nameProvider = message[i]).getName(aClass)) == null; ++i) {
                }
                if (name == null) {
                    name = aClass.getContainingFile().getName();
                }
                if (names.contains(name)) {
                    message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"there.are.going.to.be.multiple.destination.files.with.the.same.name", (Object[])new Object[0]));
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)message, (String)HelpID.getMoveHelpID((PsiElement)element), (Project)project);
                    return null;
                }
                names.add(name);
            }
            psiElements[idx] = element;
        }
        return psiElements;
    }

    static boolean isClassInnerOrLocal(PsiClass aClass) {
        return aClass.getContainingClass() != null || aClass.getQualifiedName() == null;
    }

    private static boolean isAlreadyChecked(PsiElement[] psiElements, int idx, PsiPackage aPackage) {
        for (int i = 0; i < idx; ++i) {
            if (!Comparing.equal((Object)psiElements[i], (Object)aPackage)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkMovePackage(Project project, PsiPackage aPackage, @Nullable PsiDirectory currentDirectory) {
        PsiDirectory[] directories = aPackage.getDirectories();
        VirtualFile[] virtualFiles = aPackage.occursInPackagePrefixes();
        if (directories.length > 1 || virtualFiles.length > 0) {
            @Nls StringBuffer message = new StringBuffer();
            RenameUtil.buildPackagePrefixChangedMessage((VirtualFile[])virtualFiles, (StringBuffer)message, (String)aPackage.getQualifiedName());
            if (directories.length > 1) {
                DirectoryAsPackageRenameHandlerBase.buildMultipleDirectoriesInPackageMessage((StringBuffer)message, (String)aPackage.getQualifiedName(), (PsiDirectory[])directories, (PsiDirectory)currentDirectory);
                message.append("\n\n");
                String report = JavaRefactoringBundle.message((String)"all.these.directories.will.be.moved.and.all.references.to.0.will.be.changed", (Object[])new Object[]{aPackage.getQualifiedName()});
                message.append(report);
            }
            message.append("\n");
            message.append(RefactoringBundle.message((String)"do.you.wish.to.continue"));
            String resultMessage = message.toString();
            int ret = Messages.showYesNoDialog((Project)project, (String)resultMessage, (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getQuestionIcon());
            if (ret != 0) {
                return false;
            }
        }
        return true;
    }

    static boolean checkNesting(Project project, PsiPackage srcPackage, PsiElement targetElement, boolean showError) {
        PsiPackage targetPackage;
        for (PsiPackage curPackage = targetPackage = targetElement instanceof PsiPackage ? (PsiPackage)targetElement : (targetElement instanceof PsiDirectory ? JavaDirectoryService.getInstance().getPackage((PsiDirectory)targetElement) : null); curPackage != null; curPackage = curPackage.getParentPackage()) {
            if (!curPackage.equals((Object)srcPackage)) continue;
            if (showError) {
                CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"move.title"), (String)JavaRefactoringBundle.message((String)"cannot.move.package.into.itself", (Object[])new Object[0]), (String)HelpID.getMoveHelpID((PsiElement)srcPackage), (Project)project);
            }
            return false;
        }
        return true;
    }

    public static String getInitialTargetPackageName(PsiElement initialTargetElement, PsiElement[] movedElements) {
        String name = MoveClassesOrPackagesImpl.getContainerPackageName(initialTargetElement);
        if (name == null) {
            PsiDirectory commonDirectory;
            if (movedElements != null) {
                name = MoveClassesOrPackagesImpl.getTargetPackageNameForMovedElement(movedElements[0]);
            }
            if (name == null && (commonDirectory = MoveClassesOrPackagesImpl.getCommonDirectory(movedElements)) != null && JavaDirectoryService.getInstance().getPackage(commonDirectory) != null) {
                name = JavaDirectoryService.getInstance().getPackage(commonDirectory).getQualifiedName();
            }
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    @Nullable
    private static PsiDirectory getCommonDirectory(PsiElement[] movedElements) {
        PsiDirectory commonDirectory = null;
        for (PsiElement movedElement : movedElements) {
            PsiDirectory containingDirectory;
            PsiFile containingFile = movedElement.getContainingFile();
            if (containingFile == null || (containingDirectory = containingFile.getContainingDirectory()) == null) continue;
            if (commonDirectory == null) {
                commonDirectory = containingDirectory;
                continue;
            }
            if (commonDirectory == containingDirectory) continue;
            return null;
        }
        if (commonDirectory != null) {
            return commonDirectory;
        }
        return null;
    }

    private static String getContainerPackageName(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiPackage.class, PsiDirectory.class}, (Object)psiElement2, n)) {
            case -1 -> null;
            case 0 -> {
                PsiPackage psiPackage = (PsiPackage)psiElement2;
                yield psiPackage.getQualifiedName();
            }
            case 1 -> {
                PsiDirectory directory = (PsiDirectory)psiElement2;
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
                if (aPackage != null) {
                    yield aPackage.getQualifiedName();
                }
                yield "";
            }
            default -> {
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(psiElement.getContainingFile().getContainingDirectory());
                if (aPackage != null) {
                    yield aPackage.getQualifiedName();
                }
                yield "";
            }
        };
    }

    private static String getTargetPackageNameForMovedElement(PsiElement psiElement) {
        if (psiElement instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)psiElement;
            PsiPackage parentPackage = psiPackage.getParentPackage();
            return parentPackage != null ? parentPackage.getQualifiedName() : "";
        }
        if (psiElement instanceof PsiDirectory) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement);
            return aPackage != null ? MoveClassesOrPackagesImpl.getTargetPackageNameForMovedElement((PsiElement)aPackage) : "";
        }
        if (psiElement != null) {
            PsiDirectory directory = PlatformPackageUtil.getDirectory((PsiElement)psiElement);
            PsiPackage aPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
            return aPackage != null ? aPackage.getQualifiedName() : "";
        }
        return null;
    }

    public static PsiDirectory getInitialTargetDirectory(PsiElement initialTargetElement, PsiElement[] movedElements) {
        PsiDirectory initialTargetDirectory = MoveClassesOrPackagesImpl.getContainerDirectory(initialTargetElement);
        if (initialTargetDirectory == null && movedElements != null) {
            PsiDirectory commonDirectory = MoveClassesOrPackagesImpl.getCommonDirectory(movedElements);
            initialTargetDirectory = commonDirectory != null ? commonDirectory : MoveClassesOrPackagesImpl.getContainerDirectory(movedElements[0]);
        }
        return initialTargetDirectory;
    }

    @Nullable
    public static PsiDirectory getContainerDirectory(PsiElement psiElement) {
        if (psiElement instanceof PsiPackage) {
            PsiDirectory[] directories = ((PsiPackage)psiElement).getDirectories();
            return directories.length == 1 ? directories[0] : null;
        }
        if (psiElement instanceof PsiDirectory) {
            return (PsiDirectory)psiElement;
        }
        if (psiElement != null) {
            return psiElement.getContainingFile().getContainingDirectory();
        }
        return null;
    }

    public static void doRearrangePackage(Project project, PsiDirectory[] directories) {
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(directories), (boolean)true)) {
            return;
        }
        LinkedHashMap<PsiDirectory, String> sourceRootDirectories = MoveClassesOrPackagesImpl.buildRearrangeTargetsList(project, directories);
        DirectoryChooser chooser = new DirectoryChooser(project);
        chooser.setTitle(JavaRefactoringBundle.message((String)"dialog.title.move.directory.to.source.root", (Object[])new Object[0]));
        chooser.setDescription(JavaRefactoringBundle.message((String)"move.label.text", (Object[])new Object[0]) + "  ../" + SymbolPresentationUtil.getFilePathPresentation((PsiFileSystemItem)directories[0]));
        chooser.fillList(sourceRootDirectories.keySet().toArray(PsiDirectory.EMPTY_ARRAY), null, project, sourceRootDirectories);
        if (!chooser.showAndGet()) {
            return;
        }
        PsiDirectory selectedTarget = chooser.getSelectedDirectory();
        if (selectedTarget == null) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        Runnable analyzeConflicts = () -> ApplicationManager.getApplication().runReadAction(() -> {
            List<PsiDirectory> scopes = Arrays.asList(directories);
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)selectedTarget);
            if (vFile != null) {
                RefactoringConflictsUtil.getInstance().analyzeModuleConflicts(project, scopes, UsageInfo.EMPTY_ARRAY, vFile, conflicts);
            }
        });
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(analyzeConflicts, JavaRefactoringBundle.message((String)"analyze.module.conflicts", (Object[])new Object[0]), true, project)) {
            return;
        }
        if (!BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts)) {
            return;
        }
        Ref ex = Ref.create(null);
        String commandDescription = RefactoringBundle.message((String)"moving.directories.command");
        Runnable runnable = () -> ApplicationManager.getApplication().runWriteAction(() -> {
            LocalHistoryAction a = LocalHistory.getInstance().startAction(commandDescription);
            try {
                MoveClassesOrPackagesImpl.rearrangeDirectoriesToTarget(directories, selectedTarget);
            }
            catch (IncorrectOperationException e) {
                ex.set((Object)e);
            }
            finally {
                a.finish();
            }
        });
        CommandProcessor.getInstance().executeCommand(project, runnable, commandDescription, null);
        if (ex.get() != null) {
            RefactoringUIUtil.processIncorrectOperation((Project)project, (IncorrectOperationException)((IncorrectOperationException)((Object)ex.get())));
        }
    }

    private static LinkedHashMap<PsiDirectory, String> buildRearrangeTargetsList(Project project, PsiDirectory[] directories) {
        List sourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)project);
        LinkedHashMap<PsiDirectory, String> sourceRootDirectories = new LinkedHashMap<PsiDirectory, String>();
        block0: for (VirtualFile sourceRoot : sourceRoots) {
            PsiPackage aPackage;
            PsiDirectory sourceRootDirectory = PsiManager.getInstance((Project)project).findDirectory(sourceRoot);
            if (sourceRootDirectory == null || (aPackage = JavaDirectoryService.getInstance().getPackage(sourceRootDirectory)) == null) continue;
            String packagePrefix = aPackage.getQualifiedName();
            String qualifiedName = null;
            for (PsiDirectory directory : directories) {
                qualifiedName = JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName();
                if (!qualifiedName.startsWith(packagePrefix)) continue block0;
            }
            sourceRootDirectories.put(sourceRootDirectory, qualifiedName != null ? File.separator + qualifiedName.replace('.', File.separatorChar) : null);
        }
        return sourceRootDirectories;
    }

    private static void rearrangeDirectoriesToTarget(PsiDirectory[] directories, PsiDirectory selectedTarget) throws IncorrectOperationException {
        VirtualFile sourceRoot = selectedTarget.getVirtualFile();
        for (PsiDirectory directory : directories) {
            PsiPackage parentPackage = JavaDirectoryService.getInstance().getPackage(directory).getParentPackage();
            PackageWrapper wrapper = new PackageWrapper(parentPackage);
            PsiDirectory moveTarget = CommonJavaRefactoringUtil.createPackageDirectoryInSourceRoot((PackageWrapper)wrapper, (VirtualFile)sourceRoot);
            MoveClassesOrPackagesUtil.moveDirectoryRecursively(directory, moveTarget);
        }
    }
}

