/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringFactory;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveDialogBase;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.util.IncorrectOperationException;
import java.awt.Dimension;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 32\u00020\u0001:\u00013B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\rJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u001d\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0003\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0010H\u0014JI\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a2\u0006\u0002\u0010(J4\u0010)\u001a\u0004\u0018\u00010*2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,2\u0006\u0010&\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0014J\u001a\u0010.\u001a\u0004\u0018\u00010%2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010/\u001a\u000200H\u0014J\b\u00101\u001a\u00020\u001eH\u0016J\b\u00102\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesToNewDirectoryDialog;", "Lcom/intellij/refactoring/move/MoveDialogBase;", "directory", "Lcom/intellij/psi/PsiDirectory;", "elementsToMove", "", "Lcom/intellij/psi/PsiElement;", "canShowPreserveSourceRoots", "", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "<init>", "(Lcom/intellij/psi/PsiDirectory;[Lcom/intellij/psi/PsiElement;ZLcom/intellij/refactoring/move/MoveCallback;)V", "(Lcom/intellij/psi/PsiDirectory;[Lcom/intellij/psi/PsiElement;Lcom/intellij/refactoring/move/MoveCallback;)V", "[Lcom/intellij/psi/PsiElement;", "setupComponents", "", "getElementsPath", "", "elements", "([Lcom/intellij/psi/PsiElement;)Ljava/lang/String;", "destDirectoryField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "searchInCommentsAndStringsCheckBox", "Ljavax/swing/JCheckBox;", "searchForTextOccurrencesCheckBox", "preserveSourceRootCheckBox", "sourceNameLabel", "Ljavax/swing/JLabel;", "createCenterPanel", "Ljavax/swing/JComponent;", "doAction", "createMoveClassesOrPackagesProcessor", "Lcom/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "moveDestination", "Lcom/intellij/refactoring/MoveDestination;", "searchInComments", "searchInNonJavaFiles", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/refactoring/MoveDestination;ZZLcom/intellij/refactoring/move/MoveCallback;)Lcom/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor;", "createRefactoringProcessor", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "aPackage", "Lcom/intellij/psi/PsiPackage;", "searchForTextOccurrences", "createDestination", "createSpacingConfiguration", "Lcom/intellij/ui/dsl/builder/SpacingConfiguration;", "getPreferredFocusedComponent", "getHelpId", "Companion", "intellij.java.impl.refactorings"})
public class MoveClassesOrPackagesToNewDirectoryDialog
extends MoveDialogBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiDirectory directory;
    @NotNull
    private final PsiElement[] elementsToMove;
    private final boolean canShowPreserveSourceRoots;
    @Nullable
    private final MoveCallback moveCallback;
    private TextFieldWithBrowseButton destDirectoryField;
    private JCheckBox searchInCommentsAndStringsCheckBox;
    private JCheckBox searchForTextOccurrencesCheckBox;
    private JCheckBox preserveSourceRootCheckBox;
    private JLabel sourceNameLabel;
    @NotNull
    private static final Logger LOG;

    public MoveClassesOrPackagesToNewDirectoryDialog(@NotNull PsiDirectory directory, @NotNull PsiElement[] elementsToMove, boolean canShowPreserveSourceRoots, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)elementsToMove, (String)"elementsToMove");
        super(directory.getProject(), false, MoveClassesOrPackagesDialog.canBeOpenedInEditor(elementsToMove));
        this.directory = directory;
        this.elementsToMove = elementsToMove;
        this.canShowPreserveSourceRoots = canShowPreserveSourceRoots;
        this.moveCallback = moveCallback;
        this.setTitle(MoveHandler.getRefactoringName());
        this.init();
        this.setupComponents();
    }

    public MoveClassesOrPackagesToNewDirectoryDialog(@NotNull PsiDirectory directory, @NotNull PsiElement[] elementsToMove, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)elementsToMove, (String)"elementsToMove");
        this(directory, elementsToMove, true, moveCallback);
    }

    private final void setupComponents() {
        Project project = this.directory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        String sourceNameText = this.getElementsPath(this.elementsToMove);
        JLabel jLabel = this.sourceNameLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceNameLabel");
            jLabel = null;
        }
        jLabel.setText(HtmlChunk.html().addRaw(sourceNameText).toString());
        JCheckBox jCheckBox = this.searchInCommentsAndStringsCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchInCommentsAndStringsCheckBox");
            jCheckBox = null;
        }
        jCheckBox.setSelected(refactoringSettings.MOVE_SEARCH_IN_COMMENTS);
        JCheckBox jCheckBox2 = this.searchForTextOccurrencesCheckBox;
        if (jCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchForTextOccurrencesCheckBox");
            jCheckBox2 = null;
        }
        jCheckBox2.setSelected(refactoringSettings.MOVE_SEARCH_FOR_TEXT);
        if (this.canShowPreserveSourceRoots) {
            Set sourceRoots = new LinkedHashSet();
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex fileIndex = projectFileIndex;
            Module destinationModule = fileIndex.getModuleForFile(this.directory.getVirtualFile());
            boolean sameModule = false;
            sameModule = true;
            for (PsiElement element : this.elementsToMove) {
                VirtualFile it;
                PsiElement psiElement = element;
                if (psiElement instanceof PsiPackage) {
                    PsiDirectory[] psiDirectoryArray;
                    Intrinsics.checkNotNullExpressionValue((Object)((PsiPackage)element).getDirectories(), (String)"getDirectories(...)");
                    for (PsiDirectory psiDirectory : psiDirectoryArray) {
                        VirtualFile virtualFile;
                        Intrinsics.checkNotNullExpressionValue((Object)psiDirectory.getVirtualFile(), (String)"getVirtualFile(...)");
                        sourceRoots.add(fileIndex.getSourceRootForFile(virtualFile));
                    }
                    continue;
                }
                if (!(psiElement instanceof PsiClass)) continue;
                VirtualFile virtualFile = ((PsiClass)element).getContainingFile().getVirtualFile();
                if (virtualFile == null) continue;
                boolean bl = false;
                sourceRoots.add(fileIndex.getSourceRootForFile(it));
                sameModule = sameModule && Intrinsics.areEqual((Object)destinationModule, (Object)fileIndex.getModuleForFile(it));
            }
            JCheckBox jCheckBox3 = this.preserveSourceRootCheckBox;
            if (jCheckBox3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preserveSourceRootCheckBox");
                jCheckBox3 = null;
            }
            jCheckBox3.setVisible(sourceRoots.size() > 1);
            JCheckBox jCheckBox4 = this.preserveSourceRootCheckBox;
            if (jCheckBox4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preserveSourceRootCheckBox");
                jCheckBox4 = null;
            }
            jCheckBox4.setSelected(sameModule);
        } else if (this.elementsToMove.length < 2) {
            JCheckBox jCheckBox5 = this.preserveSourceRootCheckBox;
            if (jCheckBox5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preserveSourceRootCheckBox");
                jCheckBox5 = null;
            }
            jCheckBox5.setVisible(false);
            JCheckBox jCheckBox6 = this.preserveSourceRootCheckBox;
            if (jCheckBox6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preserveSourceRootCheckBox");
                jCheckBox6 = null;
            }
            jCheckBox6.setSelected(false);
        }
    }

    @NlsSafe
    private final String getElementsPath(PsiElement[] elements) {
        return ArraysKt.joinToString$default((Object[])elements, (CharSequence)"<br/>", null, null, (int)0, null, MoveClassesOrPackagesToNewDirectoryDialog::getElementsPath$lambda$0, (int)30, null);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Project project = this.directory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        return (JComponent)BuilderKt.panel(arg_0 -> MoveClassesOrPackagesToNewDirectoryDialog.createCenterPanel$lambda$0(this, project2, arg_0));
    }

    protected void doAction() {
        block5: {
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.destDirectoryField;
            if (textFieldWithBrowseButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"destDirectoryField");
                textFieldWithBrowseButton = null;
            }
            String string = FileUtil.toSystemIndependentName((String)textFieldWithBrowseButton.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
            String path = string;
            Project project = this.directory.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            PsiDirectory directory = (PsiDirectory)WriteAction.compute(() -> MoveClassesOrPackagesToNewDirectoryDialog.doAction$lambda$0(project2, path));
            if (directory == null) {
                Messages.showErrorDialog((Project)project2, (String)JavaRefactoringBundle.message((String)"cannot.find.or.create.destination.directory", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"cannot.move", (Object[])new Object[0]));
                return;
            }
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null) {
                Messages.showErrorDialog((Project)project2, (String)JavaRefactoringBundle.message((String)"destination.directory.does.not.correspond.to.any.package", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"cannot.move", (Object[])new Object[0]));
                return;
            }
            JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
            JCheckBox jCheckBox = this.searchInCommentsAndStringsCheckBox;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchInCommentsAndStringsCheckBox");
                jCheckBox = null;
            }
            boolean searchInComments = jCheckBox.isSelected();
            JCheckBox jCheckBox2 = this.searchForTextOccurrencesCheckBox;
            if (jCheckBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchForTextOccurrencesCheckBox");
                jCheckBox2 = null;
            }
            boolean searchForTextOccurrences = jCheckBox2.isSelected();
            refactoringSettings.MOVE_SEARCH_IN_COMMENTS = searchInComments;
            refactoringSettings.MOVE_SEARCH_FOR_TEXT = searchForTextOccurrences;
            BaseRefactoringProcessor baseRefactoringProcessor = this.createRefactoringProcessor(project2, directory, aPackage, searchInComments, searchForTextOccurrences);
            if (baseRefactoringProcessor == null) break block5;
            BaseRefactoringProcessor it = baseRefactoringProcessor;
            boolean bl = false;
            this.invokeRefactoring(it);
        }
    }

    @NotNull
    protected MoveClassesOrPackagesProcessor createMoveClassesOrPackagesProcessor(@Nullable Project project, @NotNull PsiElement[] elements, @NotNull MoveDestination moveDestination, boolean searchInComments, boolean searchInNonJavaFiles, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)moveDestination, (String)"moveDestination");
        return new MoveClassesOrPackagesProcessor(project, elements, moveDestination, searchInComments, searchInNonJavaFiles, moveCallback);
    }

    @Nullable
    protected BaseRefactoringProcessor createRefactoringProcessor(@Nullable Project project, @NotNull PsiDirectory directory, @NotNull PsiPackage aPackage, boolean searchInComments, boolean searchForTextOccurrences) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)aPackage, (String)"aPackage");
        MoveDestination moveDestination = this.createDestination(aPackage, directory);
        if (moveDestination == null) {
            return null;
        }
        MoveDestination destination = moveDestination;
        MoveClassesOrPackagesProcessor processor = this.createMoveClassesOrPackagesProcessor(project, this.elementsToMove, destination, searchInComments, searchForTextOccurrences, this.moveCallback);
        processor.setOpenInEditor(this.isOpenInEditor());
        return processor.verifyValidPackageName() ? (BaseRefactoringProcessor)processor : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    protected MoveDestination createDestination(@NotNull PsiPackage aPackage, @NotNull PsiDirectory directory) {
        MoveDestination moveDestination;
        Intrinsics.checkNotNullParameter((Object)aPackage, (String)"aPackage");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Project project = aPackage.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project2).getFileIndex().getSourceRootForFile(directory.getVirtualFile());
        if (sourceRoot == null) {
            Messages.showErrorDialog((Project)project2, (String)JavaRefactoringBundle.message((String)"destination.directory.does.not.correspond.to.any.package", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"cannot.move", (Object[])new Object[0]));
            return null;
        }
        JavaRefactoringFactory factory = JavaRefactoringFactory.getInstance((Project)project2);
        JCheckBox jCheckBox = this.preserveSourceRootCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preserveSourceRootCheckBox");
            jCheckBox = null;
        }
        if (jCheckBox.isSelected()) {
            JCheckBox jCheckBox2 = this.preserveSourceRootCheckBox;
            if (jCheckBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preserveSourceRootCheckBox");
                jCheckBox2 = null;
            }
            if (jCheckBox2.isVisible()) {
                moveDestination = factory.createSourceFolderPreservingMoveDestination(aPackage.getQualifiedName());
                return moveDestination;
            }
        }
        moveDestination = factory.createSourceRootMoveDestination(aPackage.getQualifiedName(), sourceRoot);
        return moveDestination;
    }

    @NotNull
    protected SpacingConfiguration createSpacingConfiguration() {
        return (SpacingConfiguration)new IntelliJSpacingConfiguration();
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.destDirectoryField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"destDirectoryField");
            textFieldWithBrowseButton = null;
        }
        JTextField jTextField = textFieldWithBrowseButton.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextField(...)");
        return jTextField;
    }

    @NotNull
    protected String getHelpId() {
        return "refactoring.moveFile";
    }

    private static final CharSequence getElementsPath$lambda$0(PsiElement element) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiFileSystemItem) {
            charSequence = "../" + SymbolPresentationUtil.getFilePathPresentation((PsiFileSystemItem)((PsiFileSystemItem)element));
        } else {
            String string = SymbolPresentationUtil.getSymbolPresentableText((PsiElement)element);
            Intrinsics.checkNotNull((Object)string);
            charSequence = string;
        }
        return charSequence;
    }

    private static final Unit createCenterPanel$lambda$0$0$0$0(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMaximumSize(new Dimension(Integer.MAX_VALUE, $this$applyToComponent.getPreferredSize().height));
        return Unit.INSTANCE;
    }

    private static final String createCenterPanel$lambda$0$0$1$0(VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = FileUtil.toSystemDependentName((String)file.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        return string;
    }

    private static final Unit createCenterPanel$lambda$0$0$1$1(MoveClassesOrPackagesToNewDirectoryDialog this$0, TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setText(FileUtil.toSystemDependentName((String)this$0.directory.getVirtualFile().getPath()));
        $this$applyToComponent.setMaximumSize(new Dimension(400, $this$applyToComponent.getPreferredSize().height));
        $this$applyToComponent.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this$0, $this$applyToComponent){
            final /* synthetic */ MoveClassesOrPackagesToNewDirectoryDialog this$0;
            final /* synthetic */ TextFieldWithBrowseButton $this_applyToComponent;
            {
                this.this$0 = $receiver;
                this.$this_applyToComponent = $this_applyToComponent;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.$this_applyToComponent.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.this$0.setOKActionEnabled(((CharSequence)string).length() > 0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$0(MoveClassesOrPackagesToNewDirectoryDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.sourceNameLabel = (JLabel)$this$row.label("").applyToComponent(MoveClassesOrPackagesToNewDirectoryDialog::createCenterPanel$lambda$0$0$0$0).resizableColumn().getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$1(MoveClassesOrPackagesToNewDirectoryDialog this$0, Project $project, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"createSingleFolderDescriptor(...)");
        Object[] objectArray2 = objectArray;
        Cell cell = $this$row.textFieldWithBrowseButton((FileChooserDescriptor)objectArray2, $project, MoveClassesOrPackagesToNewDirectoryDialog::createCenterPanel$lambda$0$0$1$0);
        objectArray2 = new Object[]{KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"))};
        this$0.destDirectoryField = (TextFieldWithBrowseButton)TextFieldWithBrowseButtonKt.columns((Cell)Cell.comment$default((Cell)cell, (String)RefactoringBundle.message((String)"path.completion.shortcut", (Object[])objectArray2), (int)0, null, (int)6, null).applyToComponent(arg_0 -> MoveClassesOrPackagesToNewDirectoryDialog.createCenterPanel$lambda$0$0$1$1(this$0, arg_0)), (int)36).resizableColumn().align((Align)AlignX.FILL.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$2(MoveClassesOrPackagesToNewDirectoryDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = RefactoringBundle.message((String)"search.in.comments.and.strings");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.searchInCommentsAndStringsCheckBox = (JCheckBox)$this$row.checkBox(string).resizableColumn().getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$3(MoveClassesOrPackagesToNewDirectoryDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = RefactoringBundle.message((String)"search.for.text.occurrences");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.searchForTextOccurrencesCheckBox = (JCheckBox)$this$row.checkBox(string).resizableColumn().getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$4(MoveClassesOrPackagesToNewDirectoryDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = JavaBundle.message((String)"leave.in.same.source.root.item", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.preserveSourceRootCheckBox = (JCheckBox)$this$row.checkBox(string).resizableColumn().getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(MoveClassesOrPackagesToNewDirectoryDialog this$0, Project $project, Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        String string = JavaRefactoringBundle.message((String)"move.label.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$customizeSpacingConfiguration.row(string, arg_0 -> MoveClassesOrPackagesToNewDirectoryDialog.createCenterPanel$lambda$0$0$0(this$0, arg_0));
        String string2 = JavaRefactoringBundle.message((String)"move.files.to.new.directory.prompt", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$customizeSpacingConfiguration.row(string2, arg_0 -> MoveClassesOrPackagesToNewDirectoryDialog.createCenterPanel$lambda$0$0$1(this$0, $project, arg_0));
        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> MoveClassesOrPackagesToNewDirectoryDialog.createCenterPanel$lambda$0$0$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> MoveClassesOrPackagesToNewDirectoryDialog.createCenterPanel$lambda$0$0$3(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> MoveClassesOrPackagesToNewDirectoryDialog.createCenterPanel$lambda$0$0$4(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0(MoveClassesOrPackagesToNewDirectoryDialog this$0, Project $project, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.customizeSpacingConfiguration(this$0.createSpacingConfiguration(), arg_0 -> MoveClassesOrPackagesToNewDirectoryDialog.createCenterPanel$lambda$0$0(this$0, $project, arg_0));
        return Unit.INSTANCE;
    }

    private static final PsiDirectory doAction$lambda$0(Project $project, String $path) {
        try {
            return DirectoryUtil.mkdirs((PsiManager)PsiManager.getInstance((Project)$project), (String)$path);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    static {
        Logger logger = Logger.getInstance(MoveClassesOrPackagesToNewDirectoryDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesToNewDirectoryDialog$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.java.impl.refactorings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

