/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.SingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class MoveJavaFileHandler
extends MoveFileHandler {
    private static final Logger LOG = Logger.getInstance(MoveJavaFileHandler.class);

    public boolean canProcessElement(PsiFile element) {
        return element instanceof PsiJavaFile && !FileTypeUtils.isInServerPageFile((PsiElement)element) && !JavaProjectRootsUtil.isOutsideJavaSourceRoot((PsiFile)element) && !(element instanceof PsiCompiledElement);
    }

    public void prepareMovedFile(PsiFile file, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
        PsiJavaFile javaFile = (PsiJavaFile)file;
        ChangeContextUtil.encodeContextInfo((PsiElement)javaFile, (boolean)true);
        for (PsiClass psiClass : javaFile.getClasses()) {
            oldToNewMap.put((PsiElement)psiClass, (PsiElement)MoveClassesOrPackagesUtil.doMoveClass(psiClass, moveDestination));
        }
    }

    @Nullable
    public @Unmodifiable List<UsageInfo> findUsages(@NotNull PsiFile psiFile, @NotNull PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        if (psiFile == null) {
            MoveJavaFileHandler.$$$reportNull$$$0(0);
        }
        if (newParent == null) {
            MoveJavaFileHandler.$$$reportNull$$$0(1);
        }
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        PsiPackage newParentPackage = JavaDirectoryService.getInstance().getPackage(newParent);
        String qualifiedName = newParentPackage == null ? "" : newParentPackage.getQualifiedName();
        for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
            Collections.addAll(result, MoveClassesOrPackagesUtil.findUsages((PsiElement)aClass, searchInComments, searchInNonJavaFiles, StringUtil.getQualifiedName((String)qualifiedName, (String)StringUtil.notNullize((String)aClass.getName()))));
        }
        return result.isEmpty() ? null : result;
    }

    public void detectConflicts(MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, PsiElement[] elementsToMove, UsageInfo[] usages, PsiDirectory targetDirectory) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDirectory);
        if (aPackage != null) {
            PackageWrapper packageWrapper = new PackageWrapper(aPackage);
            MoveClassesOrPackagesProcessor.detectConflicts(usages, conflicts, elementsToMove, packageWrapper, (MoveDestination)new SingleSourceRootMoveDestination(packageWrapper, targetDirectory));
        }
    }

    public void retargetUsages(@Unmodifiable @NotNull List<? extends UsageInfo> usageInfos, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        if (usageInfos == null) {
            MoveJavaFileHandler.$$$reportNull$$$0(2);
        }
        if (oldToNewMap == null) {
            MoveJavaFileHandler.$$$reportNull$$$0(3);
        }
        for (UsageInfo usageInfo : usageInfos) {
            if (!(usageInfo instanceof MoveRenameUsageInfo)) continue;
            MoveRenameUsageInfo moveRenameUsage = (MoveRenameUsageInfo)usageInfo;
            PsiElement oldElement = moveRenameUsage.getReferencedElement();
            PsiElement newElement = oldToNewMap.get(oldElement);
            PsiReference reference = moveRenameUsage.getReference();
            if (reference == null) continue;
            try {
                LOG.assertTrue(newElement != null, (Object)("old element:" + String.valueOf(oldElement != null ? oldElement : reference) + "; contains: " + oldToNewMap.containsKey(oldElement)));
                reference.bindToElement(newElement);
            }
            catch (IncorrectOperationException ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    public void updateMovedFile(PsiFile file) throws IncorrectOperationException {
        PsiPackage aPackage;
        ChangeContextUtil.decodeContextInfo((PsiElement)file, null, null);
        PsiDirectory containingDirectory = file.getContainingDirectory();
        if (containingDirectory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory)) != null) {
            PsiPackageStatement filePackageStatement;
            PsiPackageStatement packageStatement;
            String qualifiedName = aPackage.getQualifiedName();
            PsiNameHelper helper = PsiNameHelper.getInstance((Project)file.getProject());
            PsiPackageStatement psiPackageStatement = packageStatement = !StringUtil.isEmptyOrSpaces((String)qualifiedName) && helper.isQualifiedName(qualifiedName) ? JavaPsiFacade.getElementFactory((Project)file.getProject()).createPackageStatement(qualifiedName) : null;
            if (file instanceof PsiJavaFile && (filePackageStatement = ((PsiJavaFile)file).getPackageStatement()) != null) {
                if (packageStatement != null) {
                    filePackageStatement.getPackageReference().replace((PsiElement)packageStatement.getPackageReference());
                } else {
                    filePackageStatement.delete();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewMap";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveJavaFileHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "retargetUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

