/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.move.moveInner.MoveInnerHandler;
import com.intellij.refactoring.move.moveInner.MoveInnerOptions;
import org.jetbrains.annotations.NotNull;

public class MoveJavaInnerHandler
implements MoveInnerHandler {
    @Override
    @NotNull
    public PsiClass copyClass(@NotNull MoveInnerOptions options2) {
        PsiClass newClass;
        if (options2 == null) {
            MoveJavaInnerHandler.$$$reportNull$$$0(0);
        }
        PsiClass innerClass = options2.getInnerClass();
        if (options2.getTargetContainer() instanceof PsiDirectory) {
            newClass = this.createNewClass(options2);
            PsiDocComment defaultDocComment = newClass.getDocComment();
            if (defaultDocComment != null && innerClass.getDocComment() == null) {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)defaultDocComment.getProject());
                innerClass = (PsiClass)codeStyleManager.reformat(innerClass.addAfter((PsiElement)defaultDocComment, null).getParent());
            }
            newClass = (PsiClass)newClass.replace((PsiElement)innerClass);
            PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"static", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"private", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"protected", (boolean)false);
            boolean makePublic = MoveJavaInnerHandler.needPublicAccess(options2.getOuterClass(), options2.getTargetContainer());
            if (makePublic) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"public", (boolean)true);
            }
        } else {
            newClass = (PsiClass)options2.getTargetContainer().add((PsiElement)innerClass);
        }
        newClass.setName(options2.getNewClassName());
        PsiClass psiClass = newClass;
        if (psiClass == null) {
            MoveJavaInnerHandler.$$$reportNull$$$0(1);
        }
        return psiClass;
    }

    protected PsiClass createNewClass(MoveInnerOptions options2) {
        return JavaDirectoryService.getInstance().createClass((PsiDirectory)options2.getTargetContainer(), options2.getNewClassName());
    }

    protected static boolean needPublicAccess(PsiClass outerClass, PsiElement targetContainer) {
        if (outerClass.isInterface()) {
            return true;
        }
        if (targetContainer instanceof PsiDirectory) {
            PsiPackage targetPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)targetContainer);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)outerClass.getProject());
            if (targetPackage != null && !psiFacade.isInPackage((PsiElement)outerClass, targetPackage)) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveInner/MoveJavaInnerHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveInner/MoveJavaInnerHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "copyClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyClass";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

