/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveMembers.MoveMembersImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MoveMembersHandler
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (MoveMembersHandler.isMovableMember(element)) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        return targetElement instanceof PsiClass && !(targetElement instanceof PsiAnonymousClass);
    }

    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        MoveMembersImpl.doMove(project, elements, targetContainer, callback);
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (MoveMembersHandler.isMovableMember(element)) {
            List elements = CommonRefactoringUtil.findElementsFromCaretsAndSelections((Editor)editor, (PsiFile)element.getContainingFile(), null, e -> MoveMembersHandler.isMovableMember(e));
            MoveMembersImpl.doMove(project, elements.toArray(PsiElement.EMPTY_ARRAY), null, null);
            return true;
        }
        return false;
    }

    private static boolean isMovableMember(PsiElement element) {
        if (element instanceof PsiMethod || element instanceof PsiField || element instanceof PsiClassInitializer) {
            if (element instanceof SyntheticElement) {
                return false;
            }
            return ((PsiModifierListOwner)element).hasModifierProperty("static");
        }
        return false;
    }

    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MoveMembersHandler.$$$reportNull$$$0(0);
        }
        return JavaRefactoringBundle.message((String)"move.members.action.name", (Object[])new Object[0]);
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            MoveMembersHandler.$$$reportNull$$$0(1);
        }
        return language instanceof JvmLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/move/moveMembers/MoveMembersHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

