/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.lang.LangBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.util.JavaImplicitClassUtil;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.usageView.UsageViewUtil;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class RenameJavaImplicitClassProcessor
extends RenamePsiFileProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameJavaImplicitClassProcessor.$$$reportNull$$$0(0);
        }
        return JavaImplicitClassUtil.isFileWithImplicitClass((PsiElement)element);
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (project == null) {
            RenameJavaImplicitClassProcessor.$$$reportNull$$$0(1);
        }
        if (element == null) {
            RenameJavaImplicitClassProcessor.$$$reportNull$$$0(2);
        }
        return new RenameJavaImplicitClassRenameDialog(project, element, nameSuggestionContext, editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/RenameJavaImplicitClassProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenameDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RenameJavaImplicitClassRenameDialog
    extends RenamePsiFileProcessor.PsiFileRenameDialog {
        @Nullable
        private final String myExtension;

        private RenameJavaImplicitClassRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
            if (project == null) {
                RenameJavaImplicitClassRenameDialog.$$$reportNull$$$0(0);
            }
            if (element == null) {
                RenameJavaImplicitClassRenameDialog.$$$reportNull$$$0(1);
            }
            super(project, element, nameSuggestionContext, editor);
            this.myExtension = Optional.ofNullable(((PsiJavaFile)element).getVirtualFile()).map(file -> file.getExtension()).orElse(null);
        }

        public PsiImplicitClass getImplicitClass() {
            return Objects.requireNonNull(JavaImplicitClassUtil.getImplicitClassFor((PsiElement)this.getPsiElement()));
        }

        protected void canRun() throws ConfigurationException {
            String name = super.getNewName();
            if (Comparing.strEqual((String)name, (String)this.getImplicitClass().getQualifiedName())) {
                throw new ConfigurationException(null);
            }
            if (!PsiNameHelper.getInstance((Project)this.getProject()).isIdentifier(name)) {
                throw new ConfigurationException(LangBundle.message((String)"dialog.message.valid.identifier", (Object[])new Object[]{this.getNewName()}));
            }
        }

        protected String getFullName() {
            PsiImplicitClass implicitClass = this.getImplicitClass();
            String name = DescriptiveNameUtil.getDescriptiveName((PsiElement)implicitClass);
            String type = UsageViewUtil.getType((PsiElement)implicitClass);
            return StringUtil.isEmpty((String)name) ? type : type + " '" + name + "'";
        }

        public String[] getSuggestedNames() {
            String name = this.getImplicitClass().getQualifiedName();
            if (name != null) {
                return new String[]{name};
            }
            return super.getSuggestedNames();
        }

        @VisibleForTesting
        public NameSuggestionsField getNameSuggestionsField() {
            return super.getNameSuggestionsField();
        }

        @NotNull
        public String getNewName() {
            String name = super.getNewName();
            if (this.myExtension != null && !name.endsWith(this.myExtension)) {
                String string = name + "." + this.myExtension;
                if (string == null) {
                    RenameJavaImplicitClassRenameDialog.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = name;
            if (string == null) {
                RenameJavaImplicitClassRenameDialog.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/rename/RenameJavaImplicitClassProcessor$RenameJavaImplicitClassRenameDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/rename/RenameJavaImplicitClassProcessor$RenameJavaImplicitClassRenameDialog";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

