/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameJavaImplicitClassProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessorBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class RenameJavaImplicitClassRenamer
implements RenameHandler {
    private final RenameJavaImplicitClassProcessor myProcessor = new RenameJavaImplicitClassProcessor();
    private static final Logger LOG = Logger.getInstance(RenameJavaImplicitClassRenamer.class);

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiElement element;
        if (dataContext == null) {
            RenameJavaImplicitClassRenamer.$$$reportNull$$$0(0);
        }
        if ((element = PsiElementRenameHandler.getElement((DataContext)dataContext)) == null || element instanceof SyntheticElement || !element.isWritable()) {
            return false;
        }
        if (!this.myProcessor.canProcessElement(element)) {
            return false;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        return PsiManager.getInstance((Project)project).isInProject(element);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            RenameJavaImplicitClassRenamer.$$$reportNull$$$0(1);
        }
        LOG.error("Must not be called, because implicit classes are not available from editor");
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            RenameJavaImplicitClassRenamer.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            RenameJavaImplicitClassRenamer.$$$reportNull$$$0(3);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElementRenameHandler.rename((PsiElement)elements[0], (Project)project, null, null, null, (RenamePsiElementProcessorBase)this.myProcessor);
    }

    @TestOnly
    public void invoke(@NotNull Project project, @NotNull PsiElement element, String defaultName) {
        if (project == null) {
            RenameJavaImplicitClassRenamer.$$$reportNull$$$0(4);
        }
        if (element == null) {
            RenameJavaImplicitClassRenamer.$$$reportNull$$$0(5);
        }
        PsiElementRenameHandler.rename((PsiElement)element, (Project)project, null, null, (String)defaultName, (RenamePsiElementProcessorBase)this.myProcessor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/RenameJavaImplicitClassRenamer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

