/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.MemberHidesOuterMemberUsageInfo;
import com.intellij.refactoring.rename.MemberHidesStaticImportUsageInfo;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class RenameJavaMemberProcessor
extends RenamePsiElementProcessor {
    public static void qualifyMember(PsiMember member, PsiElement occurence, String newName) {
        PsiClass containingClass = member.getContainingClass();
        if (containingClass != null) {
            RenameJavaMemberProcessor.qualifyMember(occurence, newName, containingClass, member.hasModifierProperty("static"));
        }
    }

    protected static void qualifyMember(PsiElement occurence, String newName, @NotNull PsiClass containingClass, boolean isStatic) {
        if (containingClass == null) {
            RenameJavaMemberProcessor.$$$reportNull$$$0(0);
        }
        PsiManager psiManager = occurence.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
        if (isStatic) {
            PsiReferenceExpression qualified = (PsiReferenceExpression)factory.createExpressionFromText("a." + newName, null);
            qualified = (PsiReferenceExpression)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)qualified);
            qualified.getQualifierExpression().replace((PsiElement)factory.createReferenceExpression(containingClass));
            occurence.replace((PsiElement)qualified);
        } else {
            PsiReferenceExpression qualified = RenameJavaMemberProcessor.createQualifiedMemberReference(occurence, newName, containingClass, false);
            qualified = (PsiReferenceExpression)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)qualified);
            occurence.replace((PsiElement)qualified);
        }
    }

    public static PsiReferenceExpression createMemberReference(PsiMember member, PsiElement context) {
        PsiManager manager = member.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        String name = member.getName();
        PsiReferenceExpression ref = (PsiReferenceExpression)factory.createExpressionFromText(name, context);
        PsiElement resolved = ref.resolve();
        PsiClass containingClass = member.getContainingClass();
        if (manager.areElementsEquivalent(resolved, (PsiElement)member) || containingClass == null) {
            return ref;
        }
        return RenameJavaMemberProcessor.createQualifiedMemberReference(context, name, containingClass, member.hasModifierProperty("static"));
    }

    static PsiReferenceExpression createQualifiedMemberReference(PsiElement context, String name, @NotNull PsiClass containingClass, boolean isStatic) {
        PsiReferenceExpression ref;
        if (containingClass == null) {
            RenameJavaMemberProcessor.$$$reportNull$$$0(1);
        }
        PsiManager manager = containingClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (isStatic) {
            ref = (PsiReferenceExpression)factory.createExpressionFromText("A." + name, context);
            PsiJavaCodeReferenceElement qualifier = (PsiJavaCodeReferenceElement)ref.getQualifierExpression();
            PsiReferenceExpression classReference = factory.createReferenceExpression(containingClass);
            qualifier.replace((PsiElement)classReference);
        } else {
            PsiClass contextClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass, (PsiClass)containingClass, (boolean)true)) {
                PsiReferenceExpression ref2 = (PsiReferenceExpression)factory.createExpressionFromText("this." + name, context);
                return ref2;
            }
            while (contextClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass, (PsiClass)containingClass, (boolean)true)) {
                contextClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)contextClass, PsiClass.class, (boolean)true);
            }
            ref = (PsiReferenceExpression)factory.createExpressionFromText("A.this." + name, null);
            PsiJavaCodeReferenceElement qualifier = ((PsiThisExpression)ref.getQualifierExpression()).getQualifier();
            PsiJavaCodeReferenceElement classReference = factory.createClassReferenceElement(contextClass != null ? contextClass : containingClass);
            qualifier.replace((PsiElement)classReference);
        }
        return ref;
    }

    static void findMemberHidesOuterMemberCollisions(PsiMember member, String newName, List<? super UsageInfo> result) {
        PsiClass aClass;
        if (member instanceof PsiCompiledElement) {
            return;
        }
        PsiClass memberClass = member.getContainingClass();
        PsiClass psiClass = aClass = memberClass != null ? memberClass.getContainingClass() : null;
        while (aClass != null) {
            if (member instanceof PsiMethod) {
                for (PsiMethod conflict : aClass.findMethodsByName(newName, true)) {
                    RenameJavaMemberProcessor.findMemberHidesOuterMemberCollisions(member, (PsiMember)conflict, memberClass, result);
                }
            } else {
                PsiField conflict = aClass.findFieldByName(newName, false);
                if (conflict != null) {
                    RenameJavaMemberProcessor.findMemberHidesOuterMemberCollisions(member, (PsiMember)conflict, memberClass, result);
                }
            }
            aClass = aClass.getContainingClass();
        }
    }

    private static void findMemberHidesOuterMemberCollisions(PsiMember member, PsiMember anotherMember, PsiClass memberClass, List<? super UsageInfo> result) {
        ReferencesSearch.search((PsiElement)anotherMember).forEach(reference -> {
            PsiElement refElement = reference.getElement();
            if (refElement instanceof PsiReferenceExpression && ((PsiReferenceExpression)refElement).isQualified()) {
                return true;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)memberClass, (PsiElement)refElement, (boolean)false)) {
                MemberHidesOuterMemberUsageInfo info = new MemberHidesOuterMemberUsageInfo(refElement, member);
                result.add((UsageInfo)info);
            }
            return true;
        });
    }

    static void qualifyOuterMemberReferences(List<? extends MemberHidesOuterMemberUsageInfo> outerHides) {
        for (MemberHidesOuterMemberUsageInfo memberHidesOuterMemberUsageInfo : outerHides) {
            PsiReference reference;
            PsiMember member;
            PsiElement element = memberHidesOuterMemberUsageInfo.getElement();
            if (element == null || (member = (PsiMember)memberHidesOuterMemberUsageInfo.getReferencedElement()) == null || (reference = element.getReference()) == null) continue;
            JavaCodeStyleManager.getInstance((Project)element.getProject()).shortenClassReferences(reference.bindToElement((PsiElement)member));
        }
    }

    static void findCollisionsAgainstNewName(PsiMember memberToRename, String newName, List<UsageInfo> result) {
        PsiImportList importList;
        if (!memberToRename.isPhysical()) {
            return;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)memberToRename.getProject());
        ArrayList<PsiReference> potentialConflicts = new ArrayList<PsiReference>();
        for (UsageInfo info : result) {
            PsiImportStaticStatement[] element = info.getElement();
            if (!(element instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)element).advancedResolve(false).getCurrentFileResolveScope() instanceof PsiImportStaticStatement) || !RenameJavaMemberProcessor.referencesLocalMember(memberToRename, newName, elementFactory, (PsiElement)element)) continue;
            potentialConflicts.add(info.getReference());
        }
        PsiFile containingFile = memberToRename.getContainingFile();
        if (containingFile instanceof PsiJavaFile && (importList = ((PsiJavaFile)containingFile).getImportList()) != null) {
            for (PsiImportStaticStatement staticImport : importList.getImportStaticStatements()) {
                PsiField fieldByName;
                PsiClass targetClass;
                String referenceName = staticImport.getReferenceName();
                if (referenceName != null && !referenceName.equals(newName) || (targetClass = staticImport.resolveTargetClass()) == null) continue;
                HashSet<Object> importedMembers = new HashSet<Object>();
                if (memberToRename instanceof PsiMethod) {
                    for (PsiMethod method : targetClass.findMethodsByName(newName, true)) {
                        if (!method.getModifierList().hasModifierProperty("static")) continue;
                        importedMembers.add(method);
                    }
                } else if (memberToRename instanceof PsiField && (fieldByName = targetClass.findFieldByName(newName, true)) != null) {
                    importedMembers.add(fieldByName);
                }
                for (PsiMember psiMember : importedMembers) {
                    ReferencesSearch.search((PsiElement)psiMember, (SearchScope)new LocalSearchScope((PsiElement)containingFile), (boolean)true).forEach(psiReference -> {
                        potentialConflicts.add((PsiReference)psiReference);
                        return true;
                    });
                }
            }
        }
        for (PsiReference potentialConflict : potentialConflicts) {
            PsiElement scope;
            JavaResolveResult resolveResult;
            PsiElement conflictElement;
            if (!(potentialConflict instanceof PsiJavaReference) || (conflictElement = (resolveResult = ((PsiJavaReference)potentialConflict).advancedResolve(false)).getElement()) == null || !((scope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStaticStatement)) continue;
            result.add((UsageInfo)new MemberHidesStaticImportUsageInfo(potentialConflict.getElement(), conflictElement, (PsiElement)memberToRename));
        }
    }

    private static boolean referencesLocalMember(PsiMember memberToRename, String newName, PsiElementFactory elementFactory, PsiElement context) {
        if (memberToRename instanceof PsiField) {
            return ((PsiReferenceExpression)elementFactory.createExpressionFromText(newName, context)).resolve() != null;
        }
        if (memberToRename instanceof PsiMethod) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)elementFactory.createExpressionFromText(newName + "()", context);
            return callExpression.multiResolve(false).length > 0;
        }
        return false;
    }

    static void qualifyStaticImportReferences(List<? extends MemberHidesStaticImportUsageInfo> staticImportHides) {
        for (MemberHidesStaticImportUsageInfo memberHidesStaticImportUsageInfo : staticImportHides) {
            PsiReference ref = memberHidesStaticImportUsageInfo.getReference();
            if (ref == null) {
                return;
            }
            PsiElement occurrence = ref.getElement();
            PsiElement target = memberHidesStaticImportUsageInfo.getReferencedElement();
            if (!(target instanceof PsiMember)) continue;
            PsiMember targetMember = (PsiMember)target;
            PsiClass containingClass = targetMember.getContainingClass();
            RenameJavaMemberProcessor.qualifyMember(occurrence, targetMember.getName(), containingClass, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "containingClass";
        objectArray2[1] = "com/intellij/refactoring/rename/RenameJavaMemberProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifyMember";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createQualifiedMemberReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

