/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import org.jetbrains.annotations.NotNull;

public class AutomaticOverloadsRenamer
extends AutomaticRenamer {
    public AutomaticOverloadsRenamer(@NotNull PsiMethod method, String newName) {
        if (method == null) {
            AutomaticOverloadsRenamer.$$$reportNull$$$0(0);
        }
        for (PsiMethod overload : this.getOverloads(method)) {
            if (overload == method || overload.findDeepestSuperMethods().length != 0) continue;
            this.myElements.add(overload);
            this.suggestAllNames(overload.getName(), newName);
        }
    }

    public String getDialogTitle() {
        return JavaRefactoringBundle.message((String)"rename.overloads.dialog.title", (Object[])new Object[0]);
    }

    public String getDialogDescription() {
        return JavaRefactoringBundle.message((String)"rename.overloads.to.dialog.description", (Object[])new Object[0]);
    }

    public String entityName() {
        return JavaRefactoringBundle.message((String)"automatic.overload.renamer.entity.name", (Object[])new Object[0]);
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    protected PsiMethod @NotNull [] getOverloads(@NotNull PsiMethod method) {
        PsiClass containingClass;
        if (method == null) {
            AutomaticOverloadsRenamer.$$$reportNull$$$0(1);
        }
        if ((containingClass = method.getContainingClass()) == null) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                AutomaticOverloadsRenamer.$$$reportNull$$$0(2);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = containingClass.findMethodsByName(method.getName(), false);
        if (psiMethodArray == null) {
            AutomaticOverloadsRenamer.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/naming/AutomaticOverloadsRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/naming/AutomaticOverloadsRenamer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOverloads";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

