/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class AutomaticUsageRenamer<T> {
    private final String myOldName;
    private final String myNewName;
    private final Map<T, String> myRenames = new LinkedHashMap<T, String>();
    private final List<T> myElements = new ArrayList<T>();

    protected AutomaticUsageRenamer(List<? extends T> renamedElements, String oldName, String newName) {
        this.myOldName = oldName;
        this.myNewName = newName;
        ArrayList<T> elements = new ArrayList<T>(renamedElements);
        elements.sort((o1, o2) -> this.getName(o1).compareTo(this.getName(o2)));
        for (Object element : elements) {
            String suggestedNewName = this.suggestName(element);
            if (this.getName(element).equals(suggestedNewName)) continue;
            this.myElements.add(element);
            this.setRename(element, suggestedNewName);
        }
    }

    public boolean isEmpty() {
        return this.myRenames.isEmpty();
    }

    protected String getOldName() {
        return this.myOldName;
    }

    public String getNewName() {
        return this.myNewName;
    }

    protected boolean isChecked(T element) {
        return this.myRenames.containsKey(element);
    }

    protected boolean isCheckedInitially(T element) {
        return false;
    }

    public List<? extends T> getElements() {
        return this.myElements;
    }

    public String getNewElementName(T element) {
        return this.myRenames.get(element);
    }

    public Map<? extends T, String> getRenames() {
        return this.myRenames;
    }

    public void setRename(T element, @NotNull String replacement2) {
        if (replacement2 == null) {
            AutomaticUsageRenamer.$$$reportNull$$$0(0);
        }
        this.myRenames.put(element, replacement2);
    }

    public void doNotRename(T element) {
        this.myRenames.remove(element);
    }

    public final void doRename() throws IncorrectOperationException {
    }

    protected abstract String suggestName(T var1);

    @NlsSafe
    protected abstract String getName(T var1);

    @NlsContexts.DialogTitle
    public abstract String getDialogTitle();

    @Nls
    public abstract String getDialogDescription();

    public abstract String getEntityName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/intellij/refactoring/rename/naming/AutomaticUsageRenamer", "setRename"));
    }
}

