/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticUsageRenamer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.panels.ValidatingComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomaticUsageRenamingDialog<T>
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AutomaticUsageRenamingDialog.class);
    private static final int CHECK_COLUMN = 0;
    private static final int OLD_NAME_COLUMN = 1;
    private static final int NEW_NAME_COLUMN = 2;
    private final AutomaticUsageRenamer<T> myRenamer;
    private boolean[] myShouldRename;
    private String[] myNewNames;
    private MyTableModel myTableModel;
    private JBTable myTable;
    private DocumentAdapter myCellEditorListener;
    private ValidatingComponent<?> myValidatingComponent;

    public AutomaticUsageRenamingDialog(Project project, AutomaticUsageRenamer<T> renamer) {
        super(project, true);
        this.myRenamer = renamer;
        this.populateData();
        this.setTitle(this.myRenamer.getDialogTitle());
        this.setOKButtonText(IdeBundle.message((String)"button.ok", (Object[])new Object[0]));
        this.init();
    }

    private void populateData() {
        this.myNewNames = new String[this.getElementCount()];
        this.myShouldRename = new boolean[this.getElementCount()];
        for (int i = 0; i < this.getElementCount(); ++i) {
            this.myNewNames[i] = this.myRenamer.getNewElementName(this.getElements().get(i));
            this.myShouldRename[i] = this.myRenamer.isCheckedInitially(this.getElements().get(i));
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.rename.AutomaticRenamingDialog";
    }

    private int getElementCount() {
        return this.getElements().size();
    }

    protected JComponent createNorthPanel() {
        JBBox box = JBBox.createHorizontalBox();
        box.add((Component)new JLabel(this.myRenamer.getDialogDescription()));
        box.add(Box.createHorizontalGlue());
        return box;
    }

    public void show() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        super.show();
    }

    private void handleChanges() {
        this.updateRenamer();
        boolean okActionEnabled = true;
        this.setOKActionEnabled(okActionEnabled);
        this.refreshValidatingComponent();
    }

    private void refreshValidatingComponent() {
        int selectedRow = this.myTable.getSelectedRow();
        if (selectedRow >= 0) {
            this.myValidatingComponent.setErrorText(null);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected JComponent createCenterPanel() {
        JBBox box = JBBox.createVerticalBox();
        this.setupTable();
        this.myTableModel.addTableModelListener(e -> this.handleChanges());
        TableUtil.setupCheckboxColumn((JTable)this.myTable, (int)0);
        this.setupOldNameColumn();
        this.setupNewNameColumn();
        this.myValidatingComponent = new ValidatingComponent<JComponent>(){

            protected JComponent createMainComponent() {
                return ScrollPaneFactory.createScrollPane((Component)AutomaticUsageRenamingDialog.this.myTable);
            }
        };
        this.myValidatingComponent.doInitialize();
        box.add(this.myValidatingComponent);
        JBBox buttonBox = JBBox.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        JButton selectAllButton = new JButton(RefactoringBundle.message((String)"select.all.button"));
        buttonBox.add((Component)selectAllButton);
        buttonBox.add(Box.createHorizontalStrut(4));
        JButton deselectAllButton = new JButton(RefactoringBundle.message((String)"unselect.all.button"));
        buttonBox.add((Component)deselectAllButton);
        selectAllButton.addActionListener(e -> {
            for (int i = 0; i < this.getElementCount(); ++i) {
                this.myShouldRename[i] = true;
            }
            this.myTableModel.fireTableDataChanged();
        });
        deselectAllButton.addActionListener(e -> {
            for (int i = 0; i < this.getElementCount(); ++i) {
                this.myShouldRename[i] = false;
            }
            this.myTableModel.fireTableDataChanged();
        });
        box.add(Box.createVerticalStrut(4));
        box.add((Component)buttonBox);
        box.add(Box.createVerticalStrut(4));
        return box;
    }

    private void setupTable() {
        this.myTable = new JBTable();
        this.myTableModel = new MyTableModel();
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTable.getSelectionModel().addListSelectionListener(e -> this.refreshValidatingComponent());
        this.myTable.setCellSelectionEnabled(false);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.setRowSelectionAllowed(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
    }

    private void setupNewNameColumn() {
        this.myTable.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setToolTipText(null);
                this.append(String.valueOf(value), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/refactoring/rename/naming/AutomaticUsageRenamingDialog$2", "customizeCellRenderer"));
            }
        });
        final JTextField textField = new JTextField("");
        textField.setBorder((Border)JBUI.Borders.empty());
        this.myTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(textField){

            @Override
            public boolean stopCellEditing() {
                AutomaticUsageRenamingDialog.this.removeListener(textField);
                return super.stopCellEditing();
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final int row, final int column) {
                super.getTableCellEditorComponent(table, value, isSelected, row, column);
                AutomaticUsageRenamingDialog.this.removeListener(textField);
                AutomaticUsageRenamingDialog.this.myCellEditorListener = new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        AutomaticUsageRenamingDialog.this.myTableModel.setValueAt(this.getCellEditorValue(), row, column);
                        AutomaticUsageRenamingDialog.this.setChecked(row, true);
                        AutomaticUsageRenamingDialog.this.getElements();
                        textField.setToolTipText(null);
                        Font font = textField.getFont();
                        textField.setForeground(SimpleTextAttributes.REGULAR_ATTRIBUTES.getFgColor());
                        textField.setFont(font.deriveFont(font.getStyle() & 0xFFFFFFFD));
                        AutomaticUsageRenamingDialog.this.repaintTable();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/rename/naming/AutomaticUsageRenamingDialog$3$1", "textChanged"));
                    }
                };
                textField.getDocument().addDocumentListener((DocumentListener)AutomaticUsageRenamingDialog.this.myCellEditorListener);
                return textField;
            }
        });
    }

    private void repaintTable() {
        this.myTable.invalidate();
        this.myTable.repaint();
    }

    private void setupOldNameColumn() {
        this.myTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    4.$$$reportNull$$$0(0);
                }
                Object element = value;
                this.setToolTipText(null);
                this.append(AutomaticUsageRenamingDialog.this.myRenamer.getName(element), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/refactoring/rename/naming/AutomaticUsageRenamingDialog$4", "customizeCellRenderer"));
            }
        });
    }

    private void removeListener(JTextField textField) {
        if (this.myCellEditorListener != null) {
            textField.getDocument().removeDocumentListener((DocumentListener)this.myCellEditorListener);
        }
    }

    protected void doOKAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        this.handleChanges();
        super.doOKAction();
    }

    private void updateRenamer() {
        for (int i = 0; i < this.getElementCount(); ++i) {
            T element = this.getElements().get(i);
            if (this.myShouldRename[i]) {
                this.myRenamer.setRename(element, this.myNewNames[i]);
                continue;
            }
            this.myRenamer.doNotRename(element);
        }
    }

    protected void setChecked(int rowIndex, boolean checked) {
        this.myTableModel.setValueAt(checked, rowIndex, 0);
    }

    protected void setChecked(T element, boolean checked) {
        this.setChecked(this.getElements().indexOf(element), checked);
    }

    private List<? extends T> getElements() {
        return this.myRenamer.getElements();
    }

    protected boolean isChecked(T element) {
        return this.myShouldRename[this.getElements().indexOf(element)];
    }

    private class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
            InputMap inputMap = AutomaticUsageRenamingDialog.this.myTable.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
            AutomaticUsageRenamingDialog.this.myTable.getActionMap().put("enable_disable", new MySpaceAction());
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "enter");
            AutomaticUsageRenamingDialog.this.myTable.getActionMap().put("enter", new EnterAction());
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return AutomaticUsageRenamingDialog.this.getElementCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return switch (columnIndex) {
                case 0 -> AutomaticUsageRenamingDialog.this.myShouldRename[rowIndex];
                case 1 -> AutomaticUsageRenamingDialog.this.getElements().get(rowIndex);
                case 2 -> AutomaticUsageRenamingDialog.this.myNewNames[rowIndex];
                default -> {
                    LOG.assertTrue(false);
                    yield null;
                }
            };
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    AutomaticUsageRenamingDialog.this.myShouldRename[rowIndex] = (Boolean)aValue;
                    break;
                }
                case 2: {
                    AutomaticUsageRenamingDialog.this.myNewNames[rowIndex] = (String)aValue;
                    break;
                }
                default: {
                    LOG.assertTrue(false);
                }
            }
            AutomaticUsageRenamingDialog.this.handleChanges();
            AutomaticUsageRenamingDialog.this.repaintTable();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        @Override
        @Nullable
        public Class<?> getColumnClass(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> Boolean.class;
                case 1, 2 -> String.class;
                default -> null;
            };
        }

        @Override
        public String getColumnName(int column) {
            return switch (column) {
                case 1 -> RefactoringBundle.message((String)"automatic.renamer.entity.name.column", (Object[])new Object[]{AutomaticUsageRenamingDialog.this.myRenamer.getEntityName()});
                case 2 -> RefactoringBundle.message((String)"automatic.renamer.rename.to.column");
                default -> " ";
            };
        }

        private class MySpaceAction
        extends AbstractAction {
            private MySpaceAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AutomaticUsageRenamingDialog.this.myTable.isEditing()) {
                    return;
                }
                int row = AutomaticUsageRenamingDialog.this.myTable.getSelectionModel().getAnchorSelectionIndex();
                if (row >= 0 && row < AutomaticUsageRenamingDialog.this.getElementCount()) {
                    AutomaticUsageRenamingDialog.this.myShouldRename[row] = !AutomaticUsageRenamingDialog.this.myShouldRename[row];
                    MyTableModel.this.fireTableDataChanged();
                    AutomaticUsageRenamingDialog.this.repaintTable();
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)AutomaticUsageRenamingDialog.this.myTable, true));
                }
            }
        }

        private class EnterAction
        extends AbstractAction {
            private EnterAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AutomaticUsageRenamingDialog.this.myTable.isEditing()) {
                    AutomaticUsageRenamingDialog.this.doOKAction();
                }
            }
        }
    }
}

