/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.refactoring.move.moveClassesOrPackages.ModifyModuleStatementUsageInfo;
import com.intellij.refactoring.move.moveClassesOrPackages.ModuleInfoUsageDetector;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteModuleStatementsUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ModuleInfoSafeDeleteUsageDetector
extends ModuleInfoUsageDetector {
    public ModuleInfoSafeDeleteUsageDetector(@NotNull Project project, PsiElement @NotNull [] elementsToDelete) {
        if (project == null) {
            ModuleInfoSafeDeleteUsageDetector.$$$reportNull$$$0(0);
        }
        if (elementsToDelete == null) {
            ModuleInfoSafeDeleteUsageDetector.$$$reportNull$$$0(1);
        }
        super(project, elementsToDelete);
    }

    @Override
    public void detectModuleStatementsUsed(@NotNull List<? super UsageInfo> usageInfos, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (usageInfos == null) {
            ModuleInfoSafeDeleteUsageDetector.$$$reportNull$$$0(2);
        }
        if (conflicts == null) {
            ModuleInfoSafeDeleteUsageDetector.$$$reportNull$$$0(3);
        }
        if (this.mySourceClassesByDir.isEmpty()) {
            return;
        }
        PackageIndex packageIndex = PackageIndex.getInstance((Project)this.myProject);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        MultiMap<PsiJavaModule, PsiDirectory> sourceDirsByModuleDescriptor = ModuleInfoSafeDeleteUsageDetector.groupDirsByModuleDescriptor(this.mySourceClassesByDir.keySet());
        SmartList moduleStatementUsages = new SmartList();
        for (Map.Entry entry : sourceDirsByModuleDescriptor.entrySet()) {
            PsiJavaModule sourceModuleDescriptor = (PsiJavaModule)entry.getKey();
            Collection sourceDirs = (Collection)entry.getValue();
            MultiMap<PsiPackage, PsiPackageAccessibilityStatement> sourceExports = ModuleInfoSafeDeleteUsageDetector.collectModuleStatements(sourceModuleDescriptor.getExports());
            MultiMap<PsiPackage, PsiPackageAccessibilityStatement> sourceOpens = ModuleInfoSafeDeleteUsageDetector.collectModuleStatements(sourceModuleDescriptor.getOpens());
            for (PsiDirectory sourceDir : sourceDirs) {
                Collection sourceClasses;
                List<PsiPackageAccessibilityStatement> sourceStatements;
                PsiPackage sourcePkg;
                String sourcePkgName = packageIndex.getPackageNameByDirectory(sourceDir.getVirtualFile());
                if (sourcePkgName == null || (sourcePkg = psiFacade.findPackage(sourcePkgName)) == null || (sourceStatements = ModuleInfoSafeDeleteUsageDetector.findModuleStatementsForPkg(sourcePkg, sourceExports, sourceOpens)).isEmpty() || !ModuleInfoSafeDeleteUsageDetector.dirContainsOnlyClasses(sourceDir, sourceClasses = this.mySourceClassesByDir.get((Object)sourceDir))) continue;
                moduleStatementUsages.addAll(ContainerUtil.map(sourceStatements, statement -> ModifyModuleStatementUsageInfo.createLastDeletionInfo(statement, sourceModuleDescriptor)));
            }
        }
        if (moduleStatementUsages.isEmpty()) {
            return;
        }
        PsiPackageAccessibilityStatement firstModuleStatement = ((ModifyModuleStatementUsageInfo)((Object)moduleStatementUsages.get(0))).getModuleStatement();
        if (firstModuleStatement != null) {
            usageInfos.add(new SafeDeleteModuleStatementsUsageInfo((PsiElement)firstModuleStatement, (List<ModifyModuleStatementUsageInfo>)moduleStatementUsages));
        }
    }

    @Override
    @NotNull
    public List<UsageInfo> createUsageInfosForNewlyCreatedDirs() {
        List<UsageInfo> list = Collections.emptyList();
        if (list == null) {
            ModuleInfoSafeDeleteUsageDetector.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToDelete";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/safeDelete/ModuleInfoSafeDeleteUsageDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/safeDelete/ModuleInfoSafeDeleteUsageDetector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfosForNewlyCreatedDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detectModuleStatementsUsed";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

