/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.codeInsight.daemon.impl.quickfix.SafeDeleteFix;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.refactoring.changeSignature.inCallers.JavaMemberNode;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteMemberCalleeUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

abstract class SafeDeleteJavaCalleeChooser
extends CallerChooserBase<PsiElement> {
    SafeDeleteJavaCalleeChooser(@NotNull PsiMember member, @NotNull Project project, @NotNull List<? super UsageInfo> result) {
        if (member == null) {
            SafeDeleteJavaCalleeChooser.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SafeDeleteJavaCalleeChooser.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SafeDeleteJavaCalleeChooser.$$$reportNull$$$0(2);
        }
        super((PsiElement)member, project, JavaRefactoringBundle.message((String)"safe.delete.select.members.to.propagate.dialog.title", (Object[])new Object[0]), null, "dummy." + JavaFileType.INSTANCE.getDefaultExtension(), members -> result.addAll(ContainerUtil.map((Collection)members, m -> new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)m, (PsiElement)m, true))));
    }

    @NotNull
    protected abstract List<SafeDeleteMemberCalleeUsageInfo> getTopLevelItems();

    @NlsContexts.Label
    protected String getEmptyCallerText() {
        return JavaRefactoringBundle.message((String)"java.safe.delete.caller.text", (Object[])new Object[0]);
    }

    @NlsContexts.Label
    protected String getEmptyCalleeText() {
        return JavaRefactoringBundle.message((String)"java.safe.delete.empty.callee.text", (Object[])new Object[0]);
    }

    protected PsiElement[] findDeepestSuperMethods(PsiElement method) {
        return method instanceof PsiMethod ? ((PsiMethod)method).findDeepestSuperMethods() : PsiMember.EMPTY_ARRAY;
    }

    protected MemberNodeBase<PsiElement> createTreeNodeFor(PsiElement nodeMethod, HashSet<PsiElement> callees, Runnable cancelCallback) {
        SafeDeleteJavaMemberNode node = new SafeDeleteJavaMemberNode(nodeMethod, callees, cancelCallback, nodeMethod != null ? nodeMethod.getProject() : this.myProject);
        if (this.getTopMember().equals((Object)nodeMethod)) {
            node.setEnabled(false);
            node.setChecked(true);
        }
        return node;
    }

    protected MemberNodeBase<PsiElement> getCalleeNode(MemberNodeBase<PsiElement> node) {
        return node;
    }

    protected MemberNodeBase<PsiElement> getCallerNode(MemberNodeBase<PsiElement> node) {
        return (MemberNodeBase)node.getParent();
    }

    @NotNull
    @Nls
    protected String getCalleeEditorTitle() {
        String string = JavaBundle.message((String)"caller.chooser.referenced.code.title", (Object[])new Object[0]);
        if (string == null) {
            SafeDeleteJavaCalleeChooser.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/safeDelete/SafeDeleteJavaCalleeChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/safeDelete/SafeDeleteJavaCalleeChooser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCalleeEditorTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class SafeDeleteJavaMemberNode
    extends MemberNodeBase<PsiElement> {
        SafeDeleteJavaMemberNode(PsiElement currentMember, HashSet<PsiElement> callees, Runnable cancelCallback, Project project) {
            super(currentMember, callees, project, cancelCallback);
        }

        protected void customizeRendererText(@NotNull ColoredTreeCellRenderer renderer) {
            PsiElement member;
            if (renderer == null) {
                SafeDeleteJavaMemberNode.$$$reportNull$$$0(0);
            }
            if ((member = this.getMember()) instanceof PsiMember) {
                JavaMemberNode.customizeRendererText((ColoredTreeCellRenderer)renderer, (PsiMember)((PsiMember)member), (boolean)this.isEnabled());
            } else {
                renderer.append(ElementDescriptionUtil.getElementDescription((PsiElement)member, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE));
            }
        }

        protected MemberNodeBase<PsiElement> createNode(PsiElement caller, HashSet<PsiElement> callees) {
            return new SafeDeleteJavaMemberNode(caller, callees, this.myCancelCallback, this.myProject);
        }

        protected @Unmodifiable List<PsiElement> computeCallers() {
            PsiElement member = this.getMember();
            if (SafeDeleteJavaCalleeChooser.this.getTopMember().equals((Object)member)) {
                return ContainerUtil.map(SafeDeleteJavaCalleeChooser.this.getTopLevelItems(), info -> info.getCalledElement());
            }
            if (!(member instanceof PsiMember)) {
                return Collections.emptyList();
            }
            List callees = SafeDeleteFix.computeReferencedCodeSafeToDelete((PsiMember)((PsiMember)member));
            callees.remove(SafeDeleteJavaCalleeChooser.this.getTopMember());
            return callees;
        }

        protected Condition<PsiElement> getFilter() {
            return member -> !this.getMember().equals(member);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/refactoring/safeDelete/SafeDeleteJavaCalleeChooser$SafeDeleteJavaMemberNode", "customizeRendererText"));
        }
    }
}

