/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteCustomUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class SafeDeleteParameterCallHierarchyUsageInfo
extends SafeDeleteUsageInfo
implements SafeDeleteCustomUsageInfo {
    private final PsiMethod myCalledMethod;
    private final PsiMethod myCallerMethod;
    private final PsiParameter myParameterInCaller;

    public SafeDeleteParameterCallHierarchyUsageInfo(PsiMethod calledMethod, PsiParameter parameter, PsiMethod callerMethod, PsiParameter parameterInCaller) {
        super((PsiElement)calledMethod, (PsiElement)parameter);
        this.myCalledMethod = calledMethod;
        this.myCallerMethod = callerMethod;
        this.myParameterInCaller = parameterInCaller;
    }

    public PsiParameter getReferencedElement() {
        return (PsiParameter)super.getReferencedElement();
    }

    public void performRefactoring() throws IncorrectOperationException {
        PsiParameter parameter = this.getReferencedElement();
        if (parameter != null && parameter.isValid()) {
            parameter.delete();
        }
    }

    public PsiMethod getCalledMethod() {
        return this.myCalledMethod;
    }

    public PsiMethod getCallerMethod() {
        return this.myCallerMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SafeDeleteParameterCallHierarchyUsageInfo info = (SafeDeleteParameterCallHierarchyUsageInfo)((Object)o);
        if (!this.myCalledMethod.equals((Object)info.myCalledMethod)) {
            return false;
        }
        if (!this.myCallerMethod.equals((Object)info.myCallerMethod)) {
            return false;
        }
        return this.myParameterInCaller.equals((Object)info.myParameterInCaller);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myCalledMethod.hashCode();
        result = 31 * result + this.myCallerMethod.hashCode();
        result = 31 * result + this.myParameterInCaller.hashCode();
        return result;
    }

    public PsiParameter getParameterInCaller() {
        return this.myParameterInCaller;
    }
}

