/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.turnRefsToSuper;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.turnRefsToSuper.RefsToSuperViewDescriptor;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperHandler;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperProcessorBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TurnRefsToSuperProcessor
extends TurnRefsToSuperProcessorBase {
    private static final Logger LOG = Logger.getInstance(TurnRefsToSuperProcessor.class);
    private PsiClass mySuper;
    private final @NlsContexts.Command @NotNull String myRefactoringName;

    public TurnRefsToSuperProcessor(Project project, @NotNull PsiClass aClass, @NotNull PsiClass aSuper, boolean replaceInstanceOf) {
        if (aClass == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(0);
        }
        if (aSuper == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(1);
        }
        super(project, replaceInstanceOf, aSuper.getName());
        this.myClass = aClass;
        this.mySuper = aSuper;
        this.myRefactoringName = JavaRefactoringBundle.message((String)"turn.refs.to.super.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass), DescriptiveNameUtil.getDescriptiveName((PsiElement)this.mySuper)});
    }

    @NotNull
    protected String getCommandName() {
        String string = this.myRefactoringName;
        if (string == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(3);
        }
        return new RefsToSuperViewDescriptor(this.myClass, this.mySuper);
    }

    private void setClasses(@NotNull PsiClass aClass, @NotNull PsiClass aSuper) {
        if (aClass == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(4);
        }
        if (aSuper == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(5);
        }
        this.myClass = aClass;
        this.mySuper = aSuper;
    }

    protected UsageInfo @NotNull [] findUsages() {
        PsiReference[] refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY);
        ArrayList<UsageInfo> result = this.detectTurnToSuperRefs(refs, new ArrayList<UsageInfo>());
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(6);
        }
        return usageInfoArray;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(elements.length == 2 && elements[0] instanceof PsiClass && elements[1] instanceof PsiClass);
        this.setClasses((PsiClass)elements[0], (PsiClass)elements[1]);
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(8);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ((UsageInfo[])refUsages.get()).length == 0) {
            String message = JavaRefactoringBundle.message((String)"no.usages.can.be.replaced", (Object[])new Object[]{this.myClass.getQualifiedName(), this.mySuper.getQualifiedName()});
            Messages.showInfoMessage((Project)this.myProject, (String)message, (String)TurnRefsToSuperHandler.getRefactoringName());
            return false;
        }
        return super.preprocessUsages(refUsages);
    }

    @Override
    protected boolean canTurnToSuper(PsiElement refElement) {
        return super.canTurnToSuper(refElement) && JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper().isAccessible((PsiMember)this.mySuper, refElement, null);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(9);
        }
        try {
            PsiClass aSuper = this.mySuper;
            TurnRefsToSuperProcessor.processTurnToSuperRefs(usages, aSuper);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        this.performVariablesRenaming();
    }

    @Override
    protected boolean isInSuper(PsiElement member) {
        if (!(member instanceof PsiMember)) {
            return false;
        }
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)this.mySuper, (PsiClass)((PsiMember)member).getContainingClass(), (boolean)true)) {
            return true;
        }
        if (member instanceof PsiField) {
            PsiClass containingClass = ((PsiField)member).getContainingClass();
            if (PsiUtil.isArrayClass((PsiElement)containingClass)) {
                return true;
            }
        } else if (member instanceof PsiMethod) {
            return this.mySuper.findMethodBySignature((PsiMethod)member, true) != null;
        }
        return false;
    }

    @Override
    protected boolean isSuperInheritor(PsiClass aClass) {
        return InheritanceUtil.isInheritorOrSelf((PsiClass)this.mySuper, (PsiClass)aClass, (boolean)true);
    }

    public PsiClass getSuper() {
        return this.mySuper;
    }

    public PsiClass getTarget() {
        return this.myClass;
    }

    public boolean isReplaceInstanceOf() {
        return this.myReplaceInstanceOf;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(10);
        }
        List list = Collections.emptyList();
        if (list == null) {
            TurnRefsToSuperProcessor.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aSuper";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setClasses";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 11 -> new IllegalStateException(string);
        };
    }
}

