/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.turnRefsToSuper;

import com.intellij.internal.diGraph.analyzer.GlobalAnalyzer;
import com.intellij.internal.diGraph.analyzer.Mark;
import com.intellij.internal.diGraph.analyzer.OneEndFunctor;
import com.intellij.internal.diGraph.impl.EdgeImpl;
import com.intellij.internal.diGraph.impl.NodeImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticVariableRenamer;
import com.intellij.refactoring.turnRefsToSuper.TurnToSuperReferenceUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TurnRefsToSuperProcessorBase
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(TurnRefsToSuperProcessorBase.class);
    protected PsiClass myClass;
    protected final boolean myReplaceInstanceOf;
    protected PsiManager myManager;
    protected PsiSearchHelper mySearchHelper;
    protected HashSet<PsiElement> myMarkedNodes = new HashSet();
    private Deque<PsiExpression> myExpressionsQueue;
    protected Map<PsiElement, Node> myElementToNode = new HashMap<PsiElement, Node>();
    protected Map<SmartPsiElementPointer<?>, String> myVariablesRenames = new HashMap();
    private final String mySuperClassName;
    private final List<UsageInfo> myVariablesUsages = new ArrayList<UsageInfo>();

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            TurnRefsToSuperProcessorBase.$$$reportNull$$$0(0);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        ArrayList<UsageInfo> filtered = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof TurnToSuperReferenceUsageInfo)) continue;
            filtered.add(usage);
        }
        if (this.myClass.getName() != null) {
            AutomaticVariableRenamer variableRenamer = new AutomaticVariableRenamer(this.myClass, this.mySuperClassName, filtered);
            if (!ApplicationManager.getApplication().isUnitTestMode() && variableRenamer.hasAnythingToRename()) {
                AutomaticRenamingDialog dialog = new AutomaticRenamingDialog(this.myProject, (AutomaticRenamer)variableRenamer);
                if (!dialog.showAndGet()) {
                    return false;
                }
                List variables = variableRenamer.getElements();
                for (PsiNamedElement namedElement : variables) {
                    PsiVariable variable = (PsiVariable)namedElement;
                    SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)variable);
                    this.myVariablesRenames.put(pointer, variableRenamer.getNewName((PsiNamedElement)variable));
                }
                Runnable runnable = () -> ApplicationManager.getApplication().runReadAction(() -> variableRenamer.findUsages(this.myVariablesUsages, false, false));
                if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject)) {
                    return false;
                }
            }
        }
        this.prepareSuccessful();
        return true;
    }

    protected void performVariablesRenaming() {
        try {
            HashMap<PsiElement, String> variableRenames = new HashMap<PsiElement, String>();
            for (Map.Entry<SmartPsiElementPointer<?>, String> entry : this.myVariablesRenames.entrySet()) {
                variableRenames.put(entry.getKey().getElement(), entry.getValue());
            }
            for (UsageInfo usage : this.myVariablesUsages) {
                if (!(usage instanceof MoveRenameUsageInfo)) continue;
                MoveRenameUsageInfo renameUsageInfo = (MoveRenameUsageInfo)usage;
                String newName = (String)variableRenames.get(renameUsageInfo.getUpToDateReferencedElement());
                PsiReference reference = renameUsageInfo.getReference();
                if (reference == null) continue;
                reference.handleElementRename(newName);
            }
            for (Map.Entry<SmartPsiElementPointer<?>, String> entry : this.myVariablesRenames.entrySet()) {
                String newName = entry.getValue();
                if (newName == null) continue;
                PsiVariable variable = (PsiVariable)entry.getKey().getElement();
                variable.setName(newName);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected TurnRefsToSuperProcessorBase(Project project, boolean replaceInstanceOf, String superClassName) {
        super(project);
        this.mySuperClassName = superClassName;
        this.myManager = PsiManager.getInstance((Project)project);
        this.mySearchHelper = PsiSearchHelper.getInstance((Project)this.myManager.getProject());
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myReplaceInstanceOf = replaceInstanceOf;
    }

    protected ArrayList<UsageInfo> detectTurnToSuperRefs(PsiReference[] refs, ArrayList<UsageInfo> result) {
        this.buildGraph(refs);
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            if (!this.canTurnToSuper(element)) continue;
            result.add(new TurnToSuperReferenceUsageInfo(element));
        }
        return result;
    }

    protected boolean canTurnToSuper(PsiElement ref) {
        return !this.myMarkedNodes.contains(ref);
    }

    protected static void processTurnToSuperRefs(UsageInfo[] usages, PsiClass aSuper) throws IncorrectOperationException {
        for (UsageInfo usage : usages) {
            PsiReferenceParameterList parameterList;
            PsiElement element;
            if (!(usage instanceof TurnToSuperReferenceUsageInfo) || (element = usage.getElement()) == null) continue;
            PsiReference ref = element.getReference();
            assert (ref != null);
            PsiElement typeParams = TurnRefsToSuperProcessorBase.createReferenceTypeParameterList(aSuper, ref);
            PsiElement newElement = ref.bindToElement((PsiElement)aSuper);
            if (typeParams != null && newElement instanceof PsiJavaCodeReferenceElement && (parameterList = ((PsiJavaCodeReferenceElement)newElement).getParameterList()) != null) {
                parameterList.replace(typeParams);
            }
            if (!(newElement.getParent() instanceof PsiTypeElement) || !(newElement.getParent().getParent() instanceof PsiTypeCastExpression)) continue;
            TurnRefsToSuperProcessorBase.fixPossiblyRedundantCast((PsiTypeCastExpression)newElement.getParent().getParent());
        }
    }

    private static PsiElement createReferenceTypeParameterList(PsiClass aSuper, PsiReference ref) {
        JavaResolveResult result;
        PsiElement aClass;
        PsiReferenceParameterList typeParams = null;
        if (ref instanceof PsiJavaCodeReferenceElement && (aClass = (result = ((PsiJavaCodeReferenceElement)ref).advancedResolve(false)).getElement()) instanceof PsiClass) {
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aSuper, (PsiClass)((PsiClass)aClass), (PsiSubstitutor)result.getSubstitutor());
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
            PsiClassType classType = factory.createType(aSuper, substitutor);
            typeParams = factory.createReferenceFromText(classType.getCanonicalText(), aClass).getParameterList();
        }
        return typeParams;
    }

    private static void fixPossiblyRedundantCast(PsiTypeCastExpression cast) throws IncorrectOperationException {
        PsiTypeElement castTypeElement = cast.getCastType();
        if (castTypeElement == null) {
            return;
        }
        PsiClass castClass = PsiUtil.resolveClassInType((PsiType)castTypeElement.getType());
        if (castClass == null) {
            return;
        }
        PsiExpression operand = cast.getOperand();
        if (operand == null) {
            return;
        }
        PsiClass operandClass = PsiUtil.resolveClassInType((PsiType)CommonJavaRefactoringUtil.getTypeByExpression((PsiExpression)operand));
        if (operandClass == null) {
            return;
        }
        if (!castClass.getManager().areElementsEquivalent((PsiElement)castClass, (PsiElement)operandClass) && !operandClass.isInheritor(castClass, true)) {
            return;
        }
        PsiTypeCastExpression exprToReplace = cast;
        while (exprToReplace.getParent() instanceof PsiParenthesizedExpression) {
            exprToReplace = (PsiExpression)exprToReplace.getParent();
        }
        exprToReplace.replace((PsiElement)operand);
    }

    private void buildGraph(PsiReference[] refs) {
        this.myMarkedNodes.clear();
        this.myExpressionsQueue = new ArrayDeque<PsiExpression>(refs.length);
        this.myElementToNode.clear();
        for (PsiReference ref : refs) {
            this.processUsage(ref.getElement());
        }
        this.processQueue();
        this.markNodes();
        this.spreadMarks();
    }

    private void processUsage(PsiElement ref) {
        if (ref instanceof PsiReferenceExpression) {
            PsiElement refMember;
            PsiElement parent = ref.getParent();
            if (parent instanceof PsiReferenceExpression && !this.isInSuper(refMember = ((PsiReferenceExpression)parent).resolve())) {
                this.markNode(ref);
            }
            return;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)parent;
            PsiElement pparent = parent.getParent();
            while (pparent instanceof PsiTypeElement) {
                this.addLink(pparent, parent);
                this.addLink(parent, pparent);
                parent = pparent;
                pparent = parent.getParent();
            }
            this.addLink((PsiElement)typeElement, ref);
            this.addLink(ref, (PsiElement)typeElement);
            if (pparent instanceof PsiVariable) {
                this.processVariableType((PsiVariable)pparent);
            } else if (pparent instanceof PsiMethod) {
                this.processMethodReturnType((PsiMethod)pparent);
            } else if (pparent instanceof PsiTypeCastExpression) {
                this.addLink(pparent, (PsiElement)typeElement);
                this.addLink((PsiElement)typeElement, pparent);
            } else if (pparent instanceof PsiReferenceParameterList) {
                PsiReferenceParameterList refParameterList = (PsiReferenceParameterList)pparent;
                PsiElement ppparent = pparent.getParent();
                if (ppparent instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement classReference = (PsiJavaCodeReferenceElement)ppparent;
                    if (classReference.getParent() instanceof PsiReferenceList) {
                        PsiReferenceList referenceList = (PsiReferenceList)ppparent.getParent();
                        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class);
                        if (parentClass != null && !parentClass.equals((Object)this.myClass) && (referenceList.equals((Object)parentClass.getExtendsList()) || referenceList.equals((Object)parentClass.getImplementsList()))) {
                            PsiTypeElement[] typeParameterElements = refParameterList.getTypeParameterElements();
                            for (int i = 0; i < typeParameterElements.length; ++i) {
                                PsiTypeParameter[] typeParameters;
                                PsiElement resolved;
                                if (typeParameterElements[i] != typeElement || !((resolved = classReference.resolve()) instanceof PsiClass) || (typeParameters = ((PsiClass)resolved).getTypeParameters()).length <= i) continue;
                                this.linkTypeParameterInstantiations(typeParameters[i], typeElement, parentClass);
                                return;
                            }
                        }
                    } else {
                        if (classReference.getParent() instanceof PsiTypeElement) {
                            this.processUsage((PsiElement)classReference);
                            return;
                        }
                        if (classReference.getParent() instanceof PsiNewExpression) {
                            PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)classReference, PsiVariable.class);
                            if (variable != null) {
                                this.processUsage((PsiElement)variable);
                                return;
                            }
                        } else if (classReference.getParent() instanceof PsiAnonymousClass) {
                            this.processUsage((PsiElement)classReference);
                            return;
                        }
                    }
                }
                this.markNode(ref);
            }
        } else if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            if (newExpression.getType() instanceof PsiArrayType) {
                this.addLink((PsiElement)newExpression, ref);
                this.addLink(ref, (PsiElement)newExpression);
                PsiArrayInitializerExpression initializer = newExpression.getArrayInitializer();
                if (initializer != null) {
                    this.addLink(ref, (PsiElement)initializer);
                }
                this.checkToArray(ref, newExpression);
            } else {
                this.markNode(ref);
            }
        } else if (parent instanceof PsiJavaCodeReferenceElement && ref.equals((Object)((PsiJavaCodeReferenceElement)parent).getQualifier())) {
            PsiElement resolved = ((PsiJavaCodeReferenceElement)parent).resolve();
            if (resolved == null || !this.isInSuper(resolved)) {
                this.markNode(ref);
            }
        } else {
            this.markNode(ref);
        }
    }

    private void linkTypeParameterInstantiations(PsiTypeParameter typeParameter, final PsiTypeElement instantiation, final PsiClass inheritingClass) {
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        if (owner instanceof PsiClass) {
            PsiClass ownerClass = (PsiClass)owner;
            final PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)ownerClass, (PsiClass)inheritingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (substitutor == null) {
                return;
            }
            ownerClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                /*
                 * Enabled aggressive block sorting
                 */
                public void visitTypeElement(@NotNull PsiTypeElement parent) {
                    if (parent == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitTypeElement(parent);
                    PsiElement pparent = parent.getParent();
                    if (pparent instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)pparent;
                        if (parent.equals((Object)((PsiMethod)pparent).getReturnTypeElement())) {
                            MethodSignature signature = method.getSignature(substitutor);
                            if (!PsiUtil.isAccessible((PsiMember)method, (PsiElement)inheritingClass, null)) return;
                            PsiMethod inInheritor = MethodSignatureUtil.findMethodBySignature((PsiClass)inheritingClass, (MethodSignature)signature, (boolean)false);
                            if (inInheritor == null) return;
                            if (inInheritor.getReturnTypeElement() == null) return;
                            TurnRefsToSuperProcessorBase.this.addLink((PsiElement)instantiation, (PsiElement)method.getReturnTypeElement());
                            TurnRefsToSuperProcessorBase.this.addLink((PsiElement)method.getReturnTypeElement(), (PsiElement)instantiation);
                            return;
                        }
                    }
                    if (!(pparent instanceof PsiParameter)) return;
                    PsiParameter parameter = (PsiParameter)pparent;
                    PsiElement inInheritor = parameter.getDeclarationScope();
                    if (!(inInheritor instanceof PsiMethod)) return;
                    PsiMethod method = (PsiMethod)inInheritor;
                    int index = ((PsiParameterList)parameter.getParent()).getParameterIndex(parameter);
                    MethodSignature signature = method.getSignature(substitutor);
                    if (!PsiUtil.isAccessible((PsiMember)method, (PsiElement)inheritingClass, null)) return;
                    PsiMethod inInheritor2 = MethodSignatureUtil.findMethodBySignature((PsiClass)inheritingClass, (MethodSignature)signature, (boolean)false);
                    if (inInheritor2 == null) return;
                    PsiParameter[] inheritorParams = inInheritor2.getParameterList().getParameters();
                    LOG.assertTrue(inheritorParams.length > index);
                    PsiTypeElement hisTypeElement = inheritorParams[index].getTypeElement();
                    TurnRefsToSuperProcessorBase.this.addLink((PsiElement)instantiation, (PsiElement)hisTypeElement);
                    TurnRefsToSuperProcessorBase.this.addLink((PsiElement)hisTypeElement, (PsiElement)instantiation);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessorBase$1", "visitTypeElement"));
                }
            });
        }
    }

    private void addArgumentParameterLink(PsiElement arg, PsiExpressionList actualArgsList, PsiMethod method) {
        PsiParameter[] params = method.getParameterList().getParameters();
        int argIndex = ArrayUtil.indexOf((Object[])actualArgsList.getExpressions(), (Object)arg);
        if (argIndex >= 0 && argIndex < params.length) {
            this.addLink((PsiElement)params[argIndex], arg);
        } else if (method.isVarArgs() && argIndex >= params.length) {
            this.addLink((PsiElement)params[params.length - 1], arg);
        }
    }

    private void checkToArray(PsiElement ref, PsiNewExpression newExpression) {
        PsiClass javaUtilCollectionClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass("java.util.Collection", ref.getResolveScope());
        if (javaUtilCollectionClass == null) {
            return;
        }
        PsiElement tmp = newExpression.getParent();
        if (!(tmp instanceof PsiExpressionList)) {
            return;
        }
        if (!((tmp = tmp.getParent()) instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)tmp;
        tmp = tmp.getParent();
        if (!(tmp instanceof PsiTypeCastExpression)) {
            return;
        }
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)tmp;
        PsiReferenceExpression methodRef = methodCall.getMethodExpression();
        tmp = methodRef.resolve();
        if (!(tmp instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)tmp;
        @NonNls String name = method.getName();
        if (!name.equals("toArray")) {
            return;
        }
        PsiClass methodClass = method.getContainingClass();
        if (!methodClass.isInheritor(javaUtilCollectionClass, true)) {
            return;
        }
        this.addLink((PsiElement)typeCast, ref);
    }

    private void processVariableType(PsiVariable variable) {
        final PsiTypeElement type = variable.getTypeElement();
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null) {
            this.addLink((PsiElement)type, (PsiElement)initializer);
        }
        for (PsiReference ref : ReferencesSearch.search((PsiElement)variable).asIterable()) {
            PsiElement element = ref.getElement();
            this.addLink(element, (PsiElement)type);
            this.addLink((PsiElement)type, element);
            this.analyzeVarUsage(element);
        }
        if (variable instanceof PsiParameter) {
            PsiElement declScope = ((PsiParameter)variable).getDeclarationScope();
            if (declScope instanceof PsiCatchSection) {
                this.markNode((PsiElement)type);
            } else if (declScope instanceof PsiForeachStatement) {
                PsiExpression iteratedValue = ((PsiForeachStatement)declScope).getIteratedValue();
                this.addLink((PsiElement)type, (PsiElement)iteratedValue);
            } else if (declScope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)declScope;
                final int index = method.getParameterList().getParameterIndex((PsiParameter)variable);
                for (PsiReference call : ReferencesSearch.search((PsiElement)method).asIterable()) {
                    PsiExpression[] args;
                    PsiExpressionList argumentList;
                    PsiElement ref = call.getElement();
                    if (ref.getParent() instanceof PsiCall) {
                        argumentList = ((PsiCall)ref.getParent()).getArgumentList();
                    } else {
                        if (!(ref.getParent() instanceof PsiAnonymousClass)) continue;
                        argumentList = ((PsiConstructorCall)ref.getParent().getParent()).getArgumentList();
                    }
                    if (argumentList == null || index >= (args = argumentList.getExpressions()).length) continue;
                    this.addLink((PsiElement)type, (PsiElement)args[index]);
                }
                PsiMethod[] superMethods = method.findSuperMethods();
                final class Inner {
                    Inner() {
                    }

                    void linkInheritors(PsiMethod[] methods) {
                        for (PsiMethod superMethod : methods) {
                            PsiParameter[] parameters = superMethod.getParameterList().getParameters();
                            if (index >= parameters.length) continue;
                            PsiTypeElement superType = parameters[index].getTypeElement();
                            TurnRefsToSuperProcessorBase.this.addLink((PsiElement)superType, (PsiElement)type);
                            TurnRefsToSuperProcessorBase.this.addLink((PsiElement)type, (PsiElement)superType);
                        }
                    }
                }
                new Inner().linkInheritors(superMethods);
                PsiClass containingClass = method.getContainingClass();
                ArrayList subClasses = new ArrayList(ClassInheritorsSearch.search((PsiClass)containingClass, (boolean)false).findAll());
                for (int i1 = 0; i1 != subClasses.size(); ++i1) {
                    PsiMethod[] mBSs = ((PsiClass)subClasses.get(i1)).findMethodsBySignature(method, true);
                    new Inner().linkInheritors(mBSs);
                }
            } else {
                LOG.error("Unexpected scope: " + String.valueOf(declScope));
            }
        } else if (variable instanceof PsiResourceVariable) {
            PsiJavaParserFacade facade = JavaPsiFacade.getInstance((Project)this.myProject).getParserFacade();
            this.checkConstrainingType((PsiElement)type, facade.createTypeFromText("java.lang.AutoCloseable", (PsiElement)variable));
        }
    }

    private void analyzeVarUsage(PsiElement element) {
        PsiType constrainingType = null;
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReturnStatement) {
            constrainingType = PsiTypesUtil.getMethodReturnType((PsiElement)parent);
        } else if (parent instanceof PsiAssignmentExpression) {
            constrainingType = ((PsiAssignmentExpression)parent).getLExpression().getType();
        } else if (parent instanceof PsiLocalVariable) {
            constrainingType = ((PsiLocalVariable)parent).getType();
        }
        this.checkConstrainingType(element, constrainingType);
    }

    private void checkConstrainingType(PsiElement element, @Nullable PsiType constrainingType) {
        PsiClass resolved;
        if (!(!(constrainingType instanceof PsiClassType) || this.myClass.equals((Object)(resolved = ((PsiClassType)constrainingType).resolve())) || resolved != null && this.isSuperInheritor(resolved))) {
            this.markNode(element);
        }
    }

    private void processMethodReturnType(PsiMethod method) {
        PsiReturnStatement[] returnStatements;
        final PsiTypeElement returnType = method.getReturnTypeElement();
        for (PsiReturnStatement[] call : ReferencesSearch.search((PsiElement)method).asIterable()) {
            PsiElement ref = call.getElement();
            if (PsiTreeUtil.getParentOfType((PsiElement)ref, PsiDocComment.class) != null) continue;
            PsiElement parent = ref.getParent();
            this.addLink(parent, (PsiElement)returnType);
        }
        for (PsiReturnStatement returnStatement : returnStatements = PsiUtil.findReturnStatements((PsiMethod)method)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) continue;
            this.addLink((PsiElement)returnType, (PsiElement)returnValue);
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        final class Inner {
            Inner() {
            }

            public void linkInheritors(PsiMethod[] methods) {
                for (PsiMethod superMethod : methods) {
                    PsiTypeElement superType = superMethod.getReturnTypeElement();
                    if (superType == null) continue;
                    TurnRefsToSuperProcessorBase.this.addLink((PsiElement)superType, (PsiElement)returnType);
                    TurnRefsToSuperProcessorBase.this.addLink((PsiElement)returnType, (PsiElement)superType);
                }
            }
        }
        new Inner().linkInheritors(superMethods);
        PsiClass containingClass = method.getContainingClass();
        PsiClass[] subClasses = (PsiClass[])ClassInheritorsSearch.search((PsiClass)containingClass, (boolean)false).toArray((Object[])PsiClass.EMPTY_ARRAY);
        for (int i1 = 0; i1 != subClasses.length; ++i1) {
            PsiMethod[] mBSs = subClasses[i1].findMethodsBySignature(method, true);
            new Inner().linkInheritors(mBSs);
        }
    }

    private void processQueue() {
        PsiExpression expr;
        while ((expr = this.myExpressionsQueue.pollFirst()) != null) {
            PsiMethod method;
            PsiElement pparent;
            PsiElement parent = expr.getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                if (assignment.getRExpression() != null) {
                    this.addLink((PsiElement)assignment.getLExpression(), (PsiElement)assignment.getRExpression());
                }
                this.addLink((PsiElement)assignment, (PsiElement)assignment.getLExpression());
                this.addLink((PsiElement)assignment.getLExpression(), (PsiElement)assignment);
                continue;
            }
            if (parent instanceof PsiArrayAccessExpression) {
                PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)parent;
                if (!expr.equals((Object)arrayAccess.getArrayExpression())) continue;
                this.addLink((PsiElement)arrayAccess, (PsiElement)expr);
                this.addLink((PsiElement)expr, (PsiElement)arrayAccess);
                continue;
            }
            if (parent instanceof PsiParenthesizedExpression) {
                this.addLink(parent, (PsiElement)expr);
                this.addLink((PsiElement)expr, parent);
                continue;
            }
            if (parent instanceof PsiArrayInitializerExpression) {
                PsiExpression[] initializers;
                PsiArrayInitializerExpression arrayInitializerExpr = (PsiArrayInitializerExpression)parent;
                for (PsiExpression initializer : initializers = arrayInitializerExpr.getInitializers()) {
                    this.addLink((PsiElement)arrayInitializerExpr, (PsiElement)initializer);
                }
                continue;
            }
            if (!(parent instanceof PsiExpressionList) || !((pparent = parent.getParent()) instanceof PsiCallExpression) || (method = ((PsiCallExpression)pparent).resolveMethod()) == null) continue;
            this.addArgumentParameterLink((PsiElement)expr, (PsiExpressionList)parent, method);
        }
    }

    protected void markNodes() {
        for (PsiElement element : this.myElementToNode.keySet()) {
            if (element instanceof PsiExpression) {
                PsiElement refElement;
                PsiReferenceExpression refExpr;
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiReferenceExpression) || !element.equals((Object)(refExpr = (PsiReferenceExpression)parent).getQualifierExpression()) || (refElement = refExpr.resolve()) == null || this.isInSuper(refElement)) continue;
                this.markNode(element);
                continue;
            }
            if (!this.myReplaceInstanceOf && element.getParent() != null && element.getParent().getParent() instanceof PsiInstanceOfExpression) {
                this.markNode(element);
                continue;
            }
            if (element.getParent() instanceof PsiClassObjectAccessExpression) {
                this.markNode(element);
                continue;
            }
            if (!(element instanceof PsiParameter)) continue;
            PsiType type = TypeConversionUtil.erasure((PsiType)((PsiParameter)element).getType());
            PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type);
            if (aClass != null) {
                if (this.myManager.isInProject(element) && this.myManager.areElementsEquivalent((PsiElement)aClass, (PsiElement)this.myClass) || this.isSuperInheritor(aClass)) continue;
                this.markNode(element);
                continue;
            }
            this.markNode(element);
        }
    }

    protected abstract boolean isSuperInheritor(PsiClass var1);

    protected abstract boolean isInSuper(PsiElement var1);

    protected void addLink(PsiElement source, PsiElement target) {
        Node from = this.myElementToNode.get(source);
        Node to = this.myElementToNode.get(target);
        if (from == null) {
            from = new Node(source);
            if (source instanceof PsiExpression) {
                this.myExpressionsQueue.addLast((PsiExpression)source);
            }
            this.myElementToNode.put(source, from);
        }
        if (to == null) {
            to = new Node(target);
            if (target instanceof PsiExpression) {
                this.myExpressionsQueue.addLast((PsiExpression)target);
            }
            this.myElementToNode.put(target, to);
        }
        Edge.connect(from, to);
    }

    private void spreadMarks() {
        LinkedList<Node> markedNodes = new LinkedList<Node>();
        for (PsiElement markedNode : this.myMarkedNodes) {
            Node node = this.myElementToNode.get(markedNode);
            if (node == null) continue;
            markedNodes.addFirst(node);
        }
        GlobalAnalyzer.doOneEnd(markedNodes, (OneEndFunctor)new Colorer());
    }

    private void markNode(PsiElement node) {
        this.myMarkedNodes.add(node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperProcessorBase", "preprocessUsages"));
    }

    private static final class Node
    extends NodeImpl {
        private final Set<Node> mySuccessors = new HashSet<Node>();
        private VisitMark myMark;

        Node(PsiElement x) {
            this.myMark = new VisitMark(x);
        }

        public Mark getMark() {
            return this.myMark;
        }

        public void setMark(Mark x) {
            this.myMark = (VisitMark)x;
        }
    }

    private static final class Edge
    extends EdgeImpl {
        private Edge(Node from, Node to) {
            super((NodeImpl)from, (NodeImpl)to);
        }

        public static boolean connect(Node from, Node to) {
            if (from.mySuccessors.add(to)) {
                new Edge(from, to);
                return true;
            }
            return false;
        }
    }

    class Colorer
    implements OneEndFunctor {
        Colorer() {
        }

        public Mark compute(Mark from, Mark edge, Mark to) {
            VisitMark mark = new VisitMark((VisitMark)to);
            TurnRefsToSuperProcessorBase.this.myMarkedNodes.add(mark.getElement());
            mark.switchOn();
            return mark;
        }
    }

    private static class VisitMark
    implements Mark {
        private boolean myVisited = false;
        private final PsiElement myElement;

        public boolean coincidesWith(Mark x) {
            return ((VisitMark)x).myVisited == this.myVisited;
        }

        VisitMark(VisitMark m) {
            this.myElement = m.myElement;
        }

        VisitMark(PsiElement e) {
            this.myElement = e;
        }

        public void switchOn() {
            this.myVisited = true;
        }

        public void switchOff() {
            this.myVisited = false;
        }

        public PsiElement getElement() {
            return this.myElement;
        }
    }
}

