/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.typeMigration.usageInfo.OverriddenUsageInfo;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.atomic.AtomicReference;

class MigrateGetterNameSetting {
    private final AtomicReference<Boolean> myGlobalValue = new AtomicReference();

    MigrateGetterNameSetting() {
    }

    void askUserIfNeeded(OverriddenUsageInfo info, String newMethodName, PsiType migrationReturnType) {
        Boolean globalValue = this.myGlobalValue.get();
        if (globalValue == null) {
            String currentName = ((PsiMethod)info.getElement()).getName();
            String messageText = JavaBundle.message((String)"type.migration.getter.rename.suggestion.text", (Object[])new Object[]{currentName, newMethodName, migrationReturnType.getCanonicalText()});
            UIUtil.invokeAndWaitIfNeeded(() -> {
                Boolean globalValue1 = this.myGlobalValue.get();
                if (globalValue1 == null) {
                    int code = MigrateGetterNameSetting.showChooserDialog(messageText);
                    if (code == 0) {
                        this.myGlobalValue.set(true);
                        info.setMigrateMethodName(newMethodName);
                    } else if (code == 1) {
                        info.setMigrateMethodName(newMethodName);
                    } else if (code == 2) {
                        this.myGlobalValue.set(false);
                    }
                } else if (globalValue1.equals(Boolean.TRUE)) {
                    info.setMigrateMethodName(newMethodName);
                }
            });
        } else if (globalValue.equals(Boolean.TRUE)) {
            info.setMigrateMethodName(newMethodName);
        }
    }

    private static int showChooserDialog(@NlsContexts.DialogMessage String messageText) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return messageText.contains("dontMigrateName") ? 3 : 1;
        }
        return Messages.showIdeaMessageDialog(null, (String)messageText, (String)JavaRefactoringBundle.message((String)"type.migration.action.name", (Object[])new Object[0]), (String[])new String[]{JavaBundle.message((String)"type.migration.getter.rename.suggestion.always.migrate.method.names", (Object[])new Object[0]), Messages.getYesButton(), JavaBundle.message((String)"type.migration.getter.rename.suggestion.never.migrate.method.names", (Object[])new Object[0]), Messages.getNoButton()}, (int)0, null, null);
    }
}

