/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FieldConflictsResolver {
    private static final Logger LOG = Logger.getInstance(FieldConflictsResolver.class);
    private final PsiElement myScope;
    private final PsiField myField;
    private final List<PsiReferenceExpression> myReferenceExpressions;
    private PsiClass myQualifyingClass;

    public FieldConflictsResolver(String name, PsiCodeBlock scope) {
        this(name, (PsiElement)scope);
    }

    public FieldConflictsResolver(String name, PsiElement scope) {
        this.myScope = scope;
        if (this.myScope == null) {
            this.myField = null;
            this.myReferenceExpressions = null;
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myScope.getProject());
        PsiVariable oldVariable = facade.getResolveHelper().resolveAccessibleReferencedVariable(name, this.myScope);
        PsiField psiField = this.myField = oldVariable instanceof PsiField ? (PsiField)oldVariable : null;
        if (!(oldVariable instanceof PsiField)) {
            this.myReferenceExpressions = null;
            return;
        }
        this.myReferenceExpressions = new ArrayList<PsiReferenceExpression>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myField, (SearchScope)new LocalSearchScope(this.myScope), (boolean)false).asIterable()) {
            PsiReferenceExpression ref;
            PsiElement psiElement = reference.getElement();
            if (!(psiElement instanceof PsiReferenceExpression) || (ref = (PsiReferenceExpression)psiElement).getQualifierExpression() != null) continue;
            this.myReferenceExpressions.add(ref);
        }
        if (this.myField.hasModifierProperty("static")) {
            this.myQualifyingClass = this.myField.getContainingClass();
        }
    }

    @NotNull
    public PsiExpression fixInitializer(@NotNull PsiExpression initializer) {
        if (initializer == null) {
            FieldConflictsResolver.$$$reportNull$$$0(0);
        }
        if (this.myField == null) {
            PsiExpression psiExpression = initializer;
            if (psiExpression == null) {
                FieldConflictsResolver.$$$reportNull$$$0(1);
            }
            return psiExpression;
        }
        final PsiReferenceExpression[] replacedRef = new PsiReferenceExpression[]{null};
        initializer.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                PsiExpression qualifierExpression;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((qualifierExpression = expression.getQualifierExpression()) != null) {
                    qualifierExpression.accept((PsiElementVisitor)this);
                } else {
                    PsiElement result = expression.resolve();
                    if (expression.getManager().areElementsEquivalent(result, (PsiElement)FieldConflictsResolver.this.myField)) {
                        try {
                            replacedRef[0] = RefactoringChangeUtil.qualifyReference((PsiReferenceExpression)expression, (PsiMember)FieldConflictsResolver.this.myField, (PsiClass)FieldConflictsResolver.this.myQualifyingClass);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/util/FieldConflictsResolver$1", "visitReferenceExpression"));
            }
        });
        if (!initializer.isValid()) {
            PsiReferenceExpression psiReferenceExpression = replacedRef[0];
            if (psiReferenceExpression == null) {
                FieldConflictsResolver.$$$reportNull$$$0(2);
            }
            return psiReferenceExpression;
        }
        PsiExpression psiExpression = initializer;
        if (psiExpression == null) {
            FieldConflictsResolver.$$$reportNull$$$0(3);
        }
        return psiExpression;
    }

    public void fix() throws IncorrectOperationException {
        if (this.myField == null) {
            return;
        }
        PsiManager manager = this.myScope.getManager();
        for (PsiReferenceExpression referenceExpression : this.myReferenceExpressions) {
            PsiElement newlyResolved;
            if (!referenceExpression.isValid() || manager.areElementsEquivalent(newlyResolved = referenceExpression.resolve(), (PsiElement)this.myField)) continue;
            RefactoringChangeUtil.qualifyReference((PsiReferenceExpression)referenceExpression, (PsiMember)this.myField, (PsiClass)this.myQualifyingClass);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/FieldConflictsResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/FieldConflictsResolver";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fixInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fixInitializer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

