/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.AbstractParameterTablePanel;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParameterTablePanel
extends AbstractParameterTablePanel<VariableData> {
    private TypeSelector[] myParameterTypeSelectors;
    private JComboBox<VariableData> myTypeRendererCombo;

    public ParameterTablePanel(Project project, VariableData[] variableData, PsiElement ... scopeElements) {
        this(paramName -> LanguageNamesValidation.isIdentifier((Language)JavaLanguage.INSTANCE, (String)paramName, (Project)project));
        this.init(variableData, project, scopeElements);
    }

    public ParameterTablePanel(Predicate<? super String> parameterNameValidator) {
        super(new ColumnInfo[]{new AbstractParameterTablePanel.PassParameterColumnInfo(), new TypeColumnInfo(), new AbstractParameterTablePanel.NameColumnInfo(parameterNameValidator)});
    }

    public void init(VariableData[] variableData, Project project, PsiElement ... scopeElements) {
        super.init((AbstractVariableData[])variableData);
        this.myParameterTypeSelectors = new TypeSelector[((VariableData[])this.getVariableData()).length];
        for (int i = 0; i < this.myParameterTypeSelectors.length; ++i) {
            TypeSelector selector;
            VariableData data = variableData[i];
            this.myParameterTypeSelectors[i] = selector = this.createSelector(project, data, scopeElements);
            ((VariableData[])this.getVariableData())[i].type = this.myParameterTypeSelectors[i].getSelectedType();
        }
        this.myTypeRendererCombo = new ComboBox((Object[])((VariableData[])this.getVariableData()));
        this.myTypeRendererCombo.setOpaque(true);
        this.myTypeRendererCombo.setBorder(null);
        this.myTypeRendererCombo.setRenderer((ListCellRenderer<VariableData>)SimpleListCellRenderer.create((String)"", value -> value.type.getPresentableText()));
        TableColumn typeColumn = this.myTable.getColumnModel().getColumn(1);
        typeColumn.setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            TypeSelector myCurrentSelector;
            final JBComboBoxTableCellEditorComponent myEditorComponent = new JBComboBoxTableCellEditorComponent();
            final JLabel myTypeLabel = new JLabel();

            @Nullable
            public Object getCellEditorValue() {
                if (this.myCurrentSelector.getComponent() instanceof JLabel) {
                    return this.myCurrentSelector.getSelectedType();
                }
                return this.myEditorComponent.getEditorValue();
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.myCurrentSelector = ParameterTablePanel.this.myParameterTypeSelectors[row];
                if (ParameterTablePanel.this.myParameterTypeSelectors[row].getComponent() instanceof JLabel) {
                    PsiType selectedType = this.myCurrentSelector.getSelectedType();
                    if (selectedType != null) {
                        this.myTypeLabel.setText(selectedType.getPresentableText());
                    }
                    return this.myTypeLabel;
                }
                this.myEditorComponent.setCell(table, row, column);
                this.myEditorComponent.setOptions((Object[])this.myCurrentSelector.getTypes());
                this.myEditorComponent.setDefaultValue((Object)((VariableData[])ParameterTablePanel.this.getVariableData())[row].type);
                this.myEditorComponent.setToString(o -> ((PsiType)o).getPresentableText());
                return this.myEditorComponent;
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){
            private final JBComboBoxLabel myLabel = new JBComboBoxLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value != null) {
                    this.myLabel.setText(((PsiType)value).getPresentableText());
                    this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    this.myLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                    if (isSelected) {
                        this.myLabel.setSelectionIcon();
                    } else {
                        this.myLabel.setRegularIcon();
                    }
                }
                return this.myLabel;
            }
        });
    }

    protected TypeSelector createSelector(Project project, VariableData data, PsiElement[] scopeElements) {
        final PsiVariable variable = data.variable;
        PsiExpression[] occurrences = ParameterTablePanel.findVariableOccurrences(scopeElements, variable);
        TypeSelectorManagerImpl manager = new TypeSelectorManagerImpl(project, data.type, occurrences, this.areTypesDirected()){

            protected boolean isUsedAfter() {
                return ParameterTablePanel.this.isUsedAfter(variable);
            }
        };
        return manager.getTypeSelector();
    }

    protected boolean isUsedAfter(PsiVariable variable) {
        return false;
    }

    public static PsiExpression[] findVariableOccurrences(PsiElement[] scopeElements, final PsiVariable variable) {
        final ArrayList result = new ArrayList();
        for (PsiElement element : scopeElements) {
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    if (expression == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceExpression(expression);
                    if (!expression.isQualified() && expression.isReferenceTo((PsiElement)variable)) {
                        result.add(expression);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/util/ParameterTablePanel$4", "visitReferenceExpression"));
                }
            });
        }
        return result.toArray(PsiExpression.EMPTY_ARRAY);
    }

    protected void exchangeRows(int row, int targetRow, VariableData currentItem) {
        super.exchangeRows(row, targetRow, (AbstractVariableData)currentItem);
        TypeSelector currentSelector = this.myParameterTypeSelectors[row];
        this.myParameterTypeSelectors[row] = this.myParameterTypeSelectors[targetRow];
        this.myParameterTypeSelectors[targetRow] = currentSelector;
        this.myTypeRendererCombo.setModel(new DefaultComboBoxModel<VariableData>((VariableData[])this.getVariableData()));
    }

    private static class TypeColumnInfo
    extends ColumnInfo<VariableData, PsiType> {
        TypeColumnInfo() {
            super(JavaRefactoringBundle.message((String)"parameter.type.table.column.title", (Object[])new Object[0]));
        }

        public void setValue(VariableData data, PsiType value) {
            data.type = value;
        }

        @Nullable
        public PsiType valueOf(VariableData data) {
            return data.type;
        }

        public Class<?> getColumnClass() {
            return PsiType.class;
        }

        public boolean isCellEditable(VariableData data) {
            return true;
        }
    }
}

