/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.IntroduceVariableUtil;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RefactoringUtil {
    private static final Logger LOG = Logger.getInstance(RefactoringUtil.class);
    public static final int EXPR_COPY_SAFE = 0;
    public static final int EXPR_COPY_UNSAFE = 1;
    public static final int EXPR_COPY_PROHIBITED = 2;

    private RefactoringUtil() {
    }

    public static boolean isSourceRoot(PsiDirectory directory) {
        if (directory.getManager() == null) {
            return false;
        }
        Project project = directory.getProject();
        VirtualFile virtualFile = directory.getVirtualFile();
        VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(virtualFile);
        return Comparing.equal((Object)virtualFile, (Object)sourceRootForFile);
    }

    public static PsiElement replaceOccurenceWithFieldRef(PsiExpression occurrence, PsiField newField, PsiClass destinationClass) throws IncorrectOperationException {
        PsiManager manager = destinationClass.getManager();
        String fieldName = newField.getName();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiElement element = (PsiElement)occurrence.getUserData(ElementToWorkOn.PARENT);
        PsiVariable psiVariable = facade.getResolveHelper().resolveAccessibleReferencedVariable(fieldName, (PsiElement)(element != null ? element : occurrence));
        PsiElementFactory factory = facade.getElementFactory();
        if (psiVariable != null && psiVariable.equals((Object)newField)) {
            return IntroduceVariableUtil.replace((PsiExpression)occurrence, (PsiExpression)factory.createExpressionFromText(fieldName, null), (Project)manager.getProject());
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)factory.createExpressionFromText("this." + fieldName, null);
        if (!occurrence.isValid()) {
            return null;
        }
        if (newField.hasModifierProperty("static")) {
            if (destinationClass instanceof PsiImplicitClass) {
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)manager.getProject());
                String name = codeStyleManager.suggestUniqueVariableName(newField.getName(), (PsiElement)occurrence, true);
                if (newField.getName().equals(name)) {
                    ref.setQualifierExpression(null);
                }
            } else {
                ref.setQualifierExpression((PsiExpression)factory.createReferenceExpression(destinationClass));
            }
        }
        return IntroduceVariableUtil.replace((PsiExpression)occurrence, (PsiExpression)ref, (Project)manager.getProject());
    }

    @Nullable
    public static String suggestNewOverriderName(String oldOverriderName, String oldBaseName, String newBaseName) {
        if (oldOverriderName.equals(oldBaseName)) {
            return newBaseName;
        }
        int i = oldOverriderName.startsWith(oldBaseName) ? 0 : StringUtil.indexOfIgnoreCase((String)oldOverriderName, (String)oldBaseName, (int)0);
        if (i >= 0) {
            Object newOverriderName = oldOverriderName.substring(0, i);
            newOverriderName = Character.isUpperCase(oldOverriderName.charAt(i)) ? (String)newOverriderName + StringUtil.capitalize((String)newBaseName) : (String)newOverriderName + newBaseName;
            int j = i + oldBaseName.length();
            if (j < oldOverriderName.length()) {
                newOverriderName = (String)newOverriderName + oldOverriderName.substring(j);
            }
            return newOverriderName;
        }
        return null;
    }

    public static boolean hasOnDemandStaticImport(PsiElement element, PsiClass aClass) {
        PsiImportList importList;
        if (element.getContainingFile() instanceof PsiJavaFile && (importList = ((PsiJavaFile)element.getContainingFile()).getImportList()) != null) {
            Object[] importStaticStatements = importList.getImportStaticStatements();
            return ContainerUtil.exists((Object[])importStaticStatements, stmt -> stmt.isOnDemand() && stmt.resolveTargetClass() == aClass);
        }
        return false;
    }

    public static PsiElement getLoopForLoopCondition(PsiExpression expression) {
        PsiExpression outermost = expression;
        while (outermost.getParent() instanceof PsiExpression) {
            outermost = (PsiExpression)outermost.getParent();
        }
        PsiElement psiElement = outermost.getParent();
        if (psiElement instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)psiElement;
            if (forStatement.getCondition() == outermost) {
                return forStatement;
            }
            return null;
        }
        if (outermost.getParent() instanceof PsiExpressionStatement && (psiElement = outermost.getParent().getParent()) instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)psiElement;
            if (forStatement.getUpdate() == outermost.getParent()) {
                return forStatement;
            }
            return null;
        }
        if (outermost.getParent() instanceof PsiWhileStatement) {
            return outermost.getParent();
        }
        if (outermost.getParent() instanceof PsiDoWhileStatement) {
            return outermost.getParent();
        }
        return null;
    }

    public static PsiClass getThisResolveClass(PsiReferenceExpression place) {
        JavaResolveResult resolveResult = place.advancedResolve(false);
        PsiElement scope = resolveResult.getCurrentFileResolveScope();
        if (scope instanceof PsiClass) {
            return (PsiClass)scope;
        }
        return null;
    }

    public static PsiCall getEnclosingConstructorCall(PsiJavaCodeReferenceElement ref) {
        PsiElement parent = ref.getParent();
        if (ref instanceof PsiReferenceExpression && parent instanceof PsiMethodCallExpression) {
            return (PsiCall)parent;
        }
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        return parent instanceof PsiNewExpression ? (PsiNewExpression)parent : null;
    }

    public static PsiMethod getEnclosingMethod(PsiElement element) {
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class, PsiLambdaExpression.class});
        return container instanceof PsiMethod ? (PsiMethod)container : null;
    }

    public static void renameVariableReferences(PsiVariable variable, String newName, SearchScope scope) throws IncorrectOperationException {
        RefactoringUtil.renameVariableReferences(variable, newName, scope, false);
    }

    public static void renameVariableReferences(PsiVariable variable, String newName, SearchScope scope, boolean ignoreAccessScope) throws IncorrectOperationException {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope, (boolean)ignoreAccessScope).asIterable()) {
            reference.handleElementRename(newName);
        }
    }

    public static PsiJavaCodeReferenceElement removeFromReferenceList(PsiReferenceList refList, PsiClass aClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList.getReferenceElements()) {
            if (!ref.isReferenceTo((PsiElement)aClass)) continue;
            PsiJavaCodeReferenceElement refCopy = (PsiJavaCodeReferenceElement)ref.copy();
            ref.delete();
            return refCopy;
        }
        return null;
    }

    public static PsiJavaCodeReferenceElement findReferenceToClass(PsiReferenceList refList, PsiClass aClass) {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList.getReferenceElements()) {
            if (!ref.isReferenceTo((PsiElement)aClass)) continue;
            return ref;
        }
        return null;
    }

    public static boolean isAssignmentLHS(@NotNull PsiElement element) {
        if (element == null) {
            RefactoringUtil.$$$reportNull$$$0(0);
        }
        return element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element));
    }

    private static void removeFinalParameters(PsiMethod method) throws IncorrectOperationException {
        PsiParameter[] params;
        PsiParameterList paramList = method.getParameterList();
        for (PsiParameter param : params = paramList.getParameters()) {
            if (!param.hasModifierProperty("final")) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)false);
        }
    }

    public static boolean isMethodUsage(PsiElement element) {
        if (element instanceof PsiEnumConstant) {
            return JavaLanguage.INSTANCE.equals(element.getLanguage());
        }
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCall) {
            return true;
        }
        if (parent instanceof PsiAnonymousClass) {
            return element.equals((Object)((PsiAnonymousClass)parent).getBaseClassReference());
        }
        return false;
    }

    @Nullable
    public static PsiExpressionList getArgumentListByMethodReference(PsiElement ref) {
        if (ref instanceof PsiCall) {
            return ((PsiCall)ref).getArgumentList();
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiCall) {
            return ((PsiCall)parent).getArgumentList();
        }
        if (parent instanceof PsiAnonymousClass) {
            return ((PsiNewExpression)parent.getParent()).getArgumentList();
        }
        LOG.assertTrue(false);
        return null;
    }

    public static PsiCall getCallExpressionByMethodReference(PsiElement ref) {
        if (ref instanceof PsiCall) {
            return (PsiCall)ref;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)parent;
        }
        if (parent instanceof PsiNewExpression) {
            return (PsiNewExpression)parent;
        }
        if (parent instanceof PsiAnonymousClass) {
            return (PsiNewExpression)parent.getParent();
        }
        LOG.assertTrue(false);
        return null;
    }

    public static List<RangeHighlighter> highlightAllOccurrences(Project project, PsiElement[] occurrences, Editor editor) {
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        if (occurrences.length > 1) {
            for (PsiElement occurrence : occurrences) {
                RangeMarker rangeMarker = (RangeMarker)occurrence.getUserData(ElementToWorkOn.TEXT_RANGE);
                if (rangeMarker != null && rangeMarker.isValid()) {
                    highlightManager.addRangeHighlight(editor, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, highlighters);
                    continue;
                }
                TextRange textRange = occurrence.getTextRange();
                highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, highlighters);
            }
        }
        return highlighters;
    }

    public static String createTempVar(PsiExpression expr, PsiElement context, boolean declareFinal) throws IncorrectOperationException {
        PsiExpression expr1;
        PsiElement anchorStatement = CommonJavaRefactoringUtil.getParentStatement((PsiElement)context, (boolean)true);
        LOG.assertTrue(anchorStatement != null && anchorStatement.getParent() != null);
        Project project = expr.getProject();
        String[] suggestedNames = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, (PsiExpression)expr, null).names;
        String prefix = suggestedNames.length > 0 ? suggestedNames[0] : "var";
        String id = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(prefix, context, true);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr.getProject());
        if (expr instanceof PsiParenthesizedExpression && (expr1 = ((PsiParenthesizedExpression)expr).getExpression()) != null) {
            expr = expr1;
        }
        PsiDeclarationStatement decl = factory.createVariableDeclarationStatement(id, expr.getType(), expr);
        if (declareFinal) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiLocalVariable)decl.getDeclaredElements()[0]), (String)"final", (boolean)true);
        }
        anchorStatement.getParent().addBefore((PsiElement)decl, anchorStatement);
        return id;
    }

    public static int verifySafeCopyExpression(PsiElement expr) {
        return RefactoringUtil.verifySafeCopyExpressionSubElement(expr);
    }

    private static int verifySafeCopyExpressionSubElement(PsiElement element) {
        PsiElement[] children;
        int result = 0;
        if (element == null) {
            return result;
        }
        if (element instanceof PsiThisExpression || element instanceof PsiSuperExpression || element instanceof PsiIdentifier) {
            return 0;
        }
        if (element instanceof PsiMethodCallExpression) {
            result = 1;
        }
        if (element instanceof PsiNewExpression) {
            return 2;
        }
        if (element instanceof PsiAssignmentExpression) {
            return 2;
        }
        if (PsiUtil.isIncrementDecrementOperation((PsiElement)element)) {
            return 2;
        }
        for (PsiElement child : children = element.getChildren()) {
            int childResult = RefactoringUtil.verifySafeCopyExpressionSubElement(child);
            result = Math.max(result, childResult);
        }
        return result;
    }

    public static void makeMethodAbstract(@NotNull PsiClass targetClass, @NotNull PsiMethod method) throws IncorrectOperationException {
        if (targetClass == null) {
            RefactoringUtil.$$$reportNull$$$0(1);
        }
        if (method == null) {
            RefactoringUtil.$$$reportNull$$$0(2);
        }
        if (!method.hasModifierProperty("default")) {
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                body.delete();
            }
            if (!targetClass.isInterface()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
            }
        }
        if (!targetClass.isInterface()) {
            if (!targetClass.isEnum()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)targetClass, (String)"abstract", (boolean)true);
            }
            RefactoringUtil.prepareForAbstract(method);
        } else {
            RefactoringUtil.prepareForInterface(method);
        }
    }

    public static void makeMethodDefault(@NotNull PsiMethod method) throws IncorrectOperationException {
        if (method == null) {
            RefactoringUtil.$$$reportNull$$$0(3);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"default", (!method.hasModifierProperty("static") ? 1 : 0) != 0);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)false);
        RefactoringUtil.prepareForInterface(method);
    }

    private static void prepareForInterface(PsiMethod method) {
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"private", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"protected", (boolean)false);
        RefactoringUtil.prepareForAbstract(method);
    }

    private static void prepareForAbstract(PsiMethod method) {
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"final", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"synchronized", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"native", (boolean)false);
        RefactoringUtil.removeFinalParameters(method);
    }

    public static boolean isInsideAnonymousOrLocal(PsiElement element, PsiElement upTo) {
        for (PsiElement current = element; current != null && current != upTo; current = current.getParent()) {
            if (current instanceof PsiAnonymousClass) {
                return true;
            }
            if (!(current instanceof PsiClass) || !(current.getParent() instanceof PsiDeclarationStatement)) continue;
            return true;
        }
        return false;
    }

    public static PsiExpression unparenthesizeExpression(PsiExpression expression) {
        while (expression instanceof PsiParenthesizedExpression) {
            PsiExpression innerExpression = ((PsiParenthesizedExpression)expression).getExpression();
            if (innerExpression == null) {
                return expression;
            }
            expression = innerExpression;
        }
        return expression;
    }

    public static String getNewInnerClassName(PsiClass aClass, String oldInnerClassName, String newName) {
        String className = aClass.getName();
        if (className == null || !oldInnerClassName.endsWith(className)) {
            return newName;
        }
        StringBuilder buffer = new StringBuilder(oldInnerClassName);
        buffer.replace(buffer.length() - className.length(), buffer.length(), newName);
        return buffer.toString();
    }

    public static void visitImplicitSuperConstructorUsages(PsiClass subClass, ImplicitConstructorUsageVisitor implicitConstructorUsageVisitor, PsiClass superClass) {
        PsiMethod baseDefaultConstructor = RefactoringUtil.findDefaultConstructor(superClass);
        PsiMethod[] constructors = subClass.getConstructors();
        if (constructors.length > 0) {
            for (PsiMethod constructor : constructors) {
                PsiStatement[] statements;
                PsiCodeBlock body = constructor.getBody();
                if (body == null || (statements = body.getStatements()).length >= 1 && JavaHighlightUtil.isSuperOrThisCall((PsiStatement)statements[0], (boolean)true, (boolean)true)) continue;
                implicitConstructorUsageVisitor.visitConstructor(constructor, baseDefaultConstructor);
            }
        } else {
            implicitConstructorUsageVisitor.visitClassWithoutConstructors(subClass);
        }
    }

    private static PsiMethod findDefaultConstructor(PsiClass aClass) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            if (!constructor.getParameterList().isEmpty()) continue;
            return constructor;
        }
        return null;
    }

    @Deprecated
    public static PsiDirectory findPackageDirectoryInSourceRoot(PackageWrapper aPackage, VirtualFile sourceRoot) {
        return CommonJavaRefactoringUtil.findPackageDirectoryInSourceRoot((PackageWrapper)aPackage, (VirtualFile)sourceRoot);
    }

    @Deprecated
    @NotNull
    public static PsiDirectory createPackageDirectoryInSourceRoot(@NotNull PackageWrapper aPackage, @NotNull VirtualFile sourceRoot) throws IncorrectOperationException {
        if (aPackage == null) {
            RefactoringUtil.$$$reportNull$$$0(4);
        }
        if (sourceRoot == null) {
            RefactoringUtil.$$$reportNull$$$0(5);
        }
        PsiDirectory psiDirectory = CommonJavaRefactoringUtil.createPackageDirectoryInSourceRoot((PackageWrapper)aPackage, (VirtualFile)sourceRoot);
        if (psiDirectory == null) {
            RefactoringUtil.$$$reportNull$$$0(6);
        }
        return psiDirectory;
    }

    public static void replaceMovedMemberTypeParameters(PsiElement member, Iterable<? extends PsiTypeParameter> parametersIterable, PsiSubstitutor substitutor, PsiElementFactory factory) {
        LinkedHashMap<Object, Object> replacement2 = new LinkedHashMap<Object, Object>();
        for (PsiTypeParameter psiTypeParameter : parametersIterable) {
            PsiType substitutedType = substitutor.substitute(psiTypeParameter);
            PsiType erasedType = substitutedType == null ? TypeConversionUtil.erasure((PsiType)factory.createType((PsiClass)psiTypeParameter)) : substitutedType;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiTypeParameter, (SearchScope)new LocalSearchScope(member)).asIterable()) {
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (parent instanceof PsiTypeElement) {
                    if (substitutedType == null) {
                        PsiJavaCodeReferenceElement codeReferenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)parent, PsiJavaCodeReferenceElement.class);
                        if (codeReferenceElement != null) {
                            PsiJavaCodeReferenceElement copy = (PsiJavaCodeReferenceElement)codeReferenceElement.copy();
                            PsiReferenceParameterList parameterList = copy.getParameterList();
                            if (parameterList != null) {
                                parameterList.delete();
                            }
                            replacement2.put(codeReferenceElement, copy);
                            continue;
                        }
                        PsiTypeElement topPsiTypeElement = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)parent, PsiTypeElement.class);
                        if (topPsiTypeElement == null) {
                            topPsiTypeElement = (PsiTypeElement)parent;
                        }
                        replacement2.put(topPsiTypeElement, factory.createTypeElement(TypeConversionUtil.erasure((PsiType)topPsiTypeElement.getType())));
                        continue;
                    }
                    replacement2.put(parent, factory.createTypeElement(substitutedType));
                    continue;
                }
                if (!(element instanceof PsiJavaCodeReferenceElement) || !(erasedType instanceof PsiClassType)) continue;
                replacement2.put(element, factory.createReferenceElementByType((PsiClassType)erasedType));
            }
        }
        for (PsiElement psiElement : replacement2.keySet()) {
            if (!psiElement.isValid()) continue;
            psiElement.replace((PsiElement)replacement2.get(psiElement));
        }
    }

    public static void renameConflictingTypeParameters(PsiMember memberCopy, PsiClass targetClass) {
        if (memberCopy instanceof PsiTypeParameterListOwner && !memberCopy.hasModifierProperty("static")) {
            UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
            PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)targetClass).forEach(param -> {
                String paramName = param.getName();
                if (paramName != null) {
                    nameGenerator.addExistingName(paramName);
                }
            });
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)memberCopy.getProject());
            for (PsiTypeParameter parameter : ((PsiTypeParameterListOwner)memberCopy).getTypeParameters()) {
                String parameterName = parameter.getName();
                if (parameterName == null || nameGenerator.isUnique(parameterName)) continue;
                substitutor = substitutor.put(parameter, PsiSubstitutor.EMPTY.substitute(factory.createTypeParameter(nameGenerator.generateUniqueName(parameterName), PsiClassType.EMPTY_ARRAY)));
            }
            if (!PsiSubstitutor.EMPTY.equals((Object)substitutor)) {
                RefactoringUtil.replaceMovedMemberTypeParameters((PsiElement)memberCopy, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiTypeParameterListOwner)memberCopy)), substitutor, factory);
                for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
                    ((PsiTypeParameter)entry.getKey()).setName(((PsiType)entry.getValue()).getCanonicalText());
                }
            }
        }
    }

    public static boolean isInMovedElement(PsiElement element, Set<? extends PsiMember> membersToMove) {
        for (PsiMember psiMember : membersToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiMember, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean inImportStatement(PsiReference ref, PsiElement element) {
        PsiImportList importList;
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class) != null) {
            return true;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof PsiJavaFile && (importList = ((PsiJavaFile)containingFile).getImportList()) != null) {
            TextRange refRange = ref.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
            for (PsiImportStatementBase importStatementBase : importList.getAllImportStatements()) {
                TextRange textRange = importStatementBase.getTextRange();
                if (!textRange.contains(refRange)) continue;
                return true;
            }
        }
        return false;
    }

    @NlsContexts.DialogMessage
    public static String checkEnumConstantInSwitchLabel(PsiExpression expr) {
        PsiReferenceExpression ref;
        if (PsiImplUtil.getSwitchLabel((PsiCaseLabelElement)expr) != null && (ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expr), PsiReferenceExpression.class)) != null && ref.resolve() instanceof PsiEnumConstant) {
            return JavaRefactoringBundle.message((String)"refactoring.introduce.variable.enum.in.label.message", (Object[])new Object[0]);
        }
        return null;
    }

    public static <T> Set<T> transitiveClosure(Graph<T> graph, Condition<? super T> initialRelation) {
        boolean anyChanged;
        HashSet<T> result = new HashSet<T>();
        Set<T> vertices = graph.getVertices();
        do {
            anyChanged = false;
            block1: for (T currentVertex : vertices) {
                if (result.contains(currentVertex)) continue;
                if (!initialRelation.value(currentVertex)) {
                    Set<T> targets = graph.getTargets(currentVertex);
                    for (T currentTarget : targets) {
                        if (!result.contains(currentTarget) && !initialRelation.value(currentTarget)) continue;
                        result.add(currentVertex);
                        anyChanged = true;
                        continue block1;
                    }
                    continue;
                }
                result.add(currentVertex);
            }
        } while (anyChanged);
        return result;
    }

    public static boolean equivalentTypes(PsiType t1, PsiType t2, PsiManager manager) {
        while (t1 instanceof PsiArrayType) {
            if (!(t2 instanceof PsiArrayType)) {
                return false;
            }
            t1 = ((PsiArrayType)t1).getComponentType();
            t2 = ((PsiArrayType)t2).getComponentType();
        }
        if (t1 instanceof PsiPrimitiveType) {
            return t2 instanceof PsiPrimitiveType && t1.equals(t2);
        }
        return manager.areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)t1), (PsiElement)PsiUtil.resolveClassInType((PsiType)t2));
    }

    public static List<PsiVariable> collectReferencedVariables(PsiElement scope) {
        final ArrayList<PsiVariable> result = new ArrayList<PsiVariable>();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                PsiExpression qualifier;
                PsiElement element;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((element = expression.resolve()) instanceof PsiVariable) {
                    result.add((PsiVariable)element);
                }
                if ((qualifier = expression.getQualifierExpression()) != null) {
                    qualifier.accept((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/util/RefactoringUtil$1", "visitReferenceExpression"));
            }
        });
        return result;
    }

    public static boolean isModifiedInScope(PsiVariable variable, PsiElement scope) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(scope), (boolean)false).asIterable()) {
            if (!RefactoringUtil.isAssignmentLHS(reference.getElement())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/RefactoringUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/RefactoringUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageDirectoryInSourceRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAssignmentLHS";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "makeMethodAbstract";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeMethodDefault";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPackageDirectoryInSourceRoot";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static interface ImplicitConstructorUsageVisitor {
        public void visitConstructor(PsiMethod var1, PsiMethod var2);

        public void visitClassWithoutConstructors(PsiClass var1);
    }

    public static interface Graph<T> {
        public Set<T> getVertices();

        public Set<T> getTargets(T var1);
    }

    public static class IsDescendantOf
    implements Condition<PsiClass> {
        private final PsiClass myClass;
        private final ConditionCache<PsiClass> myConditionCache;

        public IsDescendantOf(PsiClass aClass) {
            this.myClass = aClass;
            this.myConditionCache = new ConditionCache(aClass1 -> InheritanceUtil.isInheritorOrSelf((PsiClass)aClass1, (PsiClass)this.myClass, (boolean)true));
        }

        public boolean value(PsiClass aClass) {
            return this.myConditionCache.value(aClass);
        }
    }

    public static class ConditionCache<T>
    implements Condition<T> {
        private final Condition<? super T> myCondition;
        private final HashSet<T> myProcessedSet = new HashSet();
        private final HashSet<T> myTrueSet = new HashSet();

        public ConditionCache(Condition<? super T> condition) {
            this.myCondition = condition;
        }

        public boolean value(T object) {
            if (!this.myProcessedSet.contains(object)) {
                this.myProcessedSet.add(object);
                boolean value = this.myCondition.value(object);
                if (value) {
                    this.myTrueSet.add(object);
                    return true;
                }
                return false;
            }
            return this.myTrueSet.contains(object);
        }
    }
}

