/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classMembers;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberDependencyGraph;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.classMembers.ClassMembersUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class InterfaceMemberDependencyGraph<T extends PsiMember, M extends MemberInfoBase<T>>
implements MemberDependencyGraph<T, M> {
    private HashSet<T> myInterfaceDependencies;
    private HashMap<T, HashSet<T>> myMembersToInterfacesMap = new HashMap();
    private final HashSet<PsiClass> myImplementedInterfaces;
    private final HashMap<PsiClass, HashSet<T>> myMethodsFromInterfaces;
    private final PsiClass myClass;

    public InterfaceMemberDependencyGraph(PsiClass aClass) {
        this.myClass = aClass;
        this.myImplementedInterfaces = new HashSet();
        this.myMethodsFromInterfaces = new HashMap();
    }

    public synchronized void memberChanged(M memberInfo) {
        if (ClassMembersUtil.isImplementedInterface(memberInfo)) {
            PsiClass aClass = (PsiClass)memberInfo.getMember();
            this.myInterfaceDependencies = null;
            this.myMembersToInterfacesMap = null;
            if (memberInfo.isChecked()) {
                this.myImplementedInterfaces.add(aClass);
            } else {
                this.myImplementedInterfaces.remove(aClass);
            }
        }
    }

    public synchronized Set<? extends T> getDependent() {
        if (this.myInterfaceDependencies == null) {
            HashSet dependencies = new HashSet();
            HashMap membersToInterfacesMap = new HashMap();
            for (PsiClass implementedInterface : this.myImplementedInterfaces) {
                this.addInterfaceDeps(implementedInterface, dependencies, membersToInterfacesMap);
            }
            this.myInterfaceDependencies = dependencies;
            this.myMembersToInterfacesMap = membersToInterfacesMap;
        }
        return this.myInterfaceDependencies;
    }

    public synchronized Set<? extends T> getDependenciesOf(PsiMember member) {
        Set<T> dependent = this.getDependent();
        if (dependent.contains(member)) {
            return this.myMembersToInterfacesMap.get(member);
        }
        return null;
    }

    @NlsContexts.Tooltip
    public String getElementTooltip(PsiMember member) {
        Set<T> dependencies = this.getDependenciesOf(member);
        if (dependencies == null || dependencies.isEmpty()) {
            return null;
        }
        String interfaces = StringUtil.join(dependencies, NavigationItem::getName, (String)", ");
        return RefactoringBundle.message((String)"interface.member.dependency.required.by.interfaces.list", (Object[])new Object[]{dependencies.size(), interfaces});
    }

    private void addInterfaceDeps(PsiClass intf, HashSet<T> dependencies, HashMap<T, HashSet<T>> membersToInterfacesMap) {
        HashSet<Object> interfaceMethods = this.myMethodsFromInterfaces.get(intf);
        if (interfaceMethods == null) {
            interfaceMethods = new HashSet();
            this.buildInterfaceMethods(interfaceMethods, intf);
            this.myMethodsFromInterfaces.put(intf, interfaceMethods);
        }
        for (PsiMember method : interfaceMethods) {
            HashSet<Object> interfaces = membersToInterfacesMap.get(method);
            if (interfaces == null) {
                interfaces = new HashSet();
                membersToInterfacesMap.put(method, interfaces);
            }
            interfaces.add(intf);
        }
        dependencies.addAll(interfaceMethods);
    }

    private void buildInterfaceMethods(HashSet<T> interfaceMethods, PsiClass intf) {
        PsiReferenceList extendsList;
        PsiMethod[] methods;
        for (PsiMethod method1 : methods = intf.getMethods()) {
            PsiMethod method = this.myClass.findMethodBySignature(method1, true);
            if (method == null) continue;
            interfaceMethods.add(method);
        }
        PsiReferenceList implementsList = intf.getImplementsList();
        if (implementsList != null) {
            PsiClassType[] implemented;
            for (PsiClassType aImplemented : implemented = implementsList.getReferencedTypes()) {
                PsiClass resolved = aImplemented.resolve();
                if (resolved == null) continue;
                this.buildInterfaceMethods(interfaceMethods, resolved);
            }
        }
        if ((extendsList = intf.getExtendsList()) != null) {
            PsiClassType[] extended;
            for (PsiClassType aExtended : extended = extendsList.getReferencedTypes()) {
                PsiClass ref = aExtended.resolve();
                if (ref == null) continue;
                this.buildInterfaceMethods(interfaceMethods, ref);
            }
        }
    }
}

