/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.util.duplicates.ConstantMatchProvider;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesMatchProvider;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MatchProvider {
    public void prepareSignature(Match var1);

    public PsiElement processMatch(Match var1) throws IncorrectOperationException;

    public List<Match> getDuplicates();

    @Nullable
    public Boolean hasDuplicates();

    @NlsContexts.Label
    @Nullable
    public String getConfirmDuplicatePrompt(Match var1);

    @NlsContexts.DialogTitle
    public String getReplaceDuplicatesTitle(int var1, int var2);

    @NotNull
    public static MatchProvider create(@NotNull PsiMember member, @NotNull List<Match> matches) {
        MatchProvider matchProvider;
        if (member == null) {
            MatchProvider.$$$reportNull$$$0(0);
        }
        if (matches == null) {
            MatchProvider.$$$reportNull$$$0(1);
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            matchProvider = new MethodDuplicatesMatchProvider(method, matches);
        } else {
            matchProvider = new ConstantMatchProvider(member, member.getProject(), matches);
        }
        return matchProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "member";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "matches";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/util/duplicates/MatchProvider";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

