/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesMatchProvider;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodDuplicatesHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(MethodDuplicatesHandler.class);

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(2);
        }
        PsiMember member = MethodDuplicatesHandler.findMember(editor, file);
        return MethodDuplicatesHandler.isAvailableOn(member);
    }

    public static boolean isAvailableOn(PsiMember member) {
        return member != null && MethodDuplicatesHandler.getCannotRefactorMessage(member) == null;
    }

    @Nullable
    private static PsiMember findMember(@Nullable Editor editor, @Nullable PsiFile file) {
        if (editor == null || file == null) {
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiMethod member = MethodUtils.getJavaMethodFromHeader((PsiElement)element);
        if (member == null) {
            member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        }
        return member;
    }

    @NlsActions.ActionText
    public static String getActionName(DataContext dataContext) {
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project != null && editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            PsiMember member = MethodDuplicatesHandler.findMember(editor, file);
            if (member instanceof PsiField) {
                return ActionsBundle.message((String)"action.MethodDuplicates.field.text", (Object[])new Object[0]);
            }
            if (member instanceof PsiMethod) {
                return ActionsBundle.message((String)"action.MethodDuplicates.method.text", (Object[])new Object[0]);
            }
        }
        return ActionsBundle.message((String)"action.MethodDuplicates.text", (Object[])new Object[0]);
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        int offset;
        PsiElement element;
        PsiMember member;
        String cannotRefactorMessage;
        if (project == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(3);
        }
        if ((cannotRefactorMessage = MethodDuplicatesHandler.getCannotRefactorMessage(member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)(element = file.findElementAt(offset = editor.getCaretModel().getOffset())), PsiMember.class))) != null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)cannotRefactorMessage);
            MethodDuplicatesHandler.showErrorMessage(message, project, editor);
            return;
        }
        AnalysisScope scope = new AnalysisScope(file);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(JavaRefactoringBundle.message((String)"replace.method.duplicates.scope.chooser.title", (Object[])new Object[]{MethodDuplicatesHandler.getRefactoringName()}), JavaRefactoringBundle.message((String)"replace.method.duplicates.scope.chooser.message", (Object[])new Object[0]), project, BaseAnalysisActionDialog.standardItems((Project)project, (AnalysisScope)scope, (Module)module, (PsiElement)element), AnalysisUIOptions.getInstance((Project)project), false);
        if (dlg.showAndGet()) {
            final AnalysisScope selectedScope = dlg.getScope(scope);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, project, JavaRefactoringBundle.message((String)"locate.duplicates.action.name", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    MethodDuplicatesHandler.invokeOnScope(project, member, selectedScope);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler$1", "run"));
                }
            });
        }
    }

    @NlsContexts.DialogMessage
    @Nullable
    private static String getCannotRefactorMessage(PsiMember member) {
        if (member == null) {
            return JavaRefactoringBundle.message((String)"locate.caret.inside.a.method", (Object[])new Object[0]);
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            if (method.isConstructor()) {
                return JavaRefactoringBundle.message((String)"replace.with.method.call.does.not.work.for.constructors", (Object[])new Object[0]);
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return JavaRefactoringBundle.message((String)"method.does.not.have.a.body", (Object[])new Object[]{member.getName()});
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return JavaRefactoringBundle.message((String)"method.has.an.empty.body", (Object[])new Object[]{member.getName()});
            }
        } else if (member instanceof PsiField) {
            PsiField field = (PsiField)member;
            if (field.getInitializer() == null) {
                return JavaRefactoringBundle.message((String)"dialog.message.field.doesnt.have.initializer", (Object[])new Object[]{member.getName()});
            }
            PsiClass containingClass = field.getContainingClass();
            if (!field.hasModifierProperty("final") || !field.hasModifierProperty("static") || containingClass == null || containingClass.getQualifiedName() == null) {
                return JavaRefactoringBundle.message((String)"dialog.message.replace.duplicates.works.with.constants.only", (Object[])new Object[0]);
            }
        } else {
            return JavaRefactoringBundle.message((String)"dialog.message.caret.should.be.inside.method.or.constant", (Object[])new Object[0]);
        }
        return null;
    }

    public static void invokeOnScope(Project project, PsiMember member, AnalysisScope scope) {
        MethodDuplicatesHandler.invokeOnScope(project, Collections.singleton(member), scope, false);
    }

    public static void invokeOnScope(Project project, Set<? extends PsiMember> members, AnalysisScope scope, boolean silent) {
        ReadAction.nonBlocking(() -> MethodDuplicatesHandler.computeProviderMap(project, members, scope)).expireWhen(() -> ContainerUtil.exists((Iterable)members, m -> !m.isValid())).finishOnUiThread(ModalityState.nonModal(), providerMap -> {
            if (providerMap.isEmpty()) {
                if (!silent) {
                    String message = JavaRefactoringBundle.message((String)"idea.has.not.found.any.code.that.can.be.replaced.with.method.call", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
                    Messages.showInfoMessage((Project)project, (String)message, (String)MethodDuplicatesHandler.getRefactoringName());
                }
            } else {
                MethodDuplicatesHandler.replaceDuplicate(project, providerMap.values());
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @RequiresReadLock
    @NotNull
    private static Map<PsiMember, MatchProvider> computeProviderMap(final @NotNull Project project, final @NotNull Set<? extends PsiMember> members, @NotNull AnalysisScope scope) {
        if (project == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(4);
        }
        if (members == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.softAssertReadAccess();
        final HashMap duplicates = new HashMap();
        final int fileCount = scope.getFileCount();
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(false);
        }
        final HashMap memberWithModulesMap = new HashMap();
        for (PsiMember psiMember : members) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMember);
            if (module == null) continue;
            HashSet dependencies = new HashSet();
            ModuleUtilCore.collectModulesDependsOn((Module)module, dependencies);
            memberWithModulesMap.put(psiMember, dependencies);
        }
        scope.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){
            private int myFileCount;

            public void visitFile(@NotNull PsiFile psiFile) {
                Module targetModule;
                if (psiFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (progressIndicator != null) {
                    if (progressIndicator.isCanceled()) {
                        return;
                    }
                    progressIndicator.setFraction((double)this.myFileCount++ / (double)fileCount);
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (virtualFile != null) {
                        progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                    }
                }
                if ((targetModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) == null) {
                    return;
                }
                for (Map.Entry entry : memberWithModulesMap.entrySet()) {
                    Set dependencies = (Set)entry.getValue();
                    if (dependencies == null || !dependencies.contains(targetModule)) continue;
                    PsiMember member = (PsiMember)entry.getKey();
                    List<Match> matchList = MethodDuplicatesHandler.hasDuplicates((PsiElement)psiFile, member);
                    Iterator<Match> iterator = matchList.iterator();
                    while (iterator.hasNext()) {
                        PsiMethod method;
                        Match match = iterator.next();
                        PsiElement matchStart = match.getMatchStart();
                        PsiElement matchEnd = match.getMatchEnd();
                        for (PsiMember psiMember : members) {
                            if (!PsiTreeUtil.isAncestor((PsiElement)psiMember, (PsiElement)matchStart, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)psiMember, (PsiElement)matchEnd, (boolean)false)) continue;
                            iterator.remove();
                            break;
                        }
                        if (!(member instanceof PsiMethod) || (method = (PsiMethod)member).findDeepestSuperMethods().length <= 0 || !MethodDuplicatesMatchProvider.isEssentialStaticContextAbsent(match, method)) continue;
                        iterator.remove();
                    }
                    if (matchList.isEmpty()) continue;
                    duplicates.computeIfAbsent(member, __ -> new ArrayList()).addAll(matchList);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler$2", "visitFile"));
            }
        });
        Map map = EntryStream.of(duplicates).mapToValue(MatchProvider::create).toMap();
        if (map == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(7);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public static void replaceDuplicate(@NotNull Project project, @NotNull Collection<MatchProvider> duplicates) {
        if (project == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(8);
        }
        if (duplicates == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (duplicates.isEmpty()) {
            return;
        }
        LocalHistoryAction a = LocalHistory.getInstance().startAction(MethodDuplicatesHandler.getRefactoringName());
        try {
            for (MatchProvider matchProvider : duplicates) {
                int duplicatesNo = matchProvider.getDuplicates().size();
                WindowManager.getInstance().getStatusBar(project).setInfo(MethodDuplicatesHandler.getStatusMessage(duplicatesNo));
                CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> DuplicatesImpl.invoke(project, matchProvider, true)), MethodDuplicatesHandler.getRefactoringName(), (Object)MethodDuplicatesHandler.getRefactoringName());
                WindowManager.getInstance().getStatusBar(project).setInfo("");
            }
        }
        finally {
            a.finish();
        }
    }

    public static List<Match> hasDuplicates(PsiElement file, PsiMember member) {
        DuplicatesFinder duplicatesFinder = MethodDuplicatesHandler.createDuplicatesFinder(member);
        if (duplicatesFinder == null) {
            return Collections.emptyList();
        }
        return duplicatesFinder.findDuplicates(file);
    }

    @Nullable
    private static DuplicatesFinder createDuplicatesFinder(PsiMember member) {
        PsiElement[] pattern;
        VariableReturnValue matchedReturnValue = null;
        if (member instanceof PsiMethod) {
            PsiCodeBlock body = ((PsiMethod)member).getBody();
            LOG.assertTrue(body != null);
            PsiStatement[] statements = body.getStatements();
            pattern = statements;
            matchedReturnValue = null;
            if (statements.length != 1 || !(statements[0] instanceof PsiReturnStatement)) {
                PsiElement resolved;
                PsiExpression returnValue;
                PsiStatement lastStatement;
                PsiStatement psiStatement = lastStatement = statements.length > 0 ? statements[statements.length - 1] : null;
                if (lastStatement instanceof PsiReturnStatement && (returnValue = ((PsiReturnStatement)lastStatement).getReturnValue()) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiVariable) {
                    pattern = new PsiElement[statements.length - 1];
                    System.arraycopy(statements, 0, pattern, 0, statements.length - 1);
                    matchedReturnValue = new VariableReturnValue((PsiVariable)resolved);
                }
            } else {
                PsiExpression returnValue = ((PsiReturnStatement)statements[0]).getReturnValue();
                if (returnValue != null) {
                    pattern = new PsiElement[]{returnValue};
                }
            }
        } else {
            pattern = new PsiElement[]{((PsiField)member).getInitializer()};
        }
        if (pattern.length == 0) {
            return null;
        }
        ArrayList inputVariables = member instanceof PsiMethod ? Arrays.asList(((PsiMethod)member).getParameterList().getParameters()) : new ArrayList();
        return new DuplicatesFinder(pattern, new InputVariables(inputVariables, member.getProject(), new LocalSearchScope(pattern), false, Collections.emptySet()), matchedReturnValue, new ArrayList());
    }

    @NlsContexts.StatusBarText
    @NotNull
    private static String getStatusMessage(int duplicatesNo) {
        String string = JavaRefactoringBundle.message((String)"method.duplicates.found.message", (Object[])new Object[]{duplicatesNo});
        if (string == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static void showErrorMessage(@NlsContexts.DialogMessage String message, Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)MethodDuplicatesHandler.getRefactoringName(), (String)"refactoring.replaceMethodCodeDuplicates");
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(11);
        }
        if (elements == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException();
    }

    @NlsContexts.ProgressTitle
    public static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"replace.method.code.duplicates.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProviderMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeProviderMap";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceDuplicate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10 -> new IllegalStateException(string);
        };
    }
}

