/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MatchUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class MethodDuplicatesMatchProvider
implements MatchProvider {
    private final PsiMethod myMethod;
    private final List<Match> myDuplicates;
    private static final Logger LOG = Logger.getInstance(MethodDuplicatesMatchProvider.class);
    private final Map<Match, @Nls String> myConfirmDuplicatePrompts;

    MethodDuplicatesMatchProvider(PsiMethod method, List<Match> duplicates) {
        this.myMethod = method;
        this.myDuplicates = duplicates;
        this.myConfirmDuplicatePrompts = StreamEx.of(duplicates).mapToEntry(this::computeConfirmDuplicatePrompt).nonNullValues().toMap();
    }

    @Override
    public void prepareSignature(Match match) {
        MatchUtil.changeSignature(match, this.myMethod);
    }

    @Override
    public PsiElement processMatch(Match match) throws IncorrectOperationException {
        PsiElement var;
        PsiExpression value;
        PsiParameter[] parameters;
        PsiClass containingClass = this.myMethod.getContainingClass();
        if (MethodDuplicatesMatchProvider.isEssentialStaticContextAbsent(match, this.myMethod)) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myMethod, (String)"static", (boolean)true);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject());
        boolean needQualifier = match.getInstanceExpression() != null;
        boolean needStaticQualifier = MethodDuplicatesMatchProvider.isExternal(match, this.myMethod);
        boolean nameConflicts = this.nameConflicts(match);
        String methodName = this.myMethod.isConstructor() ? "this" : this.myMethod.getName();
        @NonNls String text = needQualifier || needStaticQualifier || nameConflicts ? "q." + methodName + "()" : methodName + "()";
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)factory.createExpressionFromText(text, null);
        methodCallExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((PsiManager)this.myMethod.getManager()).reformat((PsiElement)methodCallExpression);
        for (PsiParameter parameter : parameters = this.myMethod.getParameterList().getParameters()) {
            List parameterValue = match.getParameterValues((PsiVariable)parameter);
            if (parameterValue != null) {
                for (PsiElement val : parameterValue) {
                    methodCallExpression.getArgumentList().add(val);
                }
                continue;
            }
            methodCallExpression.getArgumentList().add((PsiElement)factory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)parameter.getType(), (boolean)true), (PsiElement)parameter));
        }
        if (needQualifier || needStaticQualifier || nameConflicts) {
            PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
            LOG.assertTrue(qualifierExpression != null);
            if (needQualifier) {
                qualifierExpression.replace((PsiElement)match.getInstanceExpression());
            } else if (needStaticQualifier || this.myMethod.hasModifierProperty("static")) {
                qualifierExpression.replace((PsiElement)factory.createReferenceExpression(containingClass));
            } else {
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)match.getMatchStart(), PsiClass.class);
                if (psiClass != null && psiClass.isInheritor(containingClass, true)) {
                    qualifierExpression.replace((PsiElement)RefactoringChangeUtil.createSuperExpression((PsiManager)containingClass.getManager(), null));
                } else {
                    qualifierExpression.replace((PsiElement)RefactoringChangeUtil.createThisExpression((PsiManager)containingClass.getManager(), (PsiClass)containingClass));
                }
            }
        }
        VisibilityUtil.escalateVisibility((PsiMember)this.myMethod, (PsiElement)match.getMatchStart());
        PsiCodeBlock body = this.myMethod.getBody();
        assert (body != null);
        PsiStatement[] statements = body.getStatements();
        if (statements[statements.length - 1] instanceof PsiReturnStatement && (value = ((PsiReturnStatement)statements[statements.length - 1]).getReturnValue()) instanceof PsiReferenceExpression && (var = ((PsiReferenceExpression)value).resolve()) instanceof PsiVariable) {
            match.replace(this.myMethod, methodCallExpression, (PsiVariable)var);
            return methodCallExpression;
        }
        return match.replace(this.myMethod, methodCallExpression, null);
    }

    private static boolean isExternal(Match match, PsiMethod method) {
        PsiElement matchStart = match.getMatchStart();
        PsiClass containingClass = method.getContainingClass();
        if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)matchStart, (boolean)false)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)matchStart, PsiClass.class);
        while (psiClass != null) {
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)containingClass, (boolean)true)) {
                return false;
            }
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
        }
        return true;
    }

    private boolean nameConflicts(Match match) {
        PsiClass matchClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)match.getMatchStart(), PsiClass.class);
        while (matchClass != null && matchClass != this.myMethod.getContainingClass()) {
            if (matchClass.findMethodsBySignature(this.myMethod, false).length > 0) {
                return true;
            }
            matchClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)matchClass, PsiClass.class);
        }
        return false;
    }

    public static boolean isEssentialStaticContextAbsent(Match match, PsiMethod method) {
        if (!method.hasModifierProperty("static")) {
            PsiExpression instanceExpression = match.getInstanceExpression();
            if (instanceExpression != null) {
                return false;
            }
            if (MethodDuplicatesMatchProvider.isExternal(match, method)) {
                return true;
            }
            PsiElement matchStart = match.getMatchStart();
            PsiClass containingClass = method.getContainingClass();
            if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)matchStart, (boolean)false)) {
                if (CommonJavaRefactoringUtil.isInStaticContext((PsiElement)matchStart, (PsiClass)containingClass)) {
                    return true;
                }
            } else {
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)matchStart, PsiClass.class);
                while (psiClass != null) {
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)containingClass, (boolean)true)) {
                        if (!CommonJavaRefactoringUtil.isInStaticContext((PsiElement)matchStart, (PsiClass)psiClass)) break;
                        return true;
                    }
                    psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
                }
            }
        }
        return false;
    }

    @Override
    public List<Match> getDuplicates() {
        return this.myDuplicates;
    }

    @Override
    public Boolean hasDuplicates() {
        return this.myDuplicates.isEmpty();
    }

    @Override
    @Nullable
    public String getConfirmDuplicatePrompt(Match match) {
        return this.myConfirmDuplicatePrompts.get(match);
    }

    @Nls
    @Nullable
    private String computeConfirmDuplicatePrompt(Match match) {
        boolean needToEscalateVisibility;
        PsiElement matchStart = match.getMatchStart();
        String visibility = VisibilityUtil.getPossibleVisibility((PsiMember)this.myMethod, (PsiElement)matchStart);
        boolean shouldBeStatic = MethodDuplicatesMatchProvider.isEssentialStaticContextAbsent(match, this.myMethod);
        String signature = MatchUtil.getChangedSignature(match, this.myMethod, this.myMethod.hasModifierProperty("static") || shouldBeStatic, visibility);
        if (signature != null) {
            return JavaRefactoringBundle.message((String)"replace.this.code.fragment.and.change.signature", (Object[])new Object[]{signature});
        }
        boolean bl = needToEscalateVisibility = !PsiUtil.isAccessible((PsiMember)this.myMethod, (PsiElement)matchStart, null);
        if (needToEscalateVisibility) {
            String visibilityPresentation = VisibilityUtil.toPresentableText((String)visibility);
            return shouldBeStatic ? JavaRefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.static.visible", (Object[])new Object[]{visibilityPresentation}) : JavaRefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.visible", (Object[])new Object[]{visibilityPresentation});
        }
        if (shouldBeStatic) {
            return JavaRefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.static", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public String getReplaceDuplicatesTitle(int idx, int size) {
        return JavaRefactoringBundle.message((String)"process.methods.duplicates.title", (Object[])new Object[]{idx, size, this.myMethod.getName()});
    }
}

