/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.occurrences;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.util.occurrences.OccurrenceFilter;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.util.CommonJavaRefactoringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class BaseOccurrenceManager
implements OccurrenceManager {
    private PsiExpression[] myOccurrences;
    private PsiElement myAnchorStatement;
    protected final OccurrenceFilter myFilter;

    public BaseOccurrenceManager(OccurrenceFilter filter) {
        this.myFilter = filter;
    }

    @Override
    public PsiExpression[] getOccurrences() {
        if (this.myOccurrences == null) {
            this.myOccurrences = this.findOccurrences();
            if (this.myFilter != null) {
                ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
                for (PsiExpression occurrence : this.myOccurrences) {
                    if (!this.myFilter.isOK(occurrence)) continue;
                    result.add(occurrence);
                }
                this.myOccurrences = result.isEmpty() ? this.defaultOccurrences() : result.toArray(PsiExpression.EMPTY_ARRAY);
            }
            if (this.getAnchorStatementForAll() == null) {
                this.myOccurrences = this.defaultOccurrences();
            }
        }
        return this.myOccurrences;
    }

    protected abstract PsiExpression @NotNull [] defaultOccurrences();

    protected abstract PsiExpression @NotNull [] findOccurrences();

    @Override
    public boolean isInFinalContext() {
        return BaseOccurrenceManager.needToDeclareFinal(this.myOccurrences);
    }

    @Override
    public PsiElement getAnchorStatementForAll() {
        if (this.myAnchorStatement == null) {
            this.myAnchorStatement = this.getAnchorStatementForAllInScope(null);
        }
        return this.myAnchorStatement;
    }

    @Override
    public PsiElement getAnchorStatementForAllInScope(PsiElement scope) {
        PsiElement anchor = CommonJavaRefactoringUtil.getAnchorElementForMultipleExpressions((PsiExpression[])this.myOccurrences, (PsiElement)scope);
        return anchor instanceof PsiField && ((PsiField)anchor).hasInitializer() && !(anchor instanceof PsiEnumConstant) ? ((PsiField)anchor).getInitializer() : anchor;
    }

    private static boolean needToDeclareFinal(PsiExpression[] occurrences) {
        PsiElement scopeToDeclare = null;
        for (PsiExpression occurrence : occurrences) {
            PsiElement data = (PsiElement)occurrence.getUserData(ElementToWorkOn.PARENT);
            PsiElement element = data != null ? data : occurrence;
            scopeToDeclare = scopeToDeclare == null ? element : PsiTreeUtil.findCommonParent((PsiElement)scopeToDeclare, (PsiElement)element);
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiSwitchLabelStatement.class, (boolean)true, (Class[])new Class[]{PsiStatement.class}) == null) continue;
            return true;
        }
        if (scopeToDeclare == null) {
            return false;
        }
        for (PsiExpression occurrence : occurrences) {
            PsiElement parent = BaseExpressionToFieldHandler.getPhysicalElement(occurrence);
            while (parent != null && !parent.equals((Object)scopeToDeclare)) {
                if (!((parent = parent.getParent()) instanceof PsiClass)) continue;
                return !PsiUtil.isLanguageLevel8OrHigher((PsiElement)parent);
            }
        }
        return false;
    }
}

