/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.functional;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractMethod.ControlFlowWrapper;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtractToMethodReferenceIntention
extends BaseElementAtCaretIntentionAction {
    private static final Logger LOG = Logger.getInstance(ExtractToMethodReferenceIntention.class);

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = IntentionPowerPackBundle.message((String)"extract.to.method.reference.intention.name", (Object[])new Object[0]);
        if (string == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        PsiLambdaExpression lambdaExpression;
        if (project == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(4);
        }
        if ((lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class, (boolean)false)) != null) {
            PsiElement body = lambdaExpression.getBody();
            if (body == null) {
                return false;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType == null || LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType) == null) {
                return false;
            }
            if (LambdaUtil.createLambdaParameterListWithFormalTypes((PsiType)functionalInterfaceType, (PsiLambdaExpression)lambdaExpression, (boolean)false) == null) {
                return false;
            }
            PsiClass targetClass = PsiUtil.getContainingClass((PsiElement)lambdaExpression);
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiMethod.class, (boolean)true);
            if (targetClass == null || targetClass instanceof PsiImplicitClass && method != null && method.hasModifierProperty("static")) {
                return false;
            }
            PsiExpression asMethodReference = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiElement)body, (PsiVariable[])lambdaExpression.getParameterList().getParameters(), (PsiType)functionalInterfaceType, null);
            if (asMethodReference != null) {
                return false;
            }
            try {
                PsiStatement[] psiStatementArray;
                if (body instanceof PsiCodeBlock) {
                    psiStatementArray = ((PsiCodeBlock)body).getStatements();
                } else {
                    PsiElement[] psiElementArray = new PsiElement[1];
                    psiStatementArray = psiElementArray;
                    psiElementArray[0] = body;
                }
                PsiStatement[] toExtract = psiStatementArray;
                ControlFlowWrapper wrapper = new ControlFlowWrapper(body, (PsiElement[])toExtract);
                wrapper.prepareAndCheckExitStatements((PsiElement[])toExtract, body);
                PsiVariable[] outputVariables = wrapper.getOutputVariables();
                List inputVariables = wrapper.getInputVariables(body, (PsiElement[])toExtract, outputVariables);
                return ContainerUtil.and((Iterable)inputVariables, variable -> variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() == lambdaExpression);
            }
            catch (ControlFlowWrapper.ExitStatementsNotSameException | PrepareFailedException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        PsiLambdaExpression lambdaExpression;
        if (project == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ExtractToMethodReferenceIntention.$$$reportNull$$$0(7);
        }
        if ((lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class, (boolean)false)) != null) {
            HashSet usedFields;
            PsiCodeBlock body = CommonJavaRefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)lambdaExpression);
            PsiClass targetClass = PsiUtil.getContainingClass((PsiElement)lambdaExpression);
            if (targetClass == null) {
                return;
            }
            PsiStatement[] elements = body.getStatements();
            boolean canBeStatic = CommonJavaRefactoringUtil.canBeStatic((PsiClass)targetClass, (PsiElement)lambdaExpression, (PsiElement[])elements, usedFields = new HashSet()) && usedFields.isEmpty() && !(targetClass instanceof PsiImplicitClass);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)targetClass.getProject());
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            String parameters = LambdaUtil.createLambdaParameterListWithFormalTypes((PsiType)functionalInterfaceType, (PsiLambdaExpression)lambdaExpression, (boolean)false) + "{}";
            String targetMethodName = ExtractToMethodReferenceIntention.getUniqueMethodName(targetClass, elementFactory, functionalInterfaceType, parameters);
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression);
            LOG.assertTrue(returnType != null);
            PsiMethod container = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiMethod.class);
            PsiTypeParameterList typeParamsList = container != null ? CommonJavaRefactoringUtil.createTypeParameterListWithUsedTypeParameters((PsiTypeParameterList)container.getTypeParameterList(), (PsiElement[])elements) : null;
            PsiMethod emptyMethod = elementFactory.createMethodFromText("private " + (canBeStatic ? "static " : "") + (String)(typeParamsList != null ? typeParamsList.getText() + " " : "") + returnType.getCanonicalText() + " " + targetMethodName + parameters, (PsiElement)targetClass);
            PsiCodeBlock targetMethodBody = emptyMethod.getBody();
            LOG.assertTrue(targetMethodBody != null);
            targetMethodBody.replace((PsiElement)body);
            PsiMethod method = (PsiMethod)CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(targetClass.add((PsiElement)emptyMethod)));
            PsiMethodReferenceExpression methodReference = (PsiMethodReferenceExpression)elementFactory.createExpressionFromText((canBeStatic ? targetClass.getName() : "this") + "::" + targetMethodName, (PsiElement)lambdaExpression);
            CommentTracker tracker = new CommentTracker();
            tracker.markUnchanged(lambdaExpression.getBody());
            methodReference = (PsiMethodReferenceExpression)tracker.replace((PsiElement)lambdaExpression, (PsiElement)methodReference);
            tracker.insertCommentsBefore((PsiElement)methodReference);
            ExtractToMethodReferenceIntention.startInplaceRename(editor, method, methodReference);
        }
    }

    private static void startInplaceRename(final Editor editor, final PsiMethod method, PsiMethodReferenceExpression methodReference) {
        if (!method.isPhysical()) {
            return;
        }
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        if ((nameIdentifier = (PsiIdentifier)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)nameIdentifier)) == null) {
            return;
        }
        editor.getCaretModel().moveToOffset(((PsiElement)ObjectUtils.notNull((Object)methodReference.getReferenceNameElement(), (Object)nameIdentifier)).getTextOffset());
        RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)method);
        if (!processor.isInplaceRenameSupported()) {
            return;
        }
        final ArrayList<String> suggestedNames = new ArrayList<String>();
        suggestedNames.add(method.getName());
        processor.substituteElementToRename((PsiElement)method, editor, (Pass)new Pass<PsiElement>(){

            public void pass(PsiElement substitutedElement) {
                final SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)method);
                MemberInplaceRenamer renamer = new MemberInplaceRenamer(this, (PsiNamedElement)method, substitutedElement, editor){

                    protected boolean performRefactoring() {
                        if (super.performRefactoring()) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                PsiMethod restored = (PsiMethod)pointer.getElement();
                                if (restored != null) {
                                    ExtractToMethodReferenceIntention.processMethodsDuplicates(restored);
                                }
                            });
                            return true;
                        }
                        return false;
                    }
                };
                LinkedHashSet nameSuggestions = new LinkedHashSet(suggestedNames);
                renamer.performInplaceRefactoring(nameSuggestions);
            }
        });
    }

    private static void processMethodsDuplicates(PsiMethod method) {
        Project project = method.getProject();
        Callable<@Nullable MatchProvider> runnable = () -> {
            if (!method.isValid()) {
                return null;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            List<@Nullable Match> duplicates = MethodDuplicatesHandler.hasDuplicates((PsiElement)containingClass, (PsiMember)method);
            duplicates.removeIf(match -> PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)match.getMatchStart(), (boolean)false));
            return duplicates.isEmpty() ? null : MatchProvider.create((PsiMember)method, duplicates);
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.nonBlocking((Callable)runnable).finishOnUiThread(ModalityState.nonModal(), matchProvider -> MethodDuplicatesHandler.replaceDuplicate(project, ContainerUtil.createMaybeSingletonList((Object)matchProvider))).expireWhen(() -> !method.isValid()).submit((Executor)AppExecutorUtil.getAppExecutorService()), JavaRefactoringBundle.message((String)"replace.method.code.duplicates.title", (Object[])new Object[0]), true, project);
    }

    private static String getUniqueMethodName(PsiClass targetClass, PsiElementFactory elementFactory, PsiType functionalInterfaceType, String parameters) {
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        String initialMethodName = interfaceMethod != null ? interfaceMethod.getName() : "name";
        return UniqueNameGenerator.generateUniqueName((String)initialMethodName, methodName -> {
            String methodText = "private void " + methodName + parameters;
            PsiMethod patternMethod = elementFactory.createMethodFromText(methodText, (PsiElement)targetClass);
            return targetClass.findMethodBySignature(patternMethod, true) == null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/functional/ExtractToMethodReferenceIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/functional/ExtractToMethodReferenceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

