/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.gradle.toolingExtension.model.repositoryModel.FileRepositoryModel;
import com.intellij.gradle.toolingExtension.model.repositoryModel.ProjectRepositoriesModel;
import com.intellij.gradle.toolingExtension.model.repositoryModel.RepositoryModel;
import com.intellij.gradle.toolingExtension.model.repositoryModel.UrlRepositoryModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.repository.FileRepositoryData;
import com.intellij.openapi.externalSystem.model.project.repository.ProjectRepositoryData;
import com.intellij.openapi.externalSystem.model.project.repository.UrlRepositoryData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0012\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0005H\u0016J\u001e\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0006H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/ProjectRepositoriesResolver;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "<init>", "()V", "processedRepositories", "", "Lcom/intellij/gradle/toolingExtension/model/repositoryModel/RepositoryModel;", "populateModuleExtraModels", "", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "ideModule", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "getExtraProjectModelClasses", "Ljava/lang/Class;", "register", "ideProject", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "model", "Lcom/intellij/gradle/toolingExtension/model/repositoryModel/ProjectRepositoriesModel;", "toRepositoryData", "Lcom/intellij/openapi/externalSystem/model/project/repository/ProjectRepositoryData;", "toUrlRepositoryDataType", "Lcom/intellij/openapi/externalSystem/model/project/repository/UrlRepositoryData$Type;", "Lcom/intellij/gradle/toolingExtension/model/repositoryModel/UrlRepositoryModel$Type;", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nProjectRepositoriesResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectRepositoriesResolver.kt\norg/jetbrains/plugins/gradle/service/project/ProjectRepositoriesResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1586#2:73\n1661#2,3:74\n*S KotlinDebug\n*F\n+ 1 ProjectRepositoriesResolver.kt\norg/jetbrains/plugins/gradle/service/project/ProjectRepositoriesResolver\n*L\n42#1:73\n42#1:74,3\n*E\n"})
public final class ProjectRepositoriesResolver
extends AbstractProjectResolverExtension {
    @NotNull
    private final Set<RepositoryModel> processedRepositories;

    public ProjectRepositoriesResolver() {
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        this.processedRepositories = set;
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkNotNullParameter(ideModule, (String)"ideModule");
        ProjectRepositoriesModel projectRepositoriesModel = (ProjectRepositoriesModel)this.resolverCtx.getExtraProject(gradleModule, ProjectRepositoriesModel.class);
        if (projectRepositoriesModel != null) {
            ProjectRepositoriesModel model = projectRepositoriesModel;
            boolean bl = false;
            DataNode ideProject = ExternalSystemApiUtil.findParent(ideModule, (Key)ProjectKeys.PROJECT);
            if (ideProject != null) {
                this.register((DataNode<ProjectData>)ideProject, model);
            }
        }
        super.populateModuleExtraModels(gradleModule, ideModule);
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        return SetsKt.setOf(ProjectRepositoriesModel.class);
    }

    /*
     * WARNING - void declaration
     */
    private final void register(DataNode<ProjectData> ideProject, ProjectRepositoriesModel model) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection = ExternalSystemApiUtil.getChildren(ideProject, (Key)ProjectRepositoryData.KEY);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildren(...)");
        Iterable iterable = collection;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataNode dataNode = (DataNode)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((ProjectRepositoryData)it.getData());
        }
        Set registeredRepositories = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List list = model.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRepositories(...)");
        for (RepositoryModel repository : CollectionsKt.distinct((Iterable)list)) {
            if (this.processedRepositories.contains(repository)) continue;
            Intrinsics.checkNotNull((Object)repository);
            ProjectRepositoryData repositoryData = this.toRepositoryData(repository);
            if (registeredRepositories.contains(repositoryData)) continue;
            ideProject.addChild(new DataNode(ProjectRepositoryData.KEY, (Object)repositoryData, ideProject));
        }
    }

    private final ProjectRepositoryData toRepositoryData(RepositoryModel $this$toRepositoryData) {
        ProjectRepositoryData projectRepositoryData;
        RepositoryModel repositoryModel = $this$toRepositoryData;
        if (repositoryModel instanceof FileRepositoryModel) {
            projectRepositoryData = (ProjectRepositoryData)new FileRepositoryData(GradleConstants.SYSTEM_ID, ((FileRepositoryModel)$this$toRepositoryData).getName(), ((FileRepositoryModel)$this$toRepositoryData).getFiles());
        } else if (repositoryModel instanceof UrlRepositoryModel) {
            String string = ((UrlRepositoryModel)$this$toRepositoryData).getName();
            String string2 = ((UrlRepositoryModel)$this$toRepositoryData).getUrl();
            UrlRepositoryModel.Type type = ((UrlRepositoryModel)$this$toRepositoryData).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            projectRepositoryData = (ProjectRepositoryData)new UrlRepositoryData(GradleConstants.SYSTEM_ID, string, string2, this.toUrlRepositoryDataType(type));
        } else {
            projectRepositoryData = new ProjectRepositoryData(GradleConstants.SYSTEM_ID, $this$toRepositoryData.getName());
        }
        return projectRepositoryData;
    }

    private final UrlRepositoryData.Type toUrlRepositoryDataType(UrlRepositoryModel.Type $this$toUrlRepositoryDataType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toUrlRepositoryDataType.ordinal()]) {
            case 1 -> UrlRepositoryData.Type.MAVEN;
            case 2 -> UrlRepositoryData.Type.IVY;
            case 3 -> UrlRepositoryData.Type.OTHER;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UrlRepositoryModel.Type.values().length];
            try {
                nArray[UrlRepositoryModel.Type.MAVEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UrlRepositoryModel.Type.IVY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UrlRepositoryModel.Type.OTHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

