/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue.quickfix;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/issue/quickfix/GradleWrapperSettingsOpenQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "myProjectPath", "", "mySearch", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "Companion", "intellij.gradle"})
@ApiStatus.Experimental
public final class GradleWrapperSettingsOpenQuickFix
implements BuildIssueQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String myProjectPath;
    @Nullable
    private final String mySearch;
    @NotNull
    private final String id;

    public GradleWrapperSettingsOpenQuickFix(@NotNull String myProjectPath, @Nullable String mySearch) {
        Intrinsics.checkNotNullParameter((Object)myProjectPath, (String)"myProjectPath");
        this.myProjectPath = myProjectPath;
        this.mySearch = mySearch;
        this.id = "open_gradle_wrapper_settings";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Companion.showWrapperPropertiesFile(project, this.myProjectPath, this.mySearch);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/issue/quickfix/GradleWrapperSettingsOpenQuickFix$Companion;", "", "<init>", "()V", "showWrapperPropertiesFile", "", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "", "search", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public final void showWrapperPropertiesFile(@NotNull Project project, @NotNull String projectPath, @Nullable String search) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Path path = GradleUtil.findDefaultWrapperPropertiesFile(projectPath);
            if (path == null) {
                return;
            }
            Path wrapperPropertiesFile = path;
            OpenFileQuickFix.Companion.showFile(project, wrapperPropertiesFile, search);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

