/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.document.Metadata;
import ai.grazie.rules.en.EnglishMetadata;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;

class MissingDotRule
extends DocumentRule.PatternRule {
    private static final Metadata.Key<Boolean> key = new Metadata.Key<Boolean>(EnglishMetadata.missingDot){

        @Override
        protected void serialize(DataOutput out, Boolean value) {
        }

        @Override
        protected Boolean deserialize(DataInput in) {
            return true;
        }

        @Override
        protected int fingerprint() {
            return 0;
        }
    };
    static final MissingDotRule rule = new MissingDotRule();

    private MissingDotRule() {
        super("Punctuation.MISSING_DOT", "Missing dot", "Missing dot or other punctuation marks at the end of a declarative sentence.", null, () -> MissingDotRule.rulePattern(), new Example[0]);
    }

    @Override
    public MatchingResult checkDocument(List<DocumentSentence.Analyzed> sentences) {
        ArrayList<NodeRuleMatch> matches = new ArrayList<NodeRuleMatch>();
        boolean first = true;
        for (DocumentSentence.Analyzed sentence : sentences) {
            if (!sentence.intro.isEmpty()) {
                first = true;
            }
            if (!first && sentence.metadata.get(key) != null) {
                Node last = sentence.treeOrThrow().nodes().getLast();
                matches.add(new NodeRuleMatch((Rule)this, NodeMatch.EMPTY.withAnchor(last).withCorrector(NodeCorrector.insertAfter(last, ".")).withMessage("No punctuation mark at the end of the sentence?")));
            }
            first = false;
        }
        return MatchingResult.from(matches);
    }

    private static NodePattern rulePattern() {
        NodePattern questionLike = NodePattern.or(PunctuationRules.possiblyInformalQuestion, NodePattern.N.withDependent(".*", Questions.whPhrase), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.markAs("Subj")).withDependent("cop|aux|aux:pass", NodePattern.N.before("Subj")), NodePattern.N.withDependent("cop", CommonPatterns.firstChildPhrase).withDependent("det").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl|aux.*"));
        return NodePattern.ROOT.and(EnglishTreePatterns.clause).andNot(Questions.question).withPhraseEnd(NodePattern.not(CommonPatterns.skipBack(EnglishTreePatterns.aposOrQuote, NodePattern.PUNCT.noForm(".*\\?.*|[)\\]]")))).andOr(NodePattern.N.withPhraseEnd(NodePattern.N.form("\\?").includeIntoReport().directlyAfter(NodePattern.N.includeIntoReport()).correct(NodeCorrector.replace("."))).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl").andNot(questionLike).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyAfter(NodePattern.N.inPhrase(NodePattern.not(NodePattern.ROOT).and(Questions.possiblyQuestion))))).message("This sentence does not look like a question"), NodePattern.N.withPhraseEnd(NodePattern.not(CommonPatterns.skipBack(EnglishTreePatterns.aposOrQuote, NodePattern.N.form("[!?]")))).and((node, match) -> match.withMetadata(key, true)));
    }
}

