/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CodePoint;
import com.intellij.util.text.CodePointKt;
import com.intellij.util.text.UnicodeScript;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0007J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0005H\u0007J\u0017\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/util/text/NameUtilCore;", "", "<init>", "()V", "KANA_START", "", "KANA_END", "KANA2_START", "KANA2_END", "splitNameIntoWordList", "", "", "name", "splitNameIntoWords", "", "(Ljava/lang/String;)[Ljava/lang/String;", "nextWord", "text", "start", "isWordStart", "", "i", "maybeKana", "codePoint", "Lcom/intellij/util/text/CodePoint;", "maybeKana-KvIDaHs", "(I)Z", "isKanaBreak", "cur", "prev", "isKanaBreak-CAIacf4", "(II)Z", "nameToWords", "nameToWordList", "intellij.platform.util.base"})
@SourceDebugExtension(value={"SMAP\nNameUtilCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameUtilCore.kt\ncom/intellij/util/text/NameUtilCore\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,179:1\n37#2,2:180\n37#2,2:182\n*S KotlinDebug\n*F\n+ 1 NameUtilCore.kt\ncom/intellij/util/text/NameUtilCore\n*L\n45#1:180,2\n134#1:182,2\n*E\n"})
public final class NameUtilCore {
    @NotNull
    public static final NameUtilCore INSTANCE = new NameUtilCore();
    private static final int KANA_START = 12352;
    private static final int KANA_END = 13144;
    private static final int KANA2_START = 65382;
    private static final int KANA2_END = 65437;

    private NameUtilCore() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitNameIntoWordList(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        char[] cArray = new char[]{'_'};
        List underlineDelimited = StringsKt.split$default((CharSequence)name, cArray, false, 0, 6, null);
        List result = new ArrayList();
        for (String word : underlineDelimited) {
            int start = 0;
            while (start < word.length()) {
                int next = NameUtilCore.nextWord(word, start);
                String string = word.substring(start, next);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                result.add(string);
                start = next;
            }
        }
        return result;
    }

    @JvmStatic
    @Deprecated(message="use {@link #splitNameIntoWordList(String)} to avoid redundant allocations\n    <p>\n    Splits an identifier into words, separated with underscores or upper-case characters\n    (camel-case).\n   \n    ")
    @NotNull
    public static final String[] splitNameIntoWords(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Collection $this$toTypedArray$iv = NameUtilCore.splitNameIntoWordList(name);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @JvmStatic
    public static final int nextWord(@NotNull String text, int start) {
        int i;
        int codePoint;
        Intrinsics.checkNotNullParameter(text, "text");
        int ch = CodePointKt.codePointAt(text, start);
        int chLen = CodePoint.getCharCount-impl(ch);
        if (!CodePoint.isLetterOrDigit-impl(ch)) {
            return start + chLen;
        }
        for (i = start; i < text.length() && CodePoint.isDigit-impl(codePoint = CodePointKt.codePointAt(text, i)); i += CodePoint.getCharCount-impl(codePoint)) {
        }
        if (i > start) {
            return i;
        }
        while (i < text.length() && CodePoint.isUpperCase-impl(codePoint = CodePointKt.codePointAt(text, i))) {
            i += CodePoint.getCharCount-impl(codePoint);
        }
        if (i > start + chLen) {
            if (i == text.length() || !CodePoint.isLetter-impl(CodePointKt.codePointAt(text, i))) {
                return i;
            }
            return i - CodePoint.getCharCount-impl(CodePointKt.codePointBefore(text, i));
        }
        if (i == start) {
            i += chLen;
        }
        while (i < text.length() && CodePoint.isLetter-impl(codePoint = CodePointKt.codePointAt(text, i)) && !NameUtilCore.isWordStart(text, i)) {
            i += CodePoint.getCharCount-impl(codePoint);
        }
        return i;
    }

    @JvmStatic
    public static final boolean isWordStart(@NotNull String text, int i) {
        CodePoint prev;
        Intrinsics.checkNotNullParameter(text, "text");
        int cur = CodePointKt.codePointAt(text, i);
        CodePoint codePoint = prev = i > 0 ? CodePoint.box-impl(CodePointKt.codePointBefore(text, i)) : null;
        if (CodePoint.isUpperCase-impl(cur)) {
            if (prev != null && CodePoint.isUpperCase-impl(prev.unbox-impl())) {
                int nextPos = i + CodePoint.getCharCount-impl(cur);
                return nextPos < text.length() && CodePoint.isLowerCase-impl(CodePointKt.codePointAt(text, nextPos));
            }
            return true;
        }
        if (CodePoint.isDigit-impl(cur)) {
            return true;
        }
        if (!CodePoint.isLetter-impl(cur)) {
            return false;
        }
        if (CodePoint.isIdeographic-impl(cur)) {
            return true;
        }
        return i == 0 || !Character.isLetterOrDigit(text.charAt(i - 1)) || prev != null && INSTANCE.isKanaBreak-CAIacf4(cur, prev.unbox-impl());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean maybeKana-KvIDaHs(int codePoint) {
        boolean bl;
        int n = codePoint;
        if (12352 <= n) {
            if (n < 13145) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        n = codePoint;
        if (65382 > n) return false;
        if (n >= 65438) return false;
        return true;
    }

    private final boolean isKanaBreak-CAIacf4(int cur, int prev) {
        if (!this.maybeKana-KvIDaHs(cur) && !this.maybeKana-KvIDaHs(prev)) {
            return false;
        }
        UnicodeScript curScript = CodePoint.getUnicodeScript-impl(cur);
        UnicodeScript prevScript = CodePoint.getUnicodeScript-impl(prev);
        if (prevScript == curScript) {
            return false;
        }
        return (curScript == UnicodeScript.KATAKANA || curScript == UnicodeScript.HIRAGANA || prevScript == UnicodeScript.KATAKANA || prevScript == UnicodeScript.HIRAGANA) && prevScript != UnicodeScript.COMMON && curScript != UnicodeScript.COMMON;
    }

    @JvmStatic
    @Deprecated(message="use {@link #nameToWordList(String)} to avoid redundant allocations")
    @NotNull
    public static final String[] nameToWords(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Collection $this$toTypedArray$iv = NameUtilCore.nameToWordList(name);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @JvmStatic
    @NotNull
    public static final List<String> nameToWordList(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        List array = new ArrayList();
        int index = 0;
        while (index < name.length()) {
            CharSequence word;
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            if (!(!StringsKt.isBlank(word = name.subSequence(wordStart, index)))) continue;
            array.add(((Object)word).toString());
        }
        return array;
    }
}

