/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.lombok.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.lombok.config.AccessLevel;
import org.jetbrains.kotlin.lombok.config.AccessLevelUtilsKt;
import org.jetbrains.kotlin.lombok.utils.UtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;

@Metadata(mv={2, 4, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a)\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007b\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\b\u00a2\u0006\u0002\b\b\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0005*\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005\u001a\u001a\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e*\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005\u001a\u0014\u0010\u000f\u001a\u00020\u00052\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0005*\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005\u001a\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"getVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "field", "", "getAccessLevel", "Lorg/jetbrains/kotlin/lombok/config/AccessLevel;", "getAccessLevelWithReceiver", "Lkotlin/jvm/JvmName;", "name", "getStringArgument", "argumentName", "getStringArrayArgument", "", "extractString", "argument", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "getNonBlankStringArgument", "getBooleanArgument", "", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;Ljava/lang/String;)Ljava/lang/Boolean;", "kotlin-lombok-compiler-plugin.k1"})
@SourceDebugExtension(value={"SMAP\nannotationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 annotationUtils.kt\norg/jetbrains/kotlin/lombok/utils/AnnotationUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1586#2:61\n1661#2,3:62\n*S KotlinDebug\n*F\n+ 1 annotationUtils.kt\norg/jetbrains/kotlin/lombok/utils/AnnotationUtilsKt\n*L\n38#1:61\n38#1:62,3\n*E\n"})
public final class AnnotationUtilsKt {
    @NotNull
    public static final DescriptorVisibility getVisibility(@NotNull AnnotationDescriptor annotation, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return AccessLevelUtilsKt.toDescriptorVisibility(AnnotationUtilsKt.getAccessLevel(annotation, field));
    }

    public static /* synthetic */ DescriptorVisibility getVisibility$default(AnnotationDescriptor annotationDescriptor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "value";
        }
        return AnnotationUtilsKt.getVisibility(annotationDescriptor, string);
    }

    @NotNull
    public static final AccessLevel getAccessLevel(@NotNull AnnotationDescriptor annotation, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String string = AnnotationUtilsKt.getStringArgument(annotation, field);
        if (string == null) {
            return AccessLevel.PUBLIC;
        }
        String value = string;
        return AccessLevel.valueOf(value);
    }

    public static /* synthetic */ AccessLevel getAccessLevel$default(AnnotationDescriptor annotationDescriptor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "value";
        }
        return AnnotationUtilsKt.getAccessLevel(annotationDescriptor, string);
    }

    @JvmName(name="getAccessLevelWithReceiver")
    @NotNull
    public static final AccessLevel getAccessLevelWithReceiver(@NotNull AnnotationDescriptor $this$getAccessLevel, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)$this$getAccessLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return AnnotationUtilsKt.getAccessLevel($this$getAccessLevel, field);
    }

    public static /* synthetic */ AccessLevel getAccessLevelWithReceiver$default(AnnotationDescriptor annotationDescriptor, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "value";
        }
        return AnnotationUtilsKt.getAccessLevelWithReceiver(annotationDescriptor, string);
    }

    @Nullable
    public static final String getStringArgument(@NotNull AnnotationDescriptor $this$getStringArgument, @NotNull String argumentName) {
        Intrinsics.checkNotNullParameter((Object)$this$getStringArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        ConstantValue constantValue = (ConstantValue)$this$getStringArgument.getAllValueArguments().get(Name.identifier((String)argumentName));
        if (constantValue == null) {
            return null;
        }
        ConstantValue argument = constantValue;
        return AnnotationUtilsKt.extractString(argument);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> getStringArrayArgument(@NotNull AnnotationDescriptor $this$getStringArrayArgument, @NotNull String argumentName) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$getStringArrayArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        ConstantValue argument = (ConstantValue)$this$getStringArrayArgument.getAllValueArguments().get(Name.identifier((String)argumentName));
        if (argument == null) {
            list = null;
        } else if (argument instanceof ArrayValue) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)((ArrayValue)argument).getValue();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                ConstantValue constantValue = (ConstantValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(AnnotationUtilsKt.extractString(p0));
            }
            list = (List)destination$iv$iv;
        } else {
            throw new RuntimeException("Argument should be ArrayValue, got " + argument);
        }
        return list;
    }

    private static final String extractString(ConstantValue<?> argument) {
        String string;
        ConstantValue<?> constantValue = argument;
        if (constantValue instanceof EnumValue) {
            string = ((EnumValue)argument).getEnumEntryName().getIdentifier();
        } else if (constantValue instanceof StringValue) {
            string = (String)((StringValue)argument).getValue();
        } else {
            throw new RuntimeException("Argument " + argument + " is not supported");
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    @Nullable
    public static final String getNonBlankStringArgument(@NotNull AnnotationDescriptor $this$getNonBlankStringArgument, @NotNull String argumentName) {
        Intrinsics.checkNotNullParameter((Object)$this$getNonBlankStringArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        return UtilsKt.trimToNull(AnnotationUtilsKt.getStringArgument($this$getNonBlankStringArgument, argumentName));
    }

    @Nullable
    public static final Boolean getBooleanArgument(@NotNull AnnotationDescriptor $this$getBooleanArgument, @NotNull String argumentName) {
        Intrinsics.checkNotNullParameter((Object)$this$getBooleanArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        ConstantValue constantValue = (ConstantValue)$this$getBooleanArgument.getAllValueArguments().get(Name.identifier((String)argumentName));
        if (constantValue == null) {
            return null;
        }
        ConstantValue argument = constantValue;
        if (!(argument instanceof BooleanValue)) {
            throw new RuntimeException("Argument " + argument + " is not supported for Boolean value");
        }
        return (Boolean)((BooleanValue)argument).getValue();
    }
}

