/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.streams.core.StreamDebuggerBundle;
import com.intellij.debugger.streams.core.trace.GenericEvaluationContext;
import com.intellij.debugger.streams.core.trace.XValueInterpreter;
import com.intellij.debugger.streams.trace.impl.JavaEvaluationContext;
import com.intellij.debugger.streams.trace.impl.JvmArrayReference;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValue;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/debugger/streams/trace/impl/JavaValueInterpreter;", "Lcom/intellij/debugger/streams/core/trace/XValueInterpreter;", "<init>", "()V", "extract", "Lcom/intellij/debugger/streams/core/trace/XValueInterpreter$Result;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "result", "Lcom/intellij/xdebugger/frame/XValue;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/xdebugger/frame/XValue;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasInnerExceptions", "", "resultArray", "Lcom/sun/jdi/ArrayReference;", "intellij.java.debugger.streams"})
public final class JavaValueInterpreter
implements XValueInterpreter {
    @Nullable
    public Object extract(@NotNull XDebugSession session, @NotNull XValue result, @NotNull Continuation<? super XValueInterpreter.Result> $completion) {
        if (result instanceof JavaValue) {
            Value reference = ((JavaValue)result).getDescriptor().getValue();
            if (reference instanceof ArrayReference) {
                com.intellij.debugger.streams.core.trace.ArrayReference arrayReference = new JvmArrayReference((ArrayReference)reference);
                boolean bl = this.hasInnerExceptions((ArrayReference)reference);
                EvaluationContextImpl evaluationContextImpl = ((JavaValue)result).getEvaluationContext();
                Intrinsics.checkNotNullExpressionValue((Object)evaluationContextImpl, (String)"getEvaluationContext(...)");
                return new XValueInterpreter.Result.Array(arrayReference, bl, (GenericEvaluationContext)new JavaEvaluationContext(evaluationContextImpl));
            }
            if (reference instanceof ObjectReference) {
                ClassType classType;
                ReferenceType type = ((ObjectReference)reference).referenceType();
                ClassType classType2 = classType = type instanceof ClassType ? (ClassType)type : null;
                if (classType != null) {
                    while (classType != null && !Intrinsics.areEqual((Object)"java.lang.Throwable", (Object)classType.name())) {
                        classType = classType.superclass();
                    }
                    if (classType != null) {
                        String string;
                        String exceptionMessage = DebuggerUtils.tryExtractExceptionMessage((ObjectReference)((ObjectReference)reference));
                        if (exceptionMessage == null) {
                            var10_8 = new Object[]{type.name()};
                            string = StreamDebuggerBundle.message((String)"stream.debugger.evaluation.failed.with.exception", (Object[])var10_8);
                        } else {
                            var10_8 = new Object[]{type.name(), exceptionMessage};
                            string = StreamDebuggerBundle.message((String)"stream.debugger.evaluation.failed.with.exception.and.message", (Object[])var10_8);
                        }
                        String string2 = string;
                        Intrinsics.checkNotNull((Object)string2);
                        String descriptionWithReason = string2;
                        return new XValueInterpreter.Result.Error(descriptionWithReason);
                    }
                }
            }
        }
        return XValueInterpreter.Result.Unknown.INSTANCE;
    }

    private final boolean hasInnerExceptions(ArrayReference resultArray) {
        Value value = resultArray.getValue(1);
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.sun.jdi.ArrayReference");
        ArrayReference result = (ArrayReference)value;
        ReferenceType referenceType = result.referenceType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"referenceType(...)");
        ReferenceType type = referenceType;
        if (type instanceof ArrayType) {
            String string = ((ArrayType)type).componentTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"componentTypeName(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Throwable", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        return false;
    }
}

