/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;

public class AddSteppingFilterAction
extends DebuggerAction {
    public void actionPerformed(final @NotNull AnActionEvent e) {
        DebuggerContextImpl debuggerContext;
        DebugProcessImpl process;
        if (e == null) {
            AddSteppingFilterAction.$$$reportNull$$$0(0);
        }
        if ((process = (debuggerContext = AddSteppingFilterAction.getDebuggerContext(e.getDataContext())).getDebugProcess()) == null) {
            return;
        }
        final StackFrameProxyImpl proxy = AddSteppingFilterAction.getStackFrameProxy(e);
        DebuggerManagerThreadImpl managerThread = debuggerContext.getManagerThread();
        if (managerThread == null) {
            return;
        }
        managerThread.schedule(new DebuggerCommandImpl(this){

            @Override
            protected void action() {
                String name = AddSteppingFilterAction.getClassName(proxy != null ? proxy : debuggerContext.getFrameProxy());
                if (name == null) {
                    return;
                }
                Project project = (Project)e.getData(CommonDataKeys.PROJECT);
                ApplicationManager.getApplication().invokeLater(() -> {
                    String filter = Messages.showInputDialog((Project)project, (String)"", (String)JavaDebuggerBundle.message((String)"add.stepping.filter", (Object[])new Object[0]), null, (String)name, null);
                    if (filter != null) {
                        ClassFilter[] newFilters = (ClassFilter[])ArrayUtil.append((Object[])DebuggerSettings.getInstance().getSteppingFilters(), (Object)new ClassFilter(filter));
                        DebuggerSettings.getInstance().setSteppingFilters(newFilters);
                    }
                });
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddSteppingFilterAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(AddSteppingFilterAction.getStackFrameProxy(e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            AddSteppingFilterAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static String getClassName(StackFrameProxyImpl stackFrameProxy) {
        if (stackFrameProxy != null) {
            try {
                ReferenceType type;
                Location location = stackFrameProxy.location();
                if (location != null && (type = location.declaringType()) != null) {
                    return type.name();
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/actions/AddSteppingFilterAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/actions/AddSteppingFilterAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

