/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J(\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007R$\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/debugger/actions/JvmSmartStepIntoErrorReporter;", "", "<init>", "()V", "enabled", "", "getEnabled$annotations", "getEnabled", "()Z", "setEnabled", "(Z)V", "report", "", "expression", "Lcom/intellij/psi/PsiElement;", "session", "Lcom/intellij/debugger/impl/DebuggerSession;", "position", "Lcom/intellij/debugger/SourcePosition;", "message", "", "reportInternal", "joinTargetInfo", "targets", "", "Lcom/intellij/debugger/actions/SmartStepTarget;", "intellij.java.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJvmSmartStepIntoErrorReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSmartStepIntoErrorReporter.kt\ncom/intellij/debugger/actions/JvmSmartStepIntoErrorReporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,72:1\n1#2:73\n23#3:74\n37#4,2:75\n*S KotlinDebug\n*F\n+ 1 JvmSmartStepIntoErrorReporter.kt\ncom/intellij/debugger/actions/JvmSmartStepIntoErrorReporter\n*L\n63#1:74\n64#1:75,2\n*E\n"})
public final class JvmSmartStepIntoErrorReporter {
    @NotNull
    public static final JvmSmartStepIntoErrorReporter INSTANCE = new JvmSmartStepIntoErrorReporter();
    @TestOnly
    private static boolean enabled = true;

    private JvmSmartStepIntoErrorReporter() {
    }

    public static final boolean getEnabled() {
        return enabled;
    }

    public static final void setEnabled(boolean bl) {
        enabled = bl;
    }

    @JvmStatic
    public static /* synthetic */ void getEnabled$annotations() {
    }

    @JvmStatic
    public static final void report(@NotNull PsiElement expression, @Nullable DebuggerSession session, @NotNull SourcePosition position, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!enabled) {
            return;
        }
        if (ApplicationManager.getApplication().isInternal() && session != null) {
            INSTANCE.reportInternal(expression, session, position, message);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportInternal(PsiElement expression, DebuggerSession session, SourcePosition position, String message) {
        void $this$reportInternal_u24lambda_u241_u243;
        Attachment $this$reportInternal_u24lambda_u241_u241;
        Attachment $this$reportInternal_u24lambda_u241_u240;
        Attachment attachment;
        Attachment[] attachmentArray;
        Object object = session.getContextManager().getContext().getThreadProxy();
        String stackTrace = object != null && (object = ((ThreadReferenceProxyImpl)object).frames()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, JvmSmartStepIntoErrorReporter::reportInternal$lambda$0, (int)30, null) : null;
        String path = position.getFile().getVirtualFile().getCanonicalPath();
        String context = StringsKt.trimIndent((String)("\n        File path = " + path + "\n        Project name = " + session.getProject().getName() + "\n    "));
        Attachment[] $this$reportInternal_u24lambda_u241 = attachmentArray = CollectionsKt.createListBuilder();
        boolean bl = false;
        Attachment attachment2 = attachment = new Attachment("context.txt", context);
        Attachment[] attachmentArray2 = $this$reportInternal_u24lambda_u241;
        boolean bl2 = false;
        $this$reportInternal_u24lambda_u241_u240.setIncluded(true);
        attachmentArray2.add(attachment);
        if (stackTrace != null) {
            $this$reportInternal_u24lambda_u241_u240 = attachment = new Attachment("stacktrace.txt", stackTrace);
            attachmentArray2 = $this$reportInternal_u24lambda_u241;
            boolean bl3 = false;
            $this$reportInternal_u24lambda_u241_u241.setIncluded(true);
            attachmentArray2.add(attachment);
        }
        $this$reportInternal_u24lambda_u241_u241 = attachment = new Attachment("expression.txt", (String)ActionsKt.runReadAction(() -> JvmSmartStepIntoErrorReporter.reportInternal$lambda$1$2(expression)));
        attachmentArray2 = $this$reportInternal_u24lambda_u241;
        boolean bl4 = false;
        $this$reportInternal_u24lambda_u241_u243.setIncluded(true);
        attachmentArray2.add(attachment);
        List attachments = CollectionsKt.build((List)attachmentArray);
        JvmSmartStepIntoErrorReporter $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JvmSmartStepIntoErrorReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Collection $this$toTypedArray$iv = attachments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        attachmentArray = thisCollection$iv.toArray(new Attachment[0]);
        logger.error("Failed to locate targets in bytecode. Details in attachments.", (Throwable)new RuntimeExceptionWithAttachments(message, Arrays.copyOf(attachmentArray, attachmentArray.length)));
    }

    @JvmStatic
    @NotNull
    public static final String joinTargetInfo(@NotNull List<? extends SmartStepTarget> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        return CollectionsKt.joinToString$default((Iterable)targets, null, null, null, (int)0, null, JvmSmartStepIntoErrorReporter::joinTargetInfo$lambda$0, (int)31, null);
    }

    private static final String reportInternal$lambda$1$2(PsiElement $expression) {
        return $expression.getText();
    }

    private static final CharSequence reportInternal$lambda$0(StackFrameProxyImpl it) {
        Location location = it.location();
        Method method = DebuggerUtilsEx.getMethod(location);
        int lineNumber = DebuggerUtilsEx.getLineNumber(location, false);
        String sourceName = DebuggerUtilsEx.getSourceName(location, null);
        return method + " at " + sourceName + ":" + lineNumber;
    }

    private static final CharSequence joinTargetInfo$lambda$0(SmartStepTarget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentation(...)");
        return string;
    }
}

