/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.ResumeAllJavaThreadsActionHandler;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/debugger/actions/ResumeAllJavaThreadsActionHandler;", "Lcom/intellij/xdebugger/impl/actions/DebuggerActionHandler;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "<init>", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "perform", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.java.debugger.impl"})
public final class ResumeAllJavaThreadsActionHandler
extends DebuggerActionHandler {
    @NotNull
    private final DebugProcessImpl debugProcess;

    public ResumeAllJavaThreadsActionHandler(@NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
        this.debugProcess = debugProcess;
    }

    @NotNull
    public final DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    public void perform(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JavaDebugProcess javaDebugProcess = this.debugProcess.getXdebugProcess();
        if (javaDebugProcess == null) {
            return;
        }
        JavaDebugProcess xdebugProcess = javaDebugProcess;
        this.debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(this, xdebugProcess){
            final /* synthetic */ ResumeAllJavaThreadsActionHandler this$0;
            final /* synthetic */ JavaDebugProcess $xdebugProcess;
            {
                this.this$0 = $receiver;
                this.$xdebugProcess = $xdebugProcess;
                super(null, 1, null);
            }

            protected void action() {
                List<SuspendContextImpl> list = this.this$0.getDebugProcess().getSuspendManager().getPausedContexts();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getPausedContexts(...)");
                List<SuspendContextImpl> contexts = list;
                for (SuspendContextImpl context : contexts) {
                    if (context.isResumed()) continue;
                    this.this$0.getDebugProcess().getSuspendManager().resume(context);
                }
                DebuggerUIUtil.invokeLater(() -> perform.1.action$lambda$0(this.$xdebugProcess));
            }

            private static final void action$lambda$0(JavaDebugProcess $xdebugProcess) {
                $xdebugProcess.getSession().resume();
            }
        });
    }

    public boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return !this.debugProcess.getSuspendManager().getPausedContexts().isEmpty();
    }
}

