/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.statistics.DebuggerStatistics;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"sessionStartTimestampKey", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "initializeOverheadListener", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "onOverheadDetected", "intellij.java.debugger.impl"})
public final class AsyncStackTracesOverheadUtilsKt {
    @NotNull
    private static final Key<Long> sessionStartTimestampKey;

    public static final void initializeOverheadListener(@NotNull DebugProcessImpl process) {
        Intrinsics.checkNotNullParameter((Object)((Object)process), (String)"process");
        long startNs = System.nanoTime();
        process.putUserData(sessionStartTimestampKey, startNs);
    }

    public static final void onOverheadDetected(@NotNull DebugProcessImpl process) {
        long l;
        Intrinsics.checkNotNullParameter((Object)((Object)process), (String)"process");
        Project project = process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Long sessionStartNs = (Long)process.getUserData(sessionStartTimestampKey);
        if (sessionStartNs != null) {
            long durationNs = System.nanoTime() - sessionStartNs;
            l = TimeUnit.NANOSECONDS.toMillis(durationNs);
        } else {
            l = -1L;
        }
        long sessionLengthMs = l;
        DebuggerStatistics.INSTANCE.logAgentOverheadDetected(project2, sessionLengthMs);
    }

    static {
        Key key = Key.create((String)"debuggerSessionStartTimestamp");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        sessionStartTimestampKey = key;
    }
}

