/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.StepIntoMethodBreakpoint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Range;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicStepMethodFilter
implements NamedMethodFilter {
    private static final Logger LOG = Logger.getInstance(BasicStepMethodFilter.class);
    private static final String PROXY_CALL_SIGNATURE_POSTFIX = "Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;";
    @NotNull
    protected final JVMName myDeclaringClassName;
    @NotNull
    private final String myTargetMethodName;
    @Nullable
    protected final JVMName myTargetMethodSignature;
    private final Range<Integer> myCallingExpressionLines;
    private final int myOrdinal;
    private final boolean myCheckCaller;

    public BasicStepMethodFilter(@NotNull PsiMethod psiMethod, Range<Integer> callingExpressionLines) {
        if (psiMethod == null) {
            BasicStepMethodFilter.$$$reportNull$$$0(0);
        }
        this(psiMethod, 0, callingExpressionLines);
    }

    public BasicStepMethodFilter(@NotNull PsiMethod psiMethod, int ordinal, Range<Integer> callingExpressionLines) {
        if (psiMethod == null) {
            BasicStepMethodFilter.$$$reportNull$$$0(1);
        }
        this(JVMNameUtil.getJVMQualifiedName(psiMethod.getContainingClass()), JVMNameUtil.getJVMMethodName(psiMethod), JVMNameUtil.getJVMSignature(psiMethod), ordinal, callingExpressionLines, BasicStepMethodFilter.checkCaller(psiMethod));
    }

    protected BasicStepMethodFilter(@NotNull JVMName declaringClassName, @NotNull String targetMethodName, @Nullable JVMName targetMethodSignature, int ordinal, Range<Integer> callingExpressionLines, boolean checkCaller) {
        if (declaringClassName == null) {
            BasicStepMethodFilter.$$$reportNull$$$0(2);
        }
        if (targetMethodName == null) {
            BasicStepMethodFilter.$$$reportNull$$$0(3);
        }
        this.myDeclaringClassName = declaringClassName;
        this.myTargetMethodName = targetMethodName;
        this.myTargetMethodSignature = targetMethodSignature;
        this.myCallingExpressionLines = callingExpressionLines;
        this.myOrdinal = ordinal;
        this.myCheckCaller = checkCaller;
    }

    private static boolean checkCaller(PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        return aClass != null && aClass.hasAnnotation("java.lang.FunctionalInterface");
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.myTargetMethodName;
        if (string == null) {
            BasicStepMethodFilter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process, Location location) throws EvaluateException {
        return this.locationMatches(process, location, null, false);
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process, Location location, @Nullable StackFrameProxyImpl frameProxy) throws EvaluateException {
        return this.locationMatches(process, location, frameProxy, false);
    }

    private boolean locationMatches(DebugProcessImpl process, Location location, @Nullable StackFrameProxyImpl stackFrame, boolean caller) throws EvaluateException {
        ObjectReference thisObject;
        Method method = location.method();
        String name = method.name();
        if (!this.myTargetMethodName.equals(name)) {
            if (this.isLambdaCall(process, name, location)) {
                return true;
            }
            if (!caller && this.myCheckCaller) {
                int index = stackFrame.getFrameIndex();
                StackFrameProxyImpl callerFrame = stackFrame.threadProxy().frame(index + 1);
                if (callerFrame != null) {
                    return this.locationMatches(process, callerFrame.location(), callerFrame, true);
                }
            }
            return false;
        }
        if (this.myTargetMethodSignature != null && !BasicStepMethodFilter.signatureMatches(method, this.myTargetMethodSignature.getName(process))) {
            return false;
        }
        if (!caller && RequestHint.isProxyMethod(method)) {
            return false;
        }
        String declaringClassNameName = this.myDeclaringClassName.getName(process);
        boolean res = DebuggerUtils.instanceOf((Type)location.declaringType(), (String)declaringClassNameName);
        if (!res && !method.isStatic() && stackFrame != null && (thisObject = stackFrame.thisObject()) != null) {
            res = DebuggerUtils.instanceOf((Type)thisObject.referenceType(), (String)declaringClassNameName);
        }
        return res;
    }

    private boolean isLambdaCall(DebugProcessImpl process, String name, Location location) {
        if (DebuggerUtilsEx.isLambdaName(name)) {
            SourcePosition position = process.getPositionManager().getSourcePosition(location);
            return (Boolean)ReadAction.compute(() -> {
                PsiElement psiMethod = DebuggerUtilsEx.getContainingMethod(position);
                if (psiMethod instanceof PsiLambdaExpression) {
                    PsiType type = ((PsiLambdaExpression)psiMethod).getFunctionalInterfaceType();
                    PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
                    if (type != null && interfaceMethod != null && this.myTargetMethodName.equals(interfaceMethod.getName())) {
                        try {
                            return InheritanceUtil.isInheritor((PsiType)type, (String)this.myDeclaringClassName.getName(process).replace('$', '.'));
                        }
                        catch (EvaluateException e) {
                            LOG.info((Throwable)e);
                        }
                    }
                }
                return false;
            });
        }
        return false;
    }

    public boolean proxyCheck(Location location, SuspendContextImpl context, RequestHint hint) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (this.isProxyCall(debugProcess, location.method(), context.getFrameProxy())) {
            if (!DebugProcessImpl.isPositionFiltered(location)) {
                return true;
            }
            try {
                StepIntoMethodBreakpoint breakpoint = new StepIntoMethodBreakpoint(this.myDeclaringClassName.getName(debugProcess), this.myTargetMethodName, this.myTargetMethodSignature != null ? this.myTargetMethodSignature.getName(debugProcess) : null, debugProcess.getProject());
                DebugProcessImpl.prepareAndSetSteppingBreakpoint(context, breakpoint, hint, false);
            }
            catch (EvaluateException e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    private boolean isProxyCall(DebugProcessImpl process, Method method, @Nullable StackFrameProxyImpl stackFrame) {
        try {
            String signature = method.signature();
            if (stackFrame != null && signature != null && signature.endsWith(PROXY_CALL_SIGNATURE_POSTFIX)) {
                Value methodValue;
                Type proxyType;
                Value proxyValue;
                List<Value> argumentValues;
                int size;
                ReferenceType type;
                String methodName = method.name();
                boolean match = false;
                if ("invoke".equals(methodName) && (type = method.declaringType()) instanceof ClassType && ((ClassType)type).interfaces().stream().map(ReferenceType::name).anyMatch("java.lang.reflect.InvocationHandler"::equals)) {
                    match = true;
                }
                if (DebuggerUtilsEx.isLambdaName(methodName)) {
                    match = true;
                } else {
                    ObjectReference thisObject = stackFrame.thisObject();
                    if (thisObject != null && StringUtil.containsIgnoreCase((String)thisObject.referenceType().name(), (String)"CGLIB")) {
                        match = true;
                    }
                }
                if (match && (size = (argumentValues = stackFrame.getArgumentValues()).size()) >= 3 && (proxyValue = argumentValues.get(size - 3)) != null && (proxyType = proxyValue.type()) instanceof ReferenceType && DebuggerUtils.instanceOf((Type)proxyType, (String)this.myDeclaringClassName.getName(process)) && (methodValue = argumentValues.get(size - 2)) instanceof ObjectReference) {
                    ReferenceType methodType = ((ObjectReference)methodValue).referenceType();
                    return this.myTargetMethodName.equals(((StringReference)((ObjectReference)methodValue).getValue(DebuggerUtils.findField((ReferenceType)methodType, (String)"name"))).value());
                }
            }
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
        }
        return false;
    }

    private static boolean signatureMatches(Method method, String expectedSignature) throws EvaluateException {
        if (expectedSignature.equals(method.signature())) {
            return true;
        }
        for (Method candidate : method.declaringType().methodsByName(method.name())) {
            if (candidate == method || !candidate.isBridge() || !expectedSignature.equals(candidate.signature())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }

    @Override
    public int getSkipCount() {
        return this.myOrdinal;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{myDeclaringClassName=" + String.valueOf(this.myDeclaringClassName) + ", myTargetMethodName='" + this.myTargetMethodName + "', myTargetMethodSignature=" + String.valueOf(this.myTargetMethodSignature) + ", myCallingExpressionLines=" + String.valueOf(this.myCallingExpressionLines) + ", myOrdinal=" + this.myOrdinal + ", myCheckCaller=" + this.myCheckCaller + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringClassName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethodName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/BasicStepMethodFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/BasicStepMethodFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

