/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.RealThreadInfo;
import com.intellij.debugger.engine.SteppingAction;
import com.intellij.debugger.engine.SteppingListener;
import com.intellij.debugger.engine.SteppingProgressTracker;
import com.intellij.debugger.engine.SteppingProgressTrackerKt;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ThreadReference;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/debugger/engine/CancelingSteppingListener;", "Lcom/intellij/debugger/engine/SteppingListener;", "<init>", "()V", "beforeSteppingStarted", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "steppingAction", "Lcom/intellij/debugger/engine/SteppingAction;", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nSteppingProgressTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SteppingProgressTracker.kt\ncom/intellij/debugger/engine/CancelingSteppingListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class CancelingSteppingListener
implements SteppingListener {
    @Override
    public void beforeSteppingStarted(@NotNull SuspendContextImpl suspendContext, @NotNull SteppingAction steppingAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)suspendContext), (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)((Object)steppingAction), (String)"steppingAction");
        DebugProcessImpl debuggerProcessImpl = suspendContext.getDebugProcess();
        LightOrRealThreadInfo filter = debuggerProcessImpl.getRequestsManager().getFilterThread();
        boolean isSuspendAllPolicy = Intrinsics.areEqual((Object)suspendContext.getSuspendPolicyFromRequestors(), (Object)"SuspendAll");
        ThreadReferenceProxyImpl threadForStepping = filter != null ? suspendContext.getVirtualMachineProxy().getThreadReferenceProxy(filter.getRealThread()) : suspendContext.getThread();
        boolean needSuspendOnlyThread = suspendContext.getSuspendPolicy() == 1 && threadForStepping != null;
        String steppingName = SteppingProgressTrackerKt.access$getSteppingName(steppingAction);
        CompletableDeferred stepCompetedStatus = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        DebuggerManagerThreadImpl managerThread = suspendContext.getManagerThread();
        managerThread.schedule(PrioritizedTask.Priority.NORMAL, () -> CancelingSteppingListener.beforeSteppingStarted$lambda$0(threadForStepping, filter, debuggerProcessImpl, steppingAction, managerThread, steppingName, stepCompetedStatus, needSuspendOnlyThread));
        LightOrRealThreadInfo lightOrRealThreadInfo = filter;
        if (lightOrRealThreadInfo == null) {
            RealThreadInfo realThreadInfo;
            ThreadReferenceProxyImpl threadReferenceProxyImpl = threadForStepping;
            if (threadReferenceProxyImpl != null) {
                ThreadReferenceProxyImpl it = threadReferenceProxyImpl;
                boolean bl = false;
                ThreadReference threadReference = it.getThreadReference();
                Intrinsics.checkNotNullExpressionValue((Object)threadReference, (String)"getThreadReference(...)");
                realThreadInfo = new RealThreadInfo(threadReference);
            } else {
                realThreadInfo = null;
            }
            lightOrRealThreadInfo = realThreadInfo;
        }
        LightOrRealThreadInfo adjustedFilter = lightOrRealThreadInfo;
        SteppingProgressTracker tracker = suspendContext.getDebugProcess().mySteppingProgressTracker;
        tracker.addStepping((CompletableDeferred<Unit>)stepCompetedStatus, isSuspendAllPolicy, adjustedFilter);
    }

    private static final Unit beforeSteppingStarted$lambda$0$2$0(boolean $needSuspendOnlyThread, DebugProcessImpl $debuggerProcessImpl, ThreadReferenceProxyImpl $threadForStepping, DebuggerManagerThreadImpl $managerThread) {
        DebuggerCommandImpl debuggerCommandImpl;
        if ($needSuspendOnlyThread) {
            DebuggerCommandImpl debuggerCommandImpl2 = $debuggerProcessImpl.createFreezeThreadCommand($threadForStepping);
            debuggerCommandImpl = debuggerCommandImpl2;
            Intrinsics.checkNotNullExpressionValue((Object)debuggerCommandImpl2, (String)"createFreezeThreadCommand(...)");
        } else {
            DebuggerCommandImpl debuggerCommandImpl3 = $debuggerProcessImpl.createPauseCommand($threadForStepping);
            debuggerCommandImpl = debuggerCommandImpl3;
            Intrinsics.checkNotNullExpressionValue((Object)debuggerCommandImpl3, (String)"createPauseCommand(...)");
        }
        DebuggerCommandImpl command2 = debuggerCommandImpl;
        $managerThread.schedule(command2);
        return Unit.INSTANCE;
    }

    private static final String beforeSteppingStarted$lambda$0$0(String name) {
        Object[] objectArray = new Object[]{name};
        return JavaDebuggerBundle.message((String)"stepping.filter.real.thread.name", (Object[])objectArray);
    }

    private static final String beforeSteppingStarted$lambda$0$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit beforeSteppingStarted$lambda$0$2(SteppingAction $steppingAction, DebuggerManagerThreadImpl $managerThread, DebugProcessImpl $debuggerProcessImpl, String $steppingName, CompletableDeferred $stepCompetedStatus, boolean $needSuspendOnlyThread, ThreadReferenceProxyImpl $threadForStepping, String whereStr) {
        String steppingRestrictionMessage = SteppingProgressTrackerKt.access$getSteppingRestrictionMessage(whereStr, $steppingAction);
        Project project = $debuggerProcessImpl.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        $managerThread.makeCancelable(project, steppingRestrictionMessage, $steppingName, (CompletableDeferred<Unit>)$stepCompetedStatus, (Function0<Unit>)((Function0)() -> CancelingSteppingListener.beforeSteppingStarted$lambda$0$2$0($needSuspendOnlyThread, $debuggerProcessImpl, $threadForStepping, $managerThread)));
        return Unit.INSTANCE;
    }

    private static final void beforeSteppingStarted$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void beforeSteppingStarted$lambda$0(ThreadReferenceProxyImpl $threadForStepping, LightOrRealThreadInfo $filter, DebugProcessImpl $debuggerProcessImpl, SteppingAction $steppingAction, DebuggerManagerThreadImpl $managerThread, String $steppingName, CompletableDeferred $stepCompetedStatus, boolean $needSuspendOnlyThread) {
        CompletableFuture<Object> completableFuture;
        if ($threadForStepping != null) {
            var9_8 = DebuggerUtilsAsync.nameAsync($threadForStepping.getThreadReference()).thenApply(arg_0 -> CancelingSteppingListener.beforeSteppingStarted$lambda$0$1(CancelingSteppingListener::beforeSteppingStarted$lambda$0$0, arg_0));
            Intrinsics.checkNotNull(var9_8);
            completableFuture = var9_8;
        } else {
            Object object = $filter;
            if (object == null || (object = object.getFilterName()) == null) {
                object = $debuggerProcessImpl.getSession().getSessionName();
            }
            var9_8 = CompletableFuture.completedFuture(object);
            Intrinsics.checkNotNull(var9_8);
            completableFuture = var9_8;
        }
        CompletableFuture<Object> whereStrFuture = completableFuture;
        whereStrFuture.thenAccept(arg_0 -> CancelingSteppingListener.beforeSteppingStarted$lambda$0$3(arg_0 -> CancelingSteppingListener.beforeSteppingStarted$lambda$0$2($steppingAction, $managerThread, $debuggerProcessImpl, $steppingName, $stepCompetedStatus, $needSuspendOnlyThread, $threadForStepping, arg_0), arg_0));
    }
}

