/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class CollectionBreakpointUtils {
    private static final Logger LOG = Logger.getInstance(CollectionBreakpointUtils.class);
    private static final String OBJECT_TYPE = "Ljava/lang/Object;";
    private static final String STRING_TYPE = "Ljava/lang/String;";
    private static final String INSTRUMENTOR_CLS_NAME = "com.intellij.rt.debugger.agent.CollectionBreakpointInstrumentor";
    private static final String STORAGE_CLASS_NAME = "com.intellij.rt.debugger.agent.CollectionBreakpointStorage";
    private static final String COLLECTION_MODIFICATION_INFO_CLASS_NAME = "com.intellij.rt.debugger.agent.CollectionBreakpointStorage$CollectionModificationInfo";
    private static final String ENABLE_DEBUG_MODE_FIELD = "DEBUG";
    private static final String ENABLE_HISTORY_SAVING_FIELD = "ENABLED";
    private static final String GET_FIELD_MODIFICATIONS_METHOD_NAME = "getFieldModifications";
    private static final String GET_FIELD_MODIFICATIONS_METHOD_DESC = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)[Ljava/lang/Object;";
    private static final String GET_COLLECTION_MODIFICATIONS_METHOD_NAME = "getCollectionModifications";
    private static final String GET_COLLECTION_MODIFICATIONS_METHOD_DESC = "(Ljava/lang/Object;)[Ljava/lang/Object;";
    private static final String GET_COLLECTION_STACK_METHOD_NAME = "getStack";
    private static final String GET_COLLECTION_STACK_METHOD_DESC = "(Ljava/lang/Object;I)Ljava/lang/String;";
    private static final String GET_FIELD_STACK_METHOD_NAME = "getStack";
    private static final String GET_FIELD_STACK_METHOD_DESC = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;I)Ljava/lang/String;";
    private static final String GET_ELEMENT_METHOD_NAME = "getElement";
    private static final String GET_ELEMENT_METHOD_DESC = "()Ljava/lang/Object;";
    private static final String IS_ADDITION_METHOD_NAME = "isAddition";
    private static final String IS_ADDITION_METHOD_DESC = "()Z";

    public static void setupCollectionBreakpointAgent(DebugProcessImpl debugProcess) {
        if (Registry.is((String)"debugger.collection.breakpoint.agent.debug")) {
            CollectionBreakpointUtils.enableDebugMode(debugProcess);
        }
    }

    private static void enableDebugMode(DebugProcessImpl debugProcess) {
        try {
            DebuggerUtilsEx.setStaticBooleanField(debugProcess, INSTRUMENTOR_CLS_NAME, ENABLE_DEBUG_MODE_FIELD, true);
        }
        catch (Exception e) {
            LOG.warn("Error setting collection breakpoint agent debug mode", (Throwable)e);
        }
    }

    public static void setCollectionHistorySavingEnabled(DebugProcessImpl debugProcess, boolean enabled) {
        try {
            DebuggerUtilsEx.setStaticBooleanField(debugProcess, STORAGE_CLASS_NAME, ENABLE_HISTORY_SAVING_FIELD, enabled);
        }
        catch (Exception e) {
            LOG.warn("Error setting collection history saving enabled", (Throwable)e);
        }
    }

    private static VirtualMachineProxyImpl getVirtualMachine(SuspendContextImpl context) {
        StackFrameProxyImpl frameProxy = context.getFrameProxy();
        return frameProxy != null ? frameProxy.getVirtualMachine() : null;
    }

    @NotNull
    public static List<Value> getFieldModificationsHistory(SuspendContextImpl context, String fieldName, String clsName, @Nullable Value clsInstance) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl virtualMachineProxy = CollectionBreakpointUtils.getVirtualMachine(context);
        if (virtualMachineProxy == null) {
            List<Value> list = Collections.emptyList();
            if (list == null) {
                CollectionBreakpointUtils.$$$reportNull$$$0(0);
            }
            return list;
        }
        StringReference clsNameRef = DebuggerUtilsEx.mirrorOfString(clsName, context);
        StringReference fieldNameRef = DebuggerUtilsEx.mirrorOfString(fieldName, context);
        Value result = CollectionBreakpointUtils.invokeStorageMethod(context.getDebugProcess(), context, GET_FIELD_MODIFICATIONS_METHOD_NAME, GET_FIELD_MODIFICATIONS_METHOD_DESC, CollectionBreakpointUtils.toList(clsNameRef, fieldNameRef, clsInstance));
        if (result instanceof ArrayReference) {
            List<Value> list = ((ArrayReference)result).getValues();
            if (list == null) {
                CollectionBreakpointUtils.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<Value> list = Collections.emptyList();
        if (list == null) {
            CollectionBreakpointUtils.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<StackFrameItem> getFieldModificationStack(SuspendContextImpl context, String fieldName, String clsName, @Nullable Value collectionInstance, IntegerValue modificationIndex) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl virtualMachineProxy = CollectionBreakpointUtils.getVirtualMachine(context);
        if (virtualMachineProxy == null) {
            List<StackFrameItem> list = Collections.emptyList();
            if (list == null) {
                CollectionBreakpointUtils.$$$reportNull$$$0(3);
            }
            return list;
        }
        StringReference clsNameRef = DebuggerUtilsEx.mirrorOfString(clsName, context);
        StringReference fieldNameRef = DebuggerUtilsEx.mirrorOfString(fieldName, context);
        Value result = CollectionBreakpointUtils.invokeStorageMethod(context.getDebugProcess(), context, "getStack", GET_FIELD_STACK_METHOD_DESC, CollectionBreakpointUtils.toList(clsNameRef, fieldNameRef, collectionInstance, modificationIndex));
        String message = result instanceof StringReference ? ((StringReference)result).value() : "";
        List<StackFrameItem> list = CollectionBreakpointUtils.readStackItems(context.getDebugProcess(), message, virtualMachineProxy);
        if (list == null) {
            CollectionBreakpointUtils.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static List<StackFrameItem> readStackItems(DebugProcessImpl debugProcess, String message, VirtualMachineProxyImpl virtualMachineProxy) {
        ArrayList<StackFrameItem> items2 = new ArrayList<StackFrameItem>();
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(message.getBytes(StandardCharsets.ISO_8859_1)));){
            while (dis.available() > 0) {
                String className = dis.readUTF();
                String methodName = dis.readUTF();
                int line = dis.readInt();
                Location location = DebuggerUtilsEx.findOrCreateLocation(virtualMachineProxy.getVirtualMachine(), className, methodName, line);
                StackFrameItem item = new StackFrameItem(location, null);
                items2.add(item);
            }
        }
        catch (Exception e) {
            DebuggerUtilsImpl.logError(e);
        }
        return items2;
    }

    @NotNull
    public static List<Value> getCollectionModificationsHistory(SuspendContextImpl context, Value collectionInstance) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl virtualMachineProxy = CollectionBreakpointUtils.getVirtualMachine(context);
        if (virtualMachineProxy == null) {
            List<Value> list = Collections.emptyList();
            if (list == null) {
                CollectionBreakpointUtils.$$$reportNull$$$0(5);
            }
            return list;
        }
        Value collectionModifications = CollectionBreakpointUtils.invokeStorageMethod(context.getDebugProcess(), context, GET_COLLECTION_MODIFICATIONS_METHOD_NAME, GET_COLLECTION_MODIFICATIONS_METHOD_DESC, Collections.singletonList(collectionInstance));
        if (collectionModifications instanceof ArrayReference) {
            List<Value> list = ((ArrayReference)collectionModifications).getValues();
            if (list == null) {
                CollectionBreakpointUtils.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<Value> list = Collections.emptyList();
        if (list == null) {
            CollectionBreakpointUtils.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static List<StackFrameItem> getCollectionModificationStack(SuspendContextImpl context, @Nullable Value collectionInstance, IntegerValue modificationIndex) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl virtualMachineProxy = CollectionBreakpointUtils.getVirtualMachine(context);
        if (virtualMachineProxy == null) {
            return Collections.emptyList();
        }
        Value result = CollectionBreakpointUtils.invokeStorageMethod(context.getDebugProcess(), context, "getStack", GET_COLLECTION_STACK_METHOD_DESC, CollectionBreakpointUtils.toList(collectionInstance, modificationIndex));
        String message = result instanceof StringReference ? ((StringReference)result).value() : "";
        return CollectionBreakpointUtils.readStackItems(context.getDebugProcess(), message, virtualMachineProxy);
    }

    private static List<Value> toList(Value ... elements) {
        ArrayList<Value> list = new ArrayList<Value>();
        Collections.addAll(list, elements);
        return list;
    }

    @Nullable
    public static Pair<ObjectReference, BooleanValue> getCollectionModificationInfo(DebugProcessImpl debugProcess, EvaluationContext evaluationContext, ObjectReference collectionInstance) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ClassType cls = CollectionBreakpointUtils.getClass(debugProcess, evaluationContext, COLLECTION_MODIFICATION_INFO_CLASS_NAME);
        if (cls != null) {
            Method getElementMethod = DebuggerUtils.findMethod((ReferenceType)cls, (String)GET_ELEMENT_METHOD_NAME, (String)GET_ELEMENT_METHOD_DESC);
            Method isAdditionMethod = DebuggerUtils.findMethod((ReferenceType)cls, (String)IS_ADDITION_METHOD_NAME, (String)IS_ADDITION_METHOD_DESC);
            if (getElementMethod == null || isAdditionMethod == null) {
                return null;
            }
            try {
                Value element = debugProcess.invokeInstanceMethod(evaluationContext, collectionInstance, getElementMethod, Collections.emptyList(), 0);
                Value isAddition = debugProcess.invokeInstanceMethod(evaluationContext, collectionInstance, isAdditionMethod, Collections.emptyList(), 0);
                if (element instanceof ObjectReference && isAddition instanceof BooleanValue) {
                    return new Pair((Object)((ObjectReference)element), (Object)((BooleanValue)isAddition));
                }
            }
            catch (EvaluateException e) {
                DebuggerUtilsImpl.logError(e);
            }
        }
        return null;
    }

    public static Value invokeInstrumentorMethod(DebugProcessImpl debugProcess, SuspendContextImpl context, String methodName, String methodDesc, List<Value> args) {
        return CollectionBreakpointUtils.invokeMethod(debugProcess, context, INSTRUMENTOR_CLS_NAME, methodName, methodDesc, args);
    }

    public static Value invokeStorageMethod(DebugProcessImpl debugProcess, SuspendContextImpl context, String methodName, String methodDesc, List<Value> args) {
        return CollectionBreakpointUtils.invokeMethod(debugProcess, context, STORAGE_CLASS_NAME, methodName, methodDesc, args);
    }

    private static ClassType getClass(DebugProcessImpl debugProcess, @Nullable EvaluationContext evalContext, String clsName) {
        try {
            return (ClassType)debugProcess.findClass(evalContext, clsName, null);
        }
        catch (EvaluateException e) {
            return null;
        }
    }

    public static ClassType getInstrumentorClass(DebugProcessImpl debugProcess, @Nullable EvaluationContextImpl evalContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return CollectionBreakpointUtils.getClass(debugProcess, evalContext, INSTRUMENTOR_CLS_NAME);
    }

    public static ClassType getStorageClass(DebugProcessImpl debugProcess, @Nullable EvaluationContextImpl evalContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return CollectionBreakpointUtils.getClass(debugProcess, evalContext, STORAGE_CLASS_NAME);
    }

    private static Value invokeMethod(DebugProcessImpl debugProcess, SuspendContextImpl context, String clsName, String methodName, String methodDesc, List<Value> args) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        EvaluationContextImpl evalContext = new EvaluationContextImpl(context, context.getFrameProxy());
        evalContext = evalContext.withAutoLoadClasses(false);
        try {
            ClassType cls = CollectionBreakpointUtils.getClass(debugProcess, evalContext, clsName);
            if (cls == null) {
                return null;
            }
            Method method = DebuggerUtils.findMethod((ReferenceType)cls, (String)methodName, (String)methodDesc);
            if (method != null) {
                return debugProcess.invokeMethod((EvaluationContext)evalContext, cls, method, args);
            }
        }
        catch (EvaluateException e) {
            DebuggerUtilsImpl.logError(e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/engine/CollectionBreakpointUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldModificationsHistory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldModificationStack";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionModificationsHistory";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

