/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.ReportingEvaluationCallback;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluator;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerDocumentOffsetEvaluator;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackWithOrigin;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

public class JavaDebuggerEvaluator
extends XDebuggerEvaluator
implements XDebuggerDocumentOffsetEvaluator {
    private final DebugProcessImpl myDebugProcess;
    private final JavaStackFrame myStackFrame;

    public JavaDebuggerEvaluator(DebugProcessImpl debugProcess, JavaStackFrame stackFrame) {
        this.myDebugProcess = debugProcess;
        this.myStackFrame = stackFrame;
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(1);
        }
        this.evaluate((XExpression)XExpressionImpl.fromText((String)expression), callback, expressionPosition);
    }

    public void evaluate(@NotNull XExpression expression, @NotNull XDebuggerEvaluator.XEvaluationCallback baseCallback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(2);
        }
        if (baseCallback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(3);
        }
        this.evaluate(baseCallback, (debuggerContext, evalContext) -> {
            TextWithImports text = TextWithImportsImpl.fromXExpression(expression);
            NodeManagerImpl nodeManager = Objects.requireNonNull(this.myDebugProcess.getXdebugProcess()).getNodeManager();
            return nodeManager.getWatchItemDescriptor(null, text, null);
        });
    }

    private void evaluatePsiElement(@NotNull PsiElement element, @NotNull XDebuggerEvaluator.XEvaluationCallback baseCallback) {
        if (element == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(4);
        }
        if (baseCallback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(5);
        }
        this.evaluate(baseCallback, (debuggerContext, evalContext) -> {
            Project project = this.myDebugProcess.getProject();
            Ref text = new Ref();
            final ExpressionEvaluator evaluator = (ExpressionEvaluator)ReadAction.compute(() -> {
                text.set((Object)new TextWithImportsImpl(element));
                CodeFragmentFactory factory = DebuggerUtilsEx.getCodeFragmentFactory(element, null);
                try {
                    if (Registry.is((String)"debugger.compiling.evaluator.force")) {
                        throw new UnsupportedExpressionException("force compilation");
                    }
                    return factory.getEvaluatorBuilder().build(element, ContextUtil.getSourcePosition((StackFrameContext)evalContext));
                }
                catch (UnsupportedExpressionException ex) {
                    PsiElement context = PositionUtil.getContextElement((StackFrameContext)debuggerContext);
                    CompilingEvaluator eval = CompilingEvaluatorImpl.create(project, context, e -> factory.createPsiCodeFragment((TextWithImports)text.get(), context, project));
                    if (eval != null) {
                        return eval;
                    }
                    throw ex;
                }
            });
            return new WatchItemDescriptor(this, project, (TextWithImports)text.get()){

                @Override
                @NotNull
                protected ExpressionEvaluator getEvaluator(EvaluationContextImpl evaluationContext) {
                    ExpressionEvaluator expressionEvaluator = evaluator;
                    if (expressionEvaluator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return expressionEvaluator;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaDebuggerEvaluator$1", "getEvaluator"));
                }
            };
        });
    }

    private void evaluate(final @NotNull XDebuggerEvaluator.XEvaluationCallback baseCallback, final @NotNull DescriptorProducer descriptorSupplier) {
        if (baseCallback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(6);
        }
        if (descriptorSupplier == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(7);
        }
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext(), this.myStackFrame.getStackFrameProxy().threadProxy()){

            @Override
            @NotNull
            public PrioritizedTask.Priority getPriority() {
                PrioritizedTask.Priority priority = PrioritizedTask.Priority.NORMAL;
                if (priority == null) {
                    2.$$$reportNull$$$0(0);
                }
                return priority;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(1);
                }
                XEvaluationOrigin origin = XEvaluationCallbackWithOrigin.getOrigin((XDebuggerEvaluator.XEvaluationCallback)baseCallback);
                ReportingEvaluationCallback callback = new ReportingEvaluationCallback(JavaDebuggerEvaluator.this.myDebugProcess.getProject(), baseCallback, origin);
                WatchItemDescriptor descriptor = null;
                try {
                    if (DebuggerUIUtil.isObsolete((Object)callback)) {
                        return;
                    }
                    JavaDebugProcess process = JavaDebuggerEvaluator.this.myDebugProcess.getXdebugProcess();
                    if (process == null) {
                        callback.errorOccurred(JavaDebuggerBundle.message((String)"error.no.debug.process", (Object[])new Object[0]), descriptor);
                        return;
                    }
                    DebuggerContextImpl debuggerContext = JavaDebuggerEvaluator.this.myStackFrame.getFrameDebuggerContext(this.getDebuggerContext());
                    EvaluationContextImpl evalContext = debuggerContext.createEvaluationContext();
                    if (evalContext == null) {
                        callback.errorOccurred(JavaDebuggerBundle.message((String)"error.context.not.available", (Object[])new Object[0]), descriptor);
                        return;
                    }
                    XEvaluationOrigin.setOrigin((UserDataHolder)evalContext, (XEvaluationOrigin)origin);
                    try {
                        descriptor = descriptorSupplier.produce(debuggerContext, evalContext);
                        descriptor.setContext(evalContext);
                        EvaluateException exception = descriptor.getEvaluateException();
                        if (exception != null && descriptor.getValue() == null) {
                            callback.invalidExpression(exception.getMessage(), descriptor);
                            return;
                        }
                        callback.evaluated((XValue)JavaValue.create(null, descriptor, evalContext, process.getNodeManager(), true));
                    }
                    catch (EvaluateException e) {
                        callback.errorOccurred(e.getMessage(), descriptor);
                    }
                }
                catch (Throwable e) {
                    callback.errorOccurred(JavaDebuggerBundle.message((String)"error.internal", (Object[])new Object[0]), descriptor);
                    throw e;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/engine/JavaDebuggerEvaluator$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suspendContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPriority";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/engine/JavaDebuggerEvaluator$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "threadAction";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        });
    }

    @ApiStatus.Internal
    public final void evaluate(@NotNull Document document, int offset, @NotNull ValueHintType hintType, @NotNull XDebuggerEvaluator.XEvaluationCallback callback) {
        if (document == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(8);
        }
        if (hintType == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(9);
        }
        if (callback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(10);
        }
        JavaDebuggerEvaluator.getPsiExpressionAtOffsetAsync(this.myDebugProcess.getProject(), document, offset, hintType == ValueHintType.MOUSE_CLICK_HINT || hintType == ValueHintType.MOUSE_ALT_OVER_HINT).onProcessed(pair -> {
            if (pair != null) {
                PsiElement element = (PsiElement)pair.getFirst();
                if (element instanceof PsiExpression) {
                    this.evaluatePsiElement(element, callback);
                } else {
                    this.evaluate((XExpression)XExpressionImpl.fromText((String)element.getText()), callback, null);
                }
            } else {
                callback.errorOccurred(JavaDebuggerBundle.message((String)"evaluation.error.expression.info", (Object[])new Object[0]));
            }
        });
    }

    @NotNull
    private static XEvaluationOrigin getOrigin(@NotNull XDebuggerEvaluator.XEvaluationCallback callback) {
        XEvaluationOrigin xEvaluationOrigin;
        if (callback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(11);
        }
        if (callback instanceof XEvaluationCallbackWithOrigin) {
            XEvaluationCallbackWithOrigin callbackWithOrigin = (XEvaluationCallbackWithOrigin)callback;
            xEvaluationOrigin = callbackWithOrigin.getOrigin();
        } else {
            xEvaluationOrigin = XEvaluationOrigin.UNSPECIFIED;
        }
        if (xEvaluationOrigin == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(12);
        }
        return xEvaluationOrigin;
    }

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        if (project == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(13);
        }
        if (document == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(14);
        }
        Promise promise = JavaDebuggerEvaluator.getPsiExpressionAtOffsetAsync(project, document, offset, sideEffectsAllowed).then(pair -> {
            if (pair != null) {
                return new ExpressionInfo((TextRange)pair.getSecond(), null, null);
            }
            return null;
        });
        if (promise == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(15);
        }
        return promise;
    }

    private static @NotNull Promise<@Nullable Pair<PsiElement, TextRange>> getPsiExpressionAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        if (project == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(16);
        }
        if (document == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(17);
        }
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> {
            EditorTextProvider textProvider;
            PsiElement elementAtCursor = DebuggerUtilsEx.findElementAt(PsiDocumentManager.getInstance((Project)project).getPsiFile(document), offset);
            if (elementAtCursor != null && elementAtCursor.isValid() && (textProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(elementAtCursor.getLanguage())) != null) {
                Pair<PsiElement, TextRange> pair = textProvider.findExpression(elementAtCursor, sideEffectsAllowed);
                return pair;
            }
            return null;
        }).inSmartMode(project).withDocumentsCommitted(project).submit((Executor)AppExecutorUtil.getAppExecutorService());
        if (cancellablePromise == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(18);
        }
        return cancellablePromise;
    }

    public EvaluationMode getEvaluationMode(@NotNull String text, int startOffset, int endOffset, @Nullable PsiFile psiFile) {
        if (text == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(19);
        }
        if (psiFile != null) {
            PsiElement[] range = CodeInsightUtil.findStatementsInRange((PsiFile)psiFile, (int)startOffset, (int)endOffset);
            return range.length > 1 ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
        }
        return super.getEvaluationMode(text, startOffset, endOffset, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 15, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseCallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorSupplier";
                break;
            }
            case 8: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintType";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaDebuggerEvaluator";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaDebuggerEvaluator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrigin";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionInfoAtOffsetAsync";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiExpressionAtOffsetAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePsiElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrigin";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfoAtOffsetAsync";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPsiExpressionAtOffsetAsync";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluationMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 15, 18 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    private static interface DescriptorProducer {
        public WatchItemDescriptor produce(DebuggerContextImpl var1, EvaluationContextImpl var2) throws EvaluateException;
    }
}

