/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.AsyncStackTraceProvider;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.CreationStackTraceProvider;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.feedback.UsageTracker;
import com.intellij.debugger.impl.DebugUtilsKt;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.BreakpointIntentionAction;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.java.debugger.impl.shared.engine.JavaExecutionStackDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XDescriptor;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.HiddenStackFramesItem;
import com.intellij.xdebugger.impl.frame.XFramesView;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.jetbrains.jdi.ThreadGroupReferenceImpl;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaExecutionStack
extends XExecutionStack {
    private static final Logger LOG = Logger.getInstance(JavaExecutionStack.class);
    private final ThreadReferenceProxyImpl myThreadProxy;
    private final DebugProcessImpl myDebugProcess;
    private final CompletableFuture<@NotNull List<@NotNull XStackFrame>> myTopFrames;
    private final MethodsTracker myTracker;

    public JavaExecutionStack(@NotNull ThreadReferenceProxyImpl threadProxy, @NotNull DebugProcessImpl debugProcess, boolean current) {
        if (threadProxy == null) {
            JavaExecutionStack.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            JavaExecutionStack.$$$reportNull$$$0(1);
        }
        super(JavaExecutionStack.calcRepresentation(threadProxy), JavaExecutionStack.calcIcon(threadProxy, current));
        this.myTopFrames = new CompletableFuture();
        this.myTracker = new MethodsTracker();
        this.myThreadProxy = threadProxy;
        this.myDebugProcess = debugProcess;
    }

    private JavaExecutionStack(@NlsContexts.ListItem @NotNull String displayName, @Nullable Icon icon, @NotNull ThreadReferenceProxyImpl threadProxy, @NotNull DebugProcessImpl debugProcess) {
        if (displayName == null) {
            JavaExecutionStack.$$$reportNull$$$0(2);
        }
        if (threadProxy == null) {
            JavaExecutionStack.$$$reportNull$$$0(3);
        }
        if (debugProcess == null) {
            JavaExecutionStack.$$$reportNull$$$0(4);
        }
        super(displayName, icon);
        this.myTopFrames = new CompletableFuture();
        this.myTracker = new MethodsTracker();
        this.myThreadProxy = threadProxy;
        this.myDebugProcess = debugProcess;
    }

    public static CompletableFuture<@Nullable JavaExecutionStack> create(@NotNull ThreadReferenceProxyImpl threadProxy, @NotNull DebugProcessImpl debugProcess, boolean current) {
        if (threadProxy == null) {
            JavaExecutionStack.$$$reportNull$$$0(5);
        }
        if (debugProcess == null) {
            JavaExecutionStack.$$$reportNull$$$0(6);
        }
        return ((CompletableFuture)JavaExecutionStack.calcRepresentationAsync(threadProxy).thenCombine(JavaExecutionStack.calcIconAsync(threadProxy, current), (text, icon) -> new JavaExecutionStack((String)text, (Icon)icon, threadProxy, debugProcess))).handle((stack, throwable) -> {
            if (throwable instanceof ObjectCollectedException) {
                return null;
            }
            if (throwable != null) {
                throw new CompletionException((Throwable)throwable);
            }
            return stack;
        });
    }

    private static Icon calcIcon(ThreadReferenceProxyImpl threadProxy, boolean current) {
        if (current) {
            return threadProxy.isSuspended() ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadRunning;
        }
        if (threadProxy.isAtBreakpoint()) {
            return AllIcons.Debugger.ThreadAtBreakpoint;
        }
        if (threadProxy.isSuspended()) {
            return AllIcons.Debugger.ThreadSuspended;
        }
        return AllIcons.Debugger.ThreadRunning;
    }

    private static CompletableFuture<Icon> calcIconAsync(ThreadReferenceProxyImpl threadProxy, boolean current) {
        ThreadReference ref = threadProxy.getThreadReference();
        if (!DebuggerUtilsAsync.isAsyncEnabled() || !(ref instanceof ThreadReferenceImpl)) {
            return CompletableFuture.completedFuture(JavaExecutionStack.calcIcon(threadProxy, current));
        }
        ThreadReferenceImpl threadReference = (ThreadReferenceImpl)ref;
        if (current) {
            return JavaExecutionStack.calcThreadIconAsync(threadReference, true);
        }
        return threadReference.isAtBreakpointAsync().thenCompose(r -> {
            if (r.booleanValue()) {
                return CompletableFuture.completedFuture(AllIcons.Debugger.ThreadAtBreakpoint);
            }
            return JavaExecutionStack.calcThreadIconAsync(threadReference, false);
        });
    }

    private static CompletableFuture<Icon> calcThreadIconAsync(ThreadReferenceImpl threadReference, boolean current) {
        return threadReference.isSuspendedAsync().thenApply(suspended -> {
            if (suspended.booleanValue()) {
                if (current) {
                    return AllIcons.Debugger.ThreadCurrent;
                }
                return AllIcons.Debugger.ThreadSuspended;
            }
            return AllIcons.Debugger.ThreadRunning;
        });
    }

    @ApiStatus.Internal
    @NotNull
    public ThreadReferenceProxyImpl getThreadProxy() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.myThreadProxy;
        if (threadReferenceProxyImpl == null) {
            JavaExecutionStack.$$$reportNull$$$0(7);
        }
        return threadReferenceProxyImpl;
    }

    public final void initTopFrame() {
        if (this.myTopFrames.isDone()) {
            return;
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            StackFrameProxyImpl frame = this.myThreadProxy.frame(0);
            if (frame != null) {
                this.myTopFrames.complete(this.createStackFrames(frame));
            }
            UsageTracker.topFrameInitialized(this.getTopFrame());
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    public List<XStackFrame> createStackFrames(@NotNull StackFrameProxyImpl stackFrameProxy) {
        if (stackFrameProxy == null) {
            JavaExecutionStack.$$$reportNull$$$0(8);
        }
        return this.createFrames(new StackFrameDescriptorImpl(this.myTracker, stackFrameProxy));
    }

    @NotNull
    private CompletableFuture<List<XStackFrame>> createStackFramesAsync(@NotNull StackFrameProxyImpl stackFrameProxy) {
        if (stackFrameProxy == null) {
            JavaExecutionStack.$$$reportNull$$$0(9);
        }
        if (!Registry.is((String)"debugger.async.frames")) {
            CompletableFuture<List<XStackFrame>> completableFuture = CompletableFuture.completedFuture(this.createStackFrames(stackFrameProxy));
            if (completableFuture == null) {
                JavaExecutionStack.$$$reportNull$$$0(10);
            }
            return completableFuture;
        }
        CompletionStage completionStage = StackFrameDescriptorImpl.createAsync(stackFrameProxy, this.myTracker).thenCompose(this::createFramesAsync);
        if (completionStage == null) {
            JavaExecutionStack.$$$reportNull$$$0(11);
        }
        return completionStage;
    }

    @NotNull
    private List<XStackFrame> createFrames(StackFrameDescriptorImpl descriptor) {
        this.markCallerFrame(descriptor);
        List<XStackFrame> customFrames = this.myDebugProcess.getPositionManager().createStackFrames(descriptor);
        if (customFrames != null) {
            List<XStackFrame> list = customFrames;
            if (list == null) {
                JavaExecutionStack.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<XStackFrame> list = Collections.singletonList(new JavaStackFrame(descriptor, true));
        if (list == null) {
            JavaExecutionStack.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private @NotNull CompletableFuture<@NotNull List<XStackFrame>> createFramesAsync(StackFrameDescriptorImpl descriptor) {
        this.markCallerFrame(descriptor);
        CompletionStage completionStage = this.myDebugProcess.getPositionManager().createStackFramesAsync(descriptor).thenApply(customFrames -> {
            if (customFrames != null) {
                return customFrames;
            }
            return Collections.singletonList(new JavaStackFrame(descriptor, true));
        });
        if (completionStage == null) {
            JavaExecutionStack.$$$reportNull$$$0(14);
        }
        return completionStage;
    }

    private void markCallerFrame(StackFrameDescriptorImpl descriptor) {
        Method method;
        XStackFrame topFrame = this.getTopFrame();
        if (descriptor.getUiIndex() == 1 && topFrame instanceof JavaStackFrame && (method = descriptor.getMethod()) != null) {
            ((JavaStackFrame)topFrame).getDescriptor().putUserData(BreakpointIntentionAction.CALLER_KEY, DebuggerUtilsEx.methodKey(method));
        }
    }

    @Nullable
    public XStackFrame getTopFrame() {
        List<@NotNull T> topFrames = this.myTopFrames.getNow(Collections.emptyList());
        return (XStackFrame)ContainerUtil.getFirstItem(topFrames);
    }

    public @NotNull CompletableFuture<@Nullable XStackFrame> getTopFrameAsync() {
        CompletionStage completionStage = this.myTopFrames.thenApply(frames -> (XStackFrame)ContainerUtil.getFirstItem((List)frames));
        if (completionStage == null) {
            JavaExecutionStack.$$$reportNull$$$0(15);
        }
        return completionStage;
    }

    public void computeStackFrames(final int firstFrameIndex, final XExecutionStack.XStackFrameContainer container) {
        if (container.isObsolete()) {
            return;
        }
        DebuggerContextImpl debuggerContext = this.myDebugProcess.getDebuggerContext();
        Objects.requireNonNull(debuggerContext.getManagerThread()).schedule(new DebuggerContextCommandImpl(debuggerContext, this.myThreadProxy){

            @Override
            @NotNull
            public PrioritizedTask.Priority getPriority() {
                PrioritizedTask.Priority priority = PrioritizedTask.Priority.NORMAL;
                if (priority == null) {
                    1.$$$reportNull$$$0(0);
                }
                return priority;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!JavaExecutionStack.this.myThreadProxy.isSuspended()) {
                    container.errorOccurred(JavaDebuggerBundle.message((String)"frame.panel.frames.not.available", (Object[])new Object[0]));
                    return;
                }
                if (container.isObsolete()) {
                    return;
                }
                int status = JavaExecutionStack.this.myThreadProxy.status();
                if (status == 0) {
                    container.errorOccurred(JavaDebuggerBundle.message((String)"frame.panel.thread.finished", (Object[])new Object[0]));
                } else if (JavaExecutionStack.this.myDebugProcess.getSuspendManager().isSuspended(JavaExecutionStack.this.myThreadProxy)) {
                    if (status != -1 && status != 5) {
                        try {
                            int added = 0;
                            Iterator<StackFrameProxyImpl> iterator = JavaExecutionStack.this.myThreadProxy.frames().iterator();
                            if (iterator.hasNext() && firstFrameIndex > 0) {
                                iterator.next();
                                ++added;
                            }
                            suspendContext.getManagerThread().schedule(new AppendFrameCommand(JavaExecutionStack.this, suspendContext, iterator, container, added, firstFrameIndex));
                        }
                        catch (EvaluateException e) {
                            container.errorOccurred(e.getMessage());
                        }
                    }
                } else {
                    container.errorOccurred(JavaDebuggerBundle.message((String)"frame.panel.frames.not.available", (Object[])new Object[0]));
                }
            }

            @Override
            protected void commandCancelled() {
                container.errorOccurred(JavaDebuggerBundle.message((String)"frame.panel.frames.not.available", (Object[])new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/engine/JavaExecutionStack$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suspendContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPriority";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/engine/JavaExecutionStack$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "threadAction";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        });
    }

    @Nullable
    public CompletableFuture<XDescriptor> getXExecutionStackDescriptorAsync() {
        final CompletableFuture<XDescriptor> future = new CompletableFuture<XDescriptor>();
        Objects.requireNonNull(this.myDebugProcess.getDebuggerContext().getManagerThread()).schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                future.complete(new JavaExecutionStackDescriptor(JavaExecutionStack.this.myThreadProxy.isSuspended()));
            }

            @Override
            @NotNull
            public PrioritizedTask.Priority getPriority() {
                PrioritizedTask.Priority priority = PrioritizedTask.Priority.HIGH;
                if (priority == null) {
                    2.$$$reportNull$$$0(0);
                }
                return priority;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaExecutionStack$2", "getPriority"));
            }
        });
        return future;
    }

    private static boolean showFrame(@NotNull XStackFrame frame) {
        if (frame == null) {
            JavaExecutionStack.$$$reportNull$$$0(16);
        }
        if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames() && frame instanceof JVMStackFrameInfoProvider) {
            JVMStackFrameInfoProvider info = (JVMStackFrameInfoProvider)frame;
            return !info.shouldHide();
        }
        return true;
    }

    @NlsContexts.ListItem
    private static String calcRepresentation(ThreadReferenceProxyImpl thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        String name = thread.name();
        ThreadGroupReferenceProxyImpl gr = thread.threadGroupProxy();
        String grname = gr != null ? gr.name() : null;
        String threadStatusText = DebuggerUtilsEx.getThreadStatusText(thread.status());
        if (grname != null && !"SYSTEM".equalsIgnoreCase(grname)) {
            return JavaDebuggerBundle.message((String)"label.thread.node.in.group", (Object[])new Object[]{name, thread.uniqueID(), threadStatusText, grname});
        }
        return JavaDebuggerBundle.message((String)"label.thread.node", (Object[])new Object[]{name, thread.uniqueID(), threadStatusText});
    }

    @NlsContexts.ListItem
    private static CompletableFuture<String> calcRepresentationAsync(ThreadReferenceProxyImpl thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference ref = thread.getThreadReference();
        if (!DebuggerUtilsAsync.isAsyncEnabled() || !(ref instanceof ThreadReferenceImpl)) {
            return CompletableFuture.completedFuture(JavaExecutionStack.calcRepresentation(thread));
        }
        ThreadReferenceImpl threadReference = (ThreadReferenceImpl)ref;
        CompletableFuture nameFuture = threadReference.nameAsync();
        CompletionStage groupNameFuture = threadReference.threadGroupAsync().thenCompose(gr -> {
            if (gr instanceof ThreadGroupReferenceImpl) {
                return ((ThreadGroupReferenceImpl)gr).nameAsync();
            }
            return CompletableFuture.completedFuture(null);
        });
        CompletionStage statusTextFuture = threadReference.statusAsync().thenApply(DebuggerUtilsEx::getThreadStatusText);
        long uniqueID = threadReference.uniqueID();
        return DebuggerUtilsAsync.reschedule(groupNameFuture).thenCompose(arg_0 -> JavaExecutionStack.lambda$calcRepresentationAsync$8(nameFuture, (CompletableFuture)statusTextFuture, uniqueID, arg_0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JavaExecutionStack stack = (JavaExecutionStack)((Object)o);
        return this.myThreadProxy.equals(stack.myThreadProxy);
    }

    public int hashCode() {
        return this.myThreadProxy.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ CompletionStage lambda$calcRepresentationAsync$8(CompletableFuture nameFuture, CompletableFuture statusTextFuture, long uniqueID, String grname) {
        return nameFuture.thenCombine((CompletionStage)statusTextFuture, (name, threadStatusText) -> {
            if (grname != null && !"SYSTEM".equalsIgnoreCase(grname)) {
                return JavaDebuggerBundle.message((String)"label.thread.node.in.group", (Object[])new Object[]{name, uniqueID, threadStatusText, grname});
            }
            return JavaDebuggerBundle.message((String)"label.thread.node", (Object[])new Object[]{name, uniqueID, threadStatusText});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadProxy";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaExecutionStack";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameProxy";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaExecutionStack";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadProxy";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createStackFramesAsync";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFramesAsync";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopFrameAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createStackFrames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createStackFramesAsync";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showFrame";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    private class AppendFrameCommand
    extends SuspendContextCommandImpl {
        private final Iterator<StackFrameProxyImpl> myStackFramesIterator;
        private final XExecutionStack.XStackFrameContainer myContainer;
        private int myAdded;
        private final int mySkip;
        private final List<? extends StackFrameItem> myAsyncStack;
        private final List<? extends StackFrameItem> myCreationStack;
        private int myAddedAsync;
        private boolean mySeparator;
        private final List<XStackFrame> myHiddenFrames;
        final /* synthetic */ JavaExecutionStack this$0;

        private AppendFrameCommand(JavaExecutionStack javaExecutionStack, @Nullable SuspendContextImpl suspendContext, Iterator<StackFrameProxyImpl> stackFramesIterator, XExecutionStack.XStackFrameContainer container, int added, int skip, @Nullable List<XStackFrame> hiddenFrames, @Nullable List<? extends StackFrameItem> asyncStack, List<? extends StackFrameItem> creationStack, int addedAsync, boolean separator) {
            this.this$0 = javaExecutionStack;
            super(suspendContext);
            this.myStackFramesIterator = stackFramesIterator;
            this.myContainer = container;
            this.myAdded = added;
            this.mySkip = skip;
            this.myHiddenFrames = hiddenFrames;
            this.myAsyncStack = asyncStack;
            this.myCreationStack = creationStack;
            this.myAddedAsync = addedAsync;
            this.mySeparator = separator;
        }

        AppendFrameCommand(@NotNull JavaExecutionStack javaExecutionStack, SuspendContextImpl suspendContext, Iterator<StackFrameProxyImpl> iterator, XExecutionStack.XStackFrameContainer container, int added, int firstFrameIndex) {
            if (suspendContext == null) {
                AppendFrameCommand.$$$reportNull$$$0(0);
            }
            this(javaExecutionStack, suspendContext, iterator, container, added, firstFrameIndex, (List<XStackFrame>)new SmartList(), null, null, 0, true);
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return this.myAdded <= 20 ? PrioritizedTask.Priority.NORMAL : PrioritizedTask.Priority.LOW;
        }

        private void flushHiddenFrames() {
            if (!XFramesView.shouldFoldHiddenFrames()) {
                return;
            }
            if (!this.myHiddenFrames.isEmpty()) {
                HiddenStackFramesItem placeholder = new HiddenStackFramesItem(this.myHiddenFrames);
                ++this.myAdded;
                this.myContainer.addStackFrames(Collections.singletonList(placeholder), false);
                this.myHiddenFrames.clear();
            }
        }

        private void rememberHiddenFrame(XStackFrame frame) {
            if (!XFramesView.shouldFoldHiddenFrames() || this.myAdded < this.mySkip) {
                return;
            }
            this.myHiddenFrames.add(frame);
        }

        private void addStackFrames(List<XStackFrame> frames, boolean last) {
            this.flushHiddenFrames();
            this.myAdded += frames.size();
            this.myContainer.addStackFrames(frames, last);
            if (last) {
                this.this$0.myTracker.finish();
            }
        }

        private boolean addFrameIfNeeded(XStackFrame frame, boolean last) {
            if (this.myAdded >= this.mySkip) {
                this.addStackFrames(Collections.singletonList(frame), last);
                return true;
            }
            if (last) {
                this.addStackFrames(Collections.emptyList(), true);
            }
            return false;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                AppendFrameCommand.$$$reportNull$$$0(1);
            }
            if (this.myContainer.isObsolete()) {
                return;
            }
            if (this.myStackFramesIterator != null && this.myStackFramesIterator.hasNext()) {
                boolean first = this.myAdded == 0;
                StackFrameProxyImpl frameProxy = this.myStackFramesIterator.next();
                CompletionStage<List<Object>> framesAsync = first && this.this$0.myTopFrames.isDone() ? this.this$0.myTopFrames : this.this$0.createStackFramesAsync(frameProxy).thenApply(fs -> {
                    if (first) {
                        this.this$0.myTopFrames.complete((List<XStackFrame>)fs);
                    }
                    return fs;
                });
                ((CompletableFuture)((CompletableFuture)framesAsync).thenAccept(frames -> {
                    for (XStackFrame frame : ContainerUtil.notNullize((List)frames)) {
                        if (first || JavaExecutionStack.showFrame(frame)) {
                            if (frame instanceof JavaStackFrame) {
                                ((JavaStackFrame)frame).getDescriptor().updateRepresentationNoNotify(null, () -> this.addStackFrames(Collections.emptyList(), !this.myStackFramesIterator.hasNext()));
                            }
                            this.addFrameIfNeeded(frame, false);
                            continue;
                        }
                        this.rememberHiddenFrame(frame);
                    }
                    if (this.myAsyncStack != null) {
                        this.schedule(suspendContext, null, this.myAsyncStack, null, true);
                        return;
                    }
                    List<StackFrameItem> relatedStack = null;
                    List creationStack = this.myCreationStack;
                    XStackFrame topFrame = (XStackFrame)ContainerUtil.getFirstItem((List)frames);
                    JavaDebugProcess xdebugProcess = suspendContext.getDebugProcess().getXdebugProcess();
                    if (xdebugProcess != null && AsyncStacksUtils.isAsyncStacksEnabled((XDebugSessionImpl)xdebugProcess.getSession()).booleanValue() && topFrame instanceof JavaStackFrame) {
                        JavaStackFrame frame = (JavaStackFrame)topFrame;
                        if (creationStack == null) {
                            creationStack = (List)DebugUtilsKt.computeSafeIfAny(CreationStackTraceProvider.EP, p -> p.getCreationStackTrace(frame, suspendContext));
                        }
                        if ((relatedStack = (List<StackFrameItem>)DebugUtilsKt.computeSafeIfAny(AsyncStackTraceProvider.EP, p -> p.getAsyncStackTrace(frame, suspendContext))) != null) {
                            this.schedule(suspendContext, null, relatedStack, null, true);
                            return;
                        }
                        relatedStack = AsyncStacksUtils.getAgentRelatedStack(frameProxy, suspendContext);
                    }
                    this.schedule(suspendContext, this.myStackFramesIterator, relatedStack, creationStack, false);
                })).exceptionally(throwable -> (Void)DebuggerUtilsAsync.logError(throwable));
            } else if (this.myAsyncStack != null && this.myAddedAsync < this.myAsyncStack.size()) {
                this.appendRelatedStack(suspendContext, this.myAsyncStack.subList(this.myAddedAsync, this.myAsyncStack.size()));
            } else if (this.myCreationStack != null && this.myAddedAsync < this.myCreationStack.size()) {
                this.appendRelatedStack(suspendContext, this.myCreationStack.subList(this.myAddedAsync, this.myCreationStack.size()));
            } else {
                this.addStackFrames(Collections.emptyList(), true);
            }
        }

        private void schedule(@NotNull SuspendContextImpl suspendContext, @Nullable Iterator<StackFrameProxyImpl> stackFramesIterator, @Nullable List<? extends StackFrameItem> asyncStackFrames, @Nullable List<? extends StackFrameItem> creationStackFrames, boolean separator) {
            if (suspendContext == null) {
                AppendFrameCommand.$$$reportNull$$$0(2);
            }
            suspendContext.getManagerThread().schedule(new AppendFrameCommand(this.this$0, suspendContext, stackFramesIterator, this.myContainer, this.myAdded, this.mySkip, this.myHiddenFrames, asyncStackFrames, creationStackFrames, this.myAddedAsync, separator));
        }

        void appendRelatedStack(@NotNull SuspendContextImpl suspendContext, List<? extends StackFrameItem> asyncStack) {
            if (suspendContext == null) {
                AppendFrameCommand.$$$reportNull$$$0(3);
            }
            for (StackFrameItem stackFrameItem : asyncStack) {
                if (this.myAddedAsync > AsyncStacksUtils.getMaxStackLength()) {
                    this.addFrameIfNeeded(new XStackFrame(this){

                        public void customizePresentation(@NotNull ColoredTextContainer component) {
                            if (component == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            component.append(JavaDebuggerBundle.message((String)"label.too.many.frames.rest.truncated", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/engine/JavaExecutionStack$AppendFrameCommand$1", "customizePresentation"));
                        }
                    }, true);
                    return;
                }
                ++this.myAddedAsync;
                if (stackFrameItem == null) {
                    this.mySeparator = true;
                    continue;
                }
                this.this$0.myDebugProcess.getPositionManager().getSourcePositionFuture(stackFrameItem.location()).thenAccept(sourcePosition -> {
                    XStackFrame newFrame = stackFrame.createFrame(this.this$0.myDebugProcess, (SourcePosition)sourcePosition);
                    this.appendFrame(suspendContext, newFrame);
                });
                return;
            }
        }

        private void appendFrame(@NotNull SuspendContextImpl suspendContext, XStackFrame newFrame) {
            if (suspendContext == null) {
                AppendFrameCommand.$$$reportNull$$$0(4);
            }
            if (newFrame != null) {
                if (JavaExecutionStack.showFrame(newFrame)) {
                    if (this.mySeparator) {
                        this.flushHiddenFrames();
                        StackFrameItem.setWithSeparator(newFrame);
                    }
                    if (this.addFrameIfNeeded(newFrame, false)) {
                        this.mySeparator = false;
                    }
                } else {
                    boolean frameHasSeparator = StackFrameItem.hasSeparatorAbove(newFrame);
                    if (XFramesView.shouldFoldHiddenFrames()) {
                        if (this.mySeparator || frameHasSeparator) {
                            this.flushHiddenFrames();
                            if (!frameHasSeparator) {
                                StackFrameItem.setWithSeparator(newFrame);
                            }
                            this.mySeparator = false;
                        }
                        this.rememberHiddenFrame(newFrame);
                    } else if (!this.mySeparator && frameHasSeparator) {
                        this.mySeparator = true;
                    }
                }
            }
            this.schedule(suspendContext, null, this.myAsyncStack, this.myCreationStack, this.mySeparator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "suspendContext";
            objectArray2[1] = "com/intellij/debugger/engine/JavaExecutionStack$AppendFrameCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contextAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "schedule";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendRelatedStack";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendFrame";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

