/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.SourcePositionHighlighter;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/debugger/engine/JavaSourcePositionHighlighter;", "Lcom/intellij/debugger/engine/SourcePositionHighlighter;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getHighlightRangeInternal", "intellij.java.debugger.impl"})
public final class JavaSourcePositionHighlighter
extends SourcePositionHighlighter
implements DumbAware {
    @Nullable
    public TextRange getHighlightRange(@NotNull SourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition, (String)"sourcePosition");
        TextRange range = this.getHighlightRangeInternal(sourcePosition);
        return DebuggerUtilsEx.getHighlightingRangeInsideLine(range, sourcePosition.getFile(), sourcePosition.getLine());
    }

    private final TextRange getHighlightRangeInternal(SourcePosition sourcePosition) {
        PsiElement element = sourcePosition.getElementAt();
        if (element != null && JavaLineBreakpointType.isReturnKeyword(element) && Intrinsics.areEqual((Object)element, (Object)JavaLineBreakpointType.findSingleConditionalReturn(sourcePosition))) {
            return element.getTextRange();
        }
        PsiElement method = DebuggerUtilsEx.getContainingMethod(sourcePosition);
        if (method instanceof PsiLambdaExpression) {
            PsiElement psiElement = ((PsiLambdaExpression)method).getBody();
            if (psiElement == null) {
                psiElement = method;
            }
            return psiElement.getTextRange();
        }
        return null;
    }
}

