/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XSteppingSuspendContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/debugger/engine/JavaSteppingSuspendContext;", "Lcom/intellij/xdebugger/impl/XSteppingSuspendContext;", "debugProcessImpl", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "javaExecutionStack", "Lcom/intellij/debugger/engine/JavaExecutionStack;", "<init>", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lcom/intellij/debugger/engine/JavaExecutionStack;)V", "getActiveExecutionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "computeExecutionStacks", "", "container", "Lcom/intellij/xdebugger/frame/XSuspendContext$XExecutionStackContainer;", "intellij.java.debugger.impl"})
public final class JavaSteppingSuspendContext
extends XSteppingSuspendContext {
    @NotNull
    private final DebugProcessImpl debugProcessImpl;
    @Nullable
    private final JavaExecutionStack javaExecutionStack;

    public JavaSteppingSuspendContext(@NotNull DebugProcessImpl debugProcessImpl, @Nullable JavaExecutionStack javaExecutionStack) {
        Intrinsics.checkNotNullParameter((Object)((Object)debugProcessImpl), (String)"debugProcessImpl");
        this.debugProcessImpl = debugProcessImpl;
        this.javaExecutionStack = javaExecutionStack;
    }

    @Nullable
    public XExecutionStack getActiveExecutionStack() {
        return this.javaExecutionStack;
    }

    public void computeExecutionStacks(@NotNull XSuspendContext.XExecutionStackContainer container) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            List<SuspendContextImpl> list = this.debugProcessImpl.getSuspendManager().getPausedContexts();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getPausedContexts(...)");
            SuspendContextImpl suspendContextImpl = (SuspendContextImpl)((Object)CollectionsKt.firstOrNull(list));
            if (suspendContextImpl == null) break block0;
            suspendContextImpl.computeExecutionStacks(container);
        }
    }
}

