/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J2\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\rR\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/debugger/engine/MethodInvokeUtils;", "", "<init>", "()V", "INVOKE_WITH_HELPER_KEY", "Lcom/intellij/openapi/util/Key;", "", "getINVOKE_WITH_HELPER_KEY$intellij_java_debugger_impl$annotations", "getINVOKE_WITH_HELPER_KEY$intellij_java_debugger_impl", "()Lcom/intellij/openapi/util/Key;", "getHelperExceptionStackTrace", "", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getExceptionTextViaArray", "exceptionObject", "Lcom/sun/jdi/ObjectReference;", "getExceptionTextFromStackTraceValues", "stackTraceValues", "", "Lcom/sun/jdi/Value;", "keepLines", "", "getMethodHandlesImplLookup", "intellij.java.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMethodInvokeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodInvokeUtils.kt\ncom/intellij/debugger/engine/MethodInvokeUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,206:1\n13#2:207\n*S KotlinDebug\n*F\n+ 1 MethodInvokeUtils.kt\ncom/intellij/debugger/engine/MethodInvokeUtils\n*L\n50#1:207\n*E\n"})
public final class MethodInvokeUtils {
    @NotNull
    public static final MethodInvokeUtils INSTANCE = new MethodInvokeUtils();
    @NotNull
    private static final Key<Boolean> INVOKE_WITH_HELPER_KEY = new Key("invoke.with.helper");

    private MethodInvokeUtils() {
    }

    @NotNull
    public static final Key<Boolean> getINVOKE_WITH_HELPER_KEY$intellij_java_debugger_impl() {
        return INVOKE_WITH_HELPER_KEY;
    }

    @JvmStatic
    public static /* synthetic */ void getINVOKE_WITH_HELPER_KEY$intellij_java_debugger_impl$annotations() {
    }

    @Nullable
    public final String getHelperExceptionStackTrace(@NotNull EvaluationContextImpl evaluationContext, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)((Object)evaluationContext), (String)"evaluationContext");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!(e instanceof EvaluateException)) {
            return null;
        }
        ObjectReference objectReference = ((EvaluateException)((Object)e)).getExceptionFromTargetVM();
        if (objectReference == null) {
            return null;
        }
        ObjectReference exceptionFromTargetVM = objectReference;
        ArrayReference arrayReference = DebuggerUtilsImpl.invokeThrowableGetStackTrace(exceptionFromTargetVM, evaluationContext, true);
        List<Value> values = arrayReference != null ? arrayReference.getValues() : null;
        Collection collection = values;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int currentStackDepth = DebugProcessImpl.getEvaluationThread(evaluationContext).frameCount();
        int keepLines = values.size() <= currentStackDepth ? values.size() : values.size() - currentStackDepth;
        String stackTraceString = this.getExceptionTextFromStackTraceValues(evaluationContext, exceptionFromTargetVM, values, keepLines);
        if (values.size() <= currentStackDepth) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(MethodInvokeUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Invalid helper stack (expected currentStackDepth = " + currentStackDepth + ") : " + stackTraceString);
        }
        return stackTraceString;
    }

    @JvmStatic
    @Nullable
    public static final String getExceptionTextViaArray(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference exceptionObject) {
        Intrinsics.checkNotNullParameter((Object)((Object)evaluationContext), (String)"evaluationContext");
        Intrinsics.checkNotNullParameter((Object)exceptionObject, (String)"exceptionObject");
        ArrayReference arrayReference = DebuggerUtilsImpl.invokeThrowableGetStackTrace(exceptionObject, evaluationContext, true);
        List<Value> values = arrayReference != null ? arrayReference.getValues() : null;
        Collection collection = values;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return MethodInvokeUtils.getExceptionTextFromStackTraceValues$default(INSTANCE, evaluationContext, exceptionObject, values, 0, 8, null);
    }

    private final String getExceptionTextFromStackTraceValues(EvaluationContextImpl evaluationContext, ObjectReference exceptionObject, List<? extends Value> stackTraceValues, int keepLines) {
        return DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)exceptionObject) + "\n" + SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)stackTraceValues), (int)keepLines), arg_0 -> MethodInvokeUtils.getExceptionTextFromStackTraceValues$lambda$0(evaluationContext, arg_0)), (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null);
    }

    static /* synthetic */ String getExceptionTextFromStackTraceValues$default(MethodInvokeUtils methodInvokeUtils, EvaluationContextImpl evaluationContextImpl, ObjectReference objectReference, List list, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        return methodInvokeUtils.getExceptionTextFromStackTraceValues(evaluationContextImpl, objectReference, list, n);
    }

    @Nullable
    public final ObjectReference getMethodHandlesImplLookup(@NotNull EvaluationContextImpl evaluationContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)evaluationContext), (String)"evaluationContext");
        ReferenceType theClass = evaluationContext.getDebugProcess().findClass(evaluationContext, "java.lang.invoke.MethodHandles$Lookup", null);
        Field theField = DebuggerUtils.findField((ReferenceType)theClass, (String)"IMPL_LOOKUP");
        ReferenceType referenceType = theClass;
        Value value = referenceType != null ? referenceType.getValue(theField) : null;
        return value instanceof ObjectReference ? (ObjectReference)value : null;
    }

    private static final String getExceptionTextFromStackTraceValues$lambda$0(EvaluationContextImpl $evaluationContext, Value it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\tat " + DebuggerUtils.getValueAsString((EvaluationContext)$evaluationContext, (Value)it);
    }
}

