/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.FieldReferringObject;
import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.SimpleReferringObject;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface ReferringObjectsProvider {
    public static final ReferringObjectsProvider BASIC_JDI = new ReferringObjectsProvider(){

        @Override
        @NotNull
        public @Unmodifiable List<ReferringObject> getReferringObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference value, long limit) {
            if (evaluationContext == null) {
                1.$$$reportNull$$$0(0);
            }
            if (value == null) {
                1.$$$reportNull$$$0(1);
            }
            List list = ContainerUtil.map(value.referringObjects(limit), x -> this.asReferringObject((ObjectReference)x, value));
            if (list == null) {
                1.$$$reportNull$$$0(2);
            }
            return list;
        }

        private ReferringObject asReferringObject(@NotNull ObjectReference referrer, @NotNull ObjectReference referee) {
            Field field;
            if (referrer == null) {
                1.$$$reportNull$$$0(3);
            }
            if (referee == null) {
                1.$$$reportNull$$$0(4);
            }
            if ((field = 1.findField(referee, referrer)) != null) {
                return new FieldReferringObject(referrer, field);
            }
            return new SimpleReferringObject(referrer);
        }

        @Nullable
        private static Field findField(@NotNull Value value, @NotNull ObjectReference reference) {
            if (value == null) {
                1.$$$reportNull$$$0(5);
            }
            if (reference == null) {
                1.$$$reportNull$$$0(6);
            }
            for (Field field : reference.referenceType().allFields()) {
                if (reference.getValue(field) != value) continue;
                return field;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/ReferringObjectsProvider$1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referrer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referee";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/ReferringObjectsProvider$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferringObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferringObjects";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "asReferringObject";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findField";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    };

    @NotNull
    public @Unmodifiable List<ReferringObject> getReferringObjects(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2, long var3) throws EvaluateException;
}

