/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuspendManagerUtil {
    private static final Logger LOG = Logger.getInstance(SuspendManagerUtil.class);

    @Nullable
    public static SuspendContextImpl findContextByThread(@NotNull SuspendManager suspendManager, @Nullable ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            SuspendManagerUtil.$$$reportNull$$$0(0);
        }
        SuspendManagerImpl suspendManagerImpl = (SuspendManagerImpl)suspendManager;
        if (thread == null) {
            return (SuspendContextImpl)((Object)ContainerUtil.getFirstItem(suspendManagerImpl.getSuspendAllContexts()));
        }
        for (SuspendContextImpl context : suspendManager.getEventContexts()) {
            if (context.getEventThread() != thread && context.getSuspendPolicy() != 2 || context.isExplicitlyResumed(thread)) continue;
            return context;
        }
        return null;
    }

    @Nullable
    public static SuspendContextImpl getContextForEvaluation(@NotNull SuspendManager suspendManager) {
        SuspendContextImpl currentSuspendContext;
        DebuggerCommandImpl currentCommand;
        if (suspendManager == null) {
            SuspendManagerUtil.$$$reportNull$$$0(1);
        }
        if ((currentCommand = DebuggerManagerThreadImpl.getCurrentCommand()) instanceof SuspendContextCommandImpl) {
            SuspendContextCommandImpl suspendContextCommand = (SuspendContextCommandImpl)currentCommand;
            v0 = suspendContextCommand.getSuspendContext();
        } else {
            v0 = currentSuspendContext = null;
        }
        if (currentSuspendContext != null) {
            if (currentSuspendContext.isResumed()) {
                currentSuspendContext.getDebugProcess().logError("Cannot use context " + String.valueOf((Object)currentSuspendContext) + " for evaluation");
                return null;
            }
            return currentSuspendContext;
        }
        ((SuspendManagerImpl)suspendManager).getDebugProcess().logError("Evaluation should be performed in the SuspendContextCommandImpl, so evaluation context should come from there");
        return suspendManager.getPausedContext();
    }

    @NotNull
    public static Set<SuspendContextImpl> getSuspendingContexts(@NotNull SuspendManager suspendManager, @NotNull ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            SuspendManagerUtil.$$$reportNull$$$0(2);
        }
        if (thread == null) {
            SuspendManagerUtil.$$$reportNull$$$0(3);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Set set = ((StreamEx)StreamEx.of(suspendManager.getEventContexts()).filter(suspendContext -> suspendContext.suspends(thread))).toSet();
        if (set == null) {
            SuspendManagerUtil.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nullable
    public static SuspendContextImpl getSuspendingContext(@NotNull SuspendManager suspendManager, @NotNull ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            SuspendManagerUtil.$$$reportNull$$$0(5);
        }
        if (thread == null) {
            SuspendManagerUtil.$$$reportNull$$$0(6);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return (SuspendContextImpl)((Object)ContainerUtil.find(suspendManager.getEventContexts(), suspendContext -> suspendContext.suspends(thread)));
    }

    @ApiStatus.Internal
    @Nullable
    public static SuspendContextImpl getPausedSuspendingContext(@NotNull SuspendManager suspendManager, @NotNull ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            SuspendManagerUtil.$$$reportNull$$$0(7);
        }
        if (thread == null) {
            SuspendManagerUtil.$$$reportNull$$$0(8);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List<SuspendContextImpl> pausedContexts = suspendManager.getPausedContexts();
        SuspendContextImpl context = (SuspendContextImpl)((Object)ContainerUtil.find(pausedContexts, suspendContext -> suspendContext.getEventThread() == thread && suspendContext.suspends(thread)));
        if (context != null) {
            return context;
        }
        return (SuspendContextImpl)((Object)ContainerUtil.find(pausedContexts, suspendContext -> suspendContext.suspends(thread)));
    }

    public static void switchToThreadInSuspendAllContext(final @NotNull SuspendContextImpl suspendAllContext, final @NotNull ThreadReferenceProxyImpl threadProxy) {
        if (suspendAllContext == null) {
            SuspendManagerUtil.$$$reportNull$$$0(9);
        }
        if (threadProxy == null) {
            SuspendManagerUtil.$$$reportNull$$$0(10);
        }
        assert (suspendAllContext.getSuspendPolicy() == 2);
        final DebugProcessImpl debugProcess = suspendAllContext.getDebugProcess();
        suspendAllContext.getManagerThread().schedule(new SuspendContextCommandImpl(suspendAllContext){

            @Override
            public void contextAction(@NotNull SuspendContextImpl c) {
                if (c == null) {
                    1.$$$reportNull$$$0(0);
                }
                DebuggerSession session = debugProcess.getSession();
                DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext(session, suspendAllContext, threadProxy, null);
                DebuggerInvocationUtil.invokeLater(debugProcess.getProject(), () -> session.getContextManager().setState(debuggerContext, DebuggerSession.State.PAUSED, DebuggerSession.Event.CONTEXT, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/debugger/engine/SuspendManagerUtil$1", "contextAction"));
            }
        });
    }

    public static void restoreAfterResume(SuspendContextImpl context, Object resumeData) {
        SuspendManager suspendManager = context.getDebugProcess().getSuspendManager();
        ResumeData data = (ResumeData)resumeData;
        ThreadReferenceProxyImpl thread = context.getThread();
        if (data.myIsFrozen && !suspendManager.isFrozen(thread)) {
            suspendManager.freezeThread(thread);
        }
        LOG.debug("RestoreAfterResume SuspendContextImpl...");
        if (data.myResumedThreads != null) {
            data.myResumedThreads.forEach(ThreadReferenceProxyImpl::resume);
        }
    }

    public static Object prepareForResume(SuspendContextImpl context) {
        SuspendManager suspendManager = context.getDebugProcess().getSuspendManager();
        ThreadReferenceProxyImpl thread = context.getThread();
        Set<ThreadReferenceProxyImpl> resumedThreads = context.myResumedThreads != null ? Set.copyOf(context.myResumedThreads) : null;
        ResumeData resumeData = new ResumeData(thread != null && suspendManager.isFrozen(thread), resumedThreads);
        if (resumeData.myIsFrozen) {
            suspendManager.unfreezeThread(thread);
        }
        LOG.debug("Resuming SuspendContextImpl...");
        if (context.myResumedThreads != null) {
            resumeData.myResumedThreads.forEach(ThreadReferenceProxyImpl::suspend);
        }
        return resumeData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendManager";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/SuspendManagerUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendAllContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/SuspendManagerUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendingContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findContextByThread";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContextForEvaluation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuspendingContexts";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuspendingContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPausedSuspendingContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "switchToThreadInSuspendAllContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class ResumeData {
        final boolean myIsFrozen;
        final Set<ThreadReferenceProxyImpl> myResumedThreads;

        ResumeData(boolean isFrozen, Set<ThreadReferenceProxyImpl> resumedThreads) {
            this.myIsFrozen = isFrozen;
            this.myResumedThreads = resumedThreads;
        }
    }
}

