/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.concurrency.JobScheduler;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerDiagnosticsUtil;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadBlockedMonitor {
    private static final Logger LOG = Logger.getInstance(ThreadBlockedMonitor.class);
    private final Collection<ThreadReferenceProxy> myWatchedThreads = new HashSet<ThreadReferenceProxy>();
    private ScheduledFuture<?> myTask;
    private final DebugProcessImpl myProcess;
    @Nullable
    protected InvocationWatcherNewImpl myInvocationWatching = null;
    private boolean myIsInResumeAllMode = false;

    public ThreadBlockedMonitor(DebugProcessImpl process, Disposable disposable) {
        this.myProcess = process;
        Disposer.register((Disposable)disposable, this::cancelTask);
    }

    static boolean isNewSuspendAllInvocationWatcher() {
        return Registry.is((String)"debugger.new.invocation.watcher");
    }

    static int getSingleThreadedEvaluationThreshold() {
        return Registry.intValue((String)"debugger.evaluate.single.threaded.timeout", (int)1000);
    }

    @Nullable
    protected InvocationWatcher startInvokeWatching(int invokePolicy, @Nullable ThreadReferenceProxyImpl thread, @NotNull SuspendContextImpl context) {
        if (context == null) {
            ThreadBlockedMonitor.$$$reportNull$$$0(0);
        }
        if (thread != null && ThreadBlockedMonitor.getSingleThreadedEvaluationThreshold() > 0 && context.getSuspendPolicy() == 2 && BitUtil.isSet((int)invokePolicy, (int)1)) {
            if (ThreadBlockedMonitor.isNewSuspendAllInvocationWatcher()) {
                return new InvocationWatcherNewImpl(this, thread, context);
            }
            return new InvocationWatcherOldImpl(this, thread);
        }
        return null;
    }

    public void startWatching(@Nullable ThreadReferenceProxy thread) {
        if (!Registry.is((String)"debugger.monitor.blocked.threads")) {
            return;
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread != null) {
            this.myWatchedThreads.add(thread);
            if (this.myTask == null) {
                this.myTask = JobScheduler.getScheduler().scheduleWithFixedDelay(this::checkBlockingThread, 5L, 5L, TimeUnit.SECONDS);
            }
        }
    }

    public void stopWatching(@Nullable ThreadReferenceProxy thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread != null) {
            this.myWatchedThreads.remove(thread);
        } else {
            this.myWatchedThreads.clear();
        }
        if (this.myWatchedThreads.isEmpty()) {
            this.cancelTask();
        }
    }

    private void cancelTask() {
        if (this.myTask != null) {
            this.myTask.cancel(true);
            this.myTask = null;
        }
    }

    private static void onThreadBlocked(@NotNull ThreadReference blockedThread, final @NotNull ThreadReference blockingThread, final DebugProcessImpl process) {
        if (blockedThread == null) {
            ThreadBlockedMonitor.$$$reportNull$$$0(1);
        }
        if (blockingThread == null) {
            ThreadBlockedMonitor.$$$reportNull$$$0(2);
        }
        XDebuggerManagerImpl.getNotificationGroup().createNotification(JavaDebuggerBundle.message((String)"status.thread.blocked.by", (Object[])new Object[]{blockedThread.name(), blockingThread.name()}), JavaDebuggerBundle.message((String)"status.thread.blocked.by.resume", (Object[])new Object[]{blockingThread.name()}), NotificationType.INFORMATION).setListener((notification, event) -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                notification.expire();
                process.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() {
                        ThreadReferenceProxyImpl threadProxy = VirtualMachineProxyImpl.getCurrent().getThreadReferenceProxy(blockingThread);
                        SuspendContextImpl suspendingContext = SuspendManagerUtil.getSuspendingContext(process.getSuspendManager(), threadProxy);
                        this.getCommandManagerThread().invokeNow(process.createResumeThreadCommand(suspendingContext, threadProxy));
                    }
                });
            }
        }).notify(process.getProject());
    }

    private ThreadReference getCurrentThread() {
        ThreadReferenceProxyImpl threadProxy = this.myProcess.getDebuggerContext().getThreadProxy();
        return threadProxy != null ? threadProxy.getThreadReference() : null;
    }

    private void checkBlockingThread() {
        this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void action() {
                if (ThreadBlockedMonitor.this.myWatchedThreads.isEmpty()) {
                    return;
                }
                VirtualMachineProxyImpl vmProxy = VirtualMachineProxyImpl.getCurrent();
                vmProxy.suspend();
                try {
                    List zombieThreads = ContainerUtil.filter(ThreadBlockedMonitor.this.myWatchedThreads, thread -> thread.getThreadReference().status() == 0);
                    for (ThreadReferenceProxy thread2 : zombieThreads) {
                        ThreadBlockedMonitor.this.stopWatching(thread2);
                    }
                    for (ThreadReferenceProxy thread2 : ThreadBlockedMonitor.this.myWatchedThreads) {
                        try {
                            ThreadReference blockingThread;
                            ObjectReference waitedMonitor = vmProxy.canGetCurrentContendedMonitor() ? thread2.getThreadReference().currentContendedMonitor() : null;
                            if (waitedMonitor == null || !vmProxy.canGetMonitorInfo() || (blockingThread = waitedMonitor.owningThread()) == null || blockingThread.suspendCount() <= 1 || ThreadBlockedMonitor.this.getCurrentThread() == blockingThread) continue;
                            ThreadBlockedMonitor.onThreadBlocked(thread2.getThreadReference(), blockingThread, ThreadBlockedMonitor.this.myProcess);
                        }
                        catch (ObjectCollectedException waitedMonitor) {
                        }
                        catch (IncompatibleThreadStateException e) {
                            LOG.info((Throwable)e);
                        }
                        catch (InternalException e) {
                            if (e.errorCode() == 15) continue;
                            throw e;
                            return;
                        }
                    }
                }
                finally {
                    vmProxy.resume();
                }
            }
        });
    }

    protected boolean isInResumeAllMode() {
        return this.myInvocationWatching != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockedThread";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockingThread";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/ThreadBlockedMonitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startInvokeWatching";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onThreadBlocked";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static final class InvocationWatcherNewImpl
    implements InvocationWatcher {
        private final AtomicBoolean myObsolete;
        private final AtomicBoolean myAllResumed;
        private final Future myTask;
        @Nullable
        private Future myDiagnosticsTask;
        @NotNull
        private final ThreadReferenceProxyImpl myThread;
        final SuspendContextImpl mySuspendAllContext;
        @NotNull
        private final DebugProcessImpl myProcess;
        @NotNull
        private final ThreadBlockedMonitor myThreadBlockedMonitor;

        private InvocationWatcherNewImpl(@NotNull ThreadBlockedMonitor threadBlockedMonitor, @NotNull ThreadReferenceProxyImpl thread, @NotNull SuspendContextImpl suspendAllContext) {
            if (threadBlockedMonitor == null) {
                InvocationWatcherNewImpl.$$$reportNull$$$0(0);
            }
            if (thread == null) {
                InvocationWatcherNewImpl.$$$reportNull$$$0(1);
            }
            if (suspendAllContext == null) {
                InvocationWatcherNewImpl.$$$reportNull$$$0(2);
            }
            this.myObsolete = new AtomicBoolean();
            this.myAllResumed = new AtomicBoolean();
            this.myThreadBlockedMonitor = threadBlockedMonitor;
            this.myProcess = threadBlockedMonitor.myProcess;
            this.myThread = thread;
            this.mySuspendAllContext = suspendAllContext;
            this.myTask = JobScheduler.getScheduler().schedule(this::checkInvocation, (long)ThreadBlockedMonitor.getSingleThreadedEvaluationThreshold(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void invocationFinished() {
            this.myObsolete.set(true);
            if (this.myTask.isDone() && this.myAllResumed.get()) {
                this.myThread.getVirtualMachine().suspend();
                LOG.warn("Long invocation on " + String.valueOf(this.myThread) + " has been finished");
                this.myThreadBlockedMonitor.myInvocationWatching = null;
                this.myThread.resumeImpl();
                Set<ThreadReferenceProxyImpl> resumedThreads = this.mySuspendAllContext.myResumedThreads;
                if (resumedThreads != null) {
                    for (ThreadReferenceProxyImpl thread : resumedThreads) {
                        thread.resumeImpl();
                    }
                }
                if (this.myDiagnosticsTask != null) {
                    this.myDiagnosticsTask.cancel(false);
                }
            } else {
                this.myTask.cancel(true);
            }
        }

        private void checkInvocation() {
            this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void action() {
                    if (myObsolete.get()) {
                        return;
                    }
                    VirtualMachineProxyImpl virtualMachine = myThread.getVirtualMachine();
                    virtualMachine.suspend();
                    try {
                        if (myObsolete.get()) {
                            return;
                        }
                        if (myThreadBlockedMonitor.myInvocationWatching != null) {
                            myProcess.logError("Another invocation on suspend-all thread " + String.valueOf(myThread) + " (" + String.valueOf((Object)mySuspendAllContext) + ") while the previous one was not over yet " + String.valueOf((Object)myThreadBlockedMonitor.myInvocationWatching.mySuspendAllContext));
                            return;
                        }
                        ThreadReference threadReference = myThread.getThreadReference();
                        LOG.warn("Resume other threads because long invocation detected on " + String.valueOf(myThread));
                        myThreadBlockedMonitor.myInvocationWatching = this;
                        myAllResumed.set(true);
                        myThread.suspendImpl();
                        Set<ThreadReferenceProxyImpl> resumedThreads = mySuspendAllContext.myResumedThreads;
                        if (resumedThreads != null) {
                            for (ThreadReferenceProxyImpl thread : resumedThreads) {
                                thread.suspendImpl();
                            }
                        }
                        virtualMachine.resume();
                        if (threadReference.suspendCount() != 1) {
                            Set<SuspendContextImpl> suspendingContexts = SuspendManagerUtil.getSuspendingContexts(myProcess.getSuspendManager(), myThread);
                            LOG.warn("Blocked thread detected during invocation on " + String.valueOf(myThread) + ": " + String.valueOf(suspendingContexts));
                        }
                    }
                    finally {
                        virtualMachine.resume();
                    }
                    this.scheduleDiagnostics();
                }
            });
        }

        private void scheduleDiagnostics() {
            final long delayToDiagnostics = (long)ThreadBlockedMonitor.getSingleThreadedEvaluationThreshold() * 10L;
            this.myDiagnosticsTask = JobScheduler.getScheduler().schedule(() -> {
                if (this.myObsolete.get()) {
                    return;
                }
                this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() {
                        if (myObsolete.get()) {
                            return;
                        }
                        DebuggerDiagnosticsUtil.checkThreadsConsistency(myProcess, false);
                        if (ApplicationManager.getApplication().isInternal()) {
                            myProcess.logError("Internal error, some deadlock or just very long evaluation in the code:  Long invocation on " + String.valueOf(myThread) + " for " + String.valueOf((Object)mySuspendAllContext) + " has not been finished for " + delayToDiagnostics + " ms.");
                        }
                    }
                });
            }, delayToDiagnostics, TimeUnit.MILLISECONDS);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "threadBlockedMonitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thread";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "suspendAllContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/ThreadBlockedMonitor$InvocationWatcherNewImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class InvocationWatcherOldImpl
    implements InvocationWatcher {
        private final AtomicBoolean myObsolete;
        private final AtomicBoolean myAllResumed;
        private final Future myTask;
        @NotNull
        private final ThreadReferenceProxyImpl myThread;
        @NotNull
        private final DebugProcessImpl myProcess;
        @NotNull
        private final ThreadBlockedMonitor myThreadBlockedMonitor;

        private InvocationWatcherOldImpl(@NotNull ThreadBlockedMonitor threadBlockedMonitor, @NotNull ThreadReferenceProxyImpl thread) {
            if (threadBlockedMonitor == null) {
                InvocationWatcherOldImpl.$$$reportNull$$$0(0);
            }
            if (thread == null) {
                InvocationWatcherOldImpl.$$$reportNull$$$0(1);
            }
            this.myObsolete = new AtomicBoolean();
            this.myAllResumed = new AtomicBoolean();
            this.myThreadBlockedMonitor = threadBlockedMonitor;
            this.myProcess = threadBlockedMonitor.myProcess;
            this.myThread = thread;
            this.myTask = JobScheduler.getScheduler().schedule(this::checkInvocation, (long)ThreadBlockedMonitor.getSingleThreadedEvaluationThreshold(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void invocationFinished() {
            this.myObsolete.set(true);
            if (this.myTask.isDone() && this.myAllResumed.get()) {
                this.myThread.getVirtualMachine().suspend();
                LOG.warn("Long invocation on " + String.valueOf(this.myThread) + " has been finished");
                this.myThreadBlockedMonitor.myIsInResumeAllMode = false;
                this.myThread.resumeImpl();
            } else {
                this.myTask.cancel(true);
            }
        }

        private void checkInvocation() {
            this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    if (myObsolete.get()) {
                        return;
                    }
                    VirtualMachineProxyImpl virtualMachine = myThread.getVirtualMachine();
                    virtualMachine.suspend();
                    try {
                        if (myObsolete.get()) {
                            return;
                        }
                        if (myThreadBlockedMonitor.myIsInResumeAllMode) {
                            myProcess.logError("Another invocation on suspend-all thread while the previous one was not over yet");
                            return;
                        }
                        ThreadReference threadReference = myThread.getThreadReference();
                        if (threadReference.suspendCount() == 1) {
                            LOG.warn("Resume other threads because long invocation detected on " + String.valueOf(myThread));
                            myAllResumed.set(true);
                            threadReference.suspend();
                            virtualMachine.resume();
                        } else {
                            myProcess.logError("Blocked thread detected during invocation on " + String.valueOf(myThread));
                        }
                    }
                    finally {
                        virtualMachine.resume();
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "threadBlockedMonitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thread";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/ThreadBlockedMonitor$InvocationWatcherOldImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static interface InvocationWatcher {
        public void invocationFinished();
    }
}

