/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.sun.jdi.ThreadReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0016J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u00c6\u0003J/\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020 H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/debugger/engine/TrackedSteppingData;", "", "stepCompetedStatus", "Lkotlinx/coroutines/CompletableDeferred;", "", "isSuspendAllStepping", "", "filter", "Lcom/intellij/debugger/engine/LightOrRealThreadInfo;", "<init>", "(Lkotlinx/coroutines/CompletableDeferred;ZLcom/intellij/debugger/engine/LightOrRealThreadInfo;)V", "getStepCompetedStatus", "()Lkotlinx/coroutines/CompletableDeferred;", "()Z", "getFilter", "()Lcom/intellij/debugger/engine/LightOrRealThreadInfo;", "isFit", "thread", "Lcom/intellij/debugger/engine/jdi/ThreadReferenceProxy;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "isThreadStepping", "Lcom/sun/jdi/ThreadReference;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.java.debugger.impl"})
final class TrackedSteppingData {
    @NotNull
    private final CompletableDeferred<Unit> stepCompetedStatus;
    private final boolean isSuspendAllStepping;
    @Nullable
    private final LightOrRealThreadInfo filter;

    public TrackedSteppingData(@NotNull CompletableDeferred<Unit> stepCompetedStatus, boolean isSuspendAllStepping, @Nullable LightOrRealThreadInfo filter) {
        Intrinsics.checkNotNullParameter(stepCompetedStatus, (String)"stepCompetedStatus");
        this.stepCompetedStatus = stepCompetedStatus;
        this.isSuspendAllStepping = isSuspendAllStepping;
        this.filter = filter;
    }

    @NotNull
    public final CompletableDeferred<Unit> getStepCompetedStatus() {
        return this.stepCompetedStatus;
    }

    public final boolean isSuspendAllStepping() {
        return this.isSuspendAllStepping;
    }

    @Nullable
    public final LightOrRealThreadInfo getFilter() {
        return this.filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFit(@Nullable ThreadReferenceProxy thread, @NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)suspendContext), (String)"suspendContext");
        if (thread == null) return true;
        if (this.filter == null) return false;
        ThreadReference threadReference = thread.getThreadReference();
        Intrinsics.checkNotNullExpressionValue((Object)threadReference, (String)"getThreadReference(...)");
        if (!this.filter.checkSameThread(threadReference, suspendContext)) return false;
        return true;
    }

    public final boolean isThreadStepping(@NotNull ThreadReference thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        LightOrRealThreadInfo lightOrRealThreadInfo = this.filter;
        return Intrinsics.areEqual((Object)(lightOrRealThreadInfo != null ? lightOrRealThreadInfo.getRealThread() : null), (Object)thread);
    }

    @NotNull
    public final CompletableDeferred<Unit> component1() {
        return this.stepCompetedStatus;
    }

    public final boolean component2() {
        return this.isSuspendAllStepping;
    }

    @Nullable
    public final LightOrRealThreadInfo component3() {
        return this.filter;
    }

    @NotNull
    public final TrackedSteppingData copy(@NotNull CompletableDeferred<Unit> stepCompetedStatus, boolean isSuspendAllStepping, @Nullable LightOrRealThreadInfo filter) {
        Intrinsics.checkNotNullParameter(stepCompetedStatus, (String)"stepCompetedStatus");
        return new TrackedSteppingData(stepCompetedStatus, isSuspendAllStepping, filter);
    }

    public static /* synthetic */ TrackedSteppingData copy$default(TrackedSteppingData trackedSteppingData, CompletableDeferred completableDeferred, boolean bl, LightOrRealThreadInfo lightOrRealThreadInfo, int n, Object object) {
        if ((n & 1) != 0) {
            completableDeferred = trackedSteppingData.stepCompetedStatus;
        }
        if ((n & 2) != 0) {
            bl = trackedSteppingData.isSuspendAllStepping;
        }
        if ((n & 4) != 0) {
            lightOrRealThreadInfo = trackedSteppingData.filter;
        }
        return trackedSteppingData.copy(completableDeferred, bl, lightOrRealThreadInfo);
    }

    @NotNull
    public String toString() {
        return "TrackedSteppingData(stepCompetedStatus=" + this.stepCompetedStatus + ", isSuspendAllStepping=" + this.isSuspendAllStepping + ", filter=" + this.filter + ")";
    }

    public int hashCode() {
        int result = this.stepCompetedStatus.hashCode();
        result = result * 31 + Boolean.hashCode(this.isSuspendAllStepping);
        result = result * 31 + (this.filter == null ? 0 : this.filter.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TrackedSteppingData)) {
            return false;
        }
        TrackedSteppingData trackedSteppingData = (TrackedSteppingData)other;
        if (!Intrinsics.areEqual(this.stepCompetedStatus, trackedSteppingData.stepCompetedStatus)) {
            return false;
        }
        if (this.isSuspendAllStepping != trackedSteppingData.isSuspendAllStepping) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.filter, (Object)trackedSteppingData.filter);
    }
}

